/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security;

import java.util.Set;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.keycloak.security.KeycloakSecurityHelper;
import org.apache.camel.component.keycloak.security.KeycloakSecurityPolicy;
import org.apache.camel.component.keycloak.security.KeycloakTokenIntrospector;
import org.apache.camel.support.processor.DelegateProcessor;
import org.apache.camel.util.ObjectHelper;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakSecurityProcessor
extends DelegateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakSecurityProcessor.class);
    private final KeycloakSecurityPolicy policy;

    public KeycloakSecurityProcessor(Processor processor, KeycloakSecurityPolicy policy) {
        super(processor);
        this.policy = policy;
    }

    public void process(Exchange exchange) throws Exception {
        this.beforeProcess(exchange);
        this.processNext(exchange);
    }

    protected void beforeProcess(Exchange exchange) throws Exception {
        try {
            String accessToken = this.getAccessToken(exchange);
            if (accessToken == null) {
                throw new CamelAuthorizationException("Access token not found in exchange", exchange);
            }
            if (!this.policy.getRequiredRolesAsList().isEmpty()) {
                this.validateRoles(accessToken, exchange);
            }
            if (!this.policy.getRequiredPermissionsAsList().isEmpty()) {
                this.validatePermissions(accessToken, exchange);
            }
        }
        catch (Exception e) {
            exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)this.policy.getClass().getSimpleName());
            if (e instanceof CamelAuthorizationException) {
                throw e;
            }
            throw new CamelAuthorizationException("Authorization failed", exchange, (Throwable)e);
        }
    }

    private String getAccessToken(Exchange exchange) {
        String authHeader;
        String token = (String)exchange.getIn().getHeader("CamelKeycloakAccessToken", String.class);
        if (token == null && (authHeader = (String)exchange.getIn().getHeader("Authorization", String.class)) != null && authHeader.startsWith("Bearer ")) {
            token = authHeader.substring(7);
        }
        if (token == null) {
            token = (String)exchange.getProperty("CamelKeycloakAccessToken", String.class);
        }
        return token;
    }

    private void validateRoles(String accessToken, Exchange exchange) throws Exception {
        try {
            boolean hasRequiredRoles;
            Set<String> userRoles;
            if (this.policy.isUseTokenIntrospection() && this.policy.getTokenIntrospector() != null) {
                KeycloakTokenIntrospector.IntrospectionResult introspectionResult = KeycloakSecurityHelper.introspectToken(accessToken, this.policy.getTokenIntrospector());
                if (!introspectionResult.isActive()) {
                    throw new CamelAuthorizationException("Token is not active (may be revoked or expired)", exchange);
                }
                userRoles = KeycloakSecurityHelper.extractRolesFromIntrospection(introspectionResult, this.policy.getRealm(), this.policy.getClientId());
            } else {
                AccessToken token = ObjectHelper.isEmpty((Object)this.policy.getPublicKey()) ? KeycloakSecurityHelper.parseAccessToken(accessToken) : KeycloakSecurityHelper.parseAccessToken(accessToken, this.policy.getPublicKey());
                userRoles = KeycloakSecurityHelper.extractRoles(token, this.policy.getRealm(), this.policy.getClientId());
            }
            boolean bl = hasRequiredRoles = this.policy.isAllRolesRequired() ? userRoles.containsAll(this.policy.getRequiredRolesAsList()) : this.policy.getRequiredRolesAsList().stream().anyMatch(userRoles::contains);
            if (!hasRequiredRoles) {
                String message = String.format("User does not have required roles. Required: %s, User has: %s", this.policy.getRequiredRoles(), userRoles);
                LOG.debug(message);
                throw new CamelAuthorizationException(message, exchange);
            }
            LOG.debug("Role validation successful for user with roles: {}", userRoles);
        }
        catch (Exception e) {
            if (e instanceof CamelAuthorizationException) {
                throw e;
            }
            throw new CamelAuthorizationException("Failed to validate roles", exchange, (Throwable)e);
        }
    }

    private void validatePermissions(String accessToken, Exchange exchange) throws Exception {
        try {
            boolean hasRequiredPermissions;
            Set<String> userPermissions;
            if (this.policy.isUseTokenIntrospection() && this.policy.getTokenIntrospector() != null) {
                KeycloakTokenIntrospector.IntrospectionResult introspectionResult = KeycloakSecurityHelper.introspectToken(accessToken, this.policy.getTokenIntrospector());
                if (!introspectionResult.isActive()) {
                    throw new CamelAuthorizationException("Token is not active (may be revoked or expired)", exchange);
                }
                userPermissions = KeycloakSecurityHelper.extractPermissionsFromIntrospection(introspectionResult);
            } else {
                AccessToken token = ObjectHelper.isEmpty((Object)this.policy.getPublicKey()) ? KeycloakSecurityHelper.parseAccessToken(accessToken) : KeycloakSecurityHelper.parseAccessToken(accessToken, this.policy.getPublicKey());
                userPermissions = KeycloakSecurityHelper.extractPermissions(token);
            }
            boolean bl = hasRequiredPermissions = this.policy.isAllPermissionsRequired() ? userPermissions.containsAll(this.policy.getRequiredPermissionsAsList()) : this.policy.getRequiredPermissionsAsList().stream().anyMatch(userPermissions::contains);
            if (!hasRequiredPermissions) {
                String message = String.format("User does not have required permissions. Required: %s, User has: %s", this.policy.getRequiredPermissions(), userPermissions);
                LOG.debug(message);
                throw new CamelAuthorizationException(message, exchange);
            }
            LOG.debug("Permission validation successful for user with permissions: {}", userPermissions);
        }
        catch (Exception e) {
            if (e instanceof CamelAuthorizationException) {
                throw e;
            }
            throw new CamelAuthorizationException("Failed to validate permissions", exchange, (Throwable)e);
        }
    }
}

