/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.keycloak.security.KeycloakTokenIntrospector;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeycloakSecurityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakSecurityHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private KeycloakSecurityHelper() {
    }

    public static AccessToken parseAccessToken(String tokenString) throws VerificationException {
        return KeycloakSecurityHelper.parseAccessToken(tokenString, null);
    }

    public static AccessToken parseAccessToken(String tokenString, PublicKey publicKey) throws VerificationException {
        if (publicKey != null) {
            return (AccessToken)TokenVerifier.create((String)tokenString, AccessToken.class).publicKey(publicKey).verify().getToken();
        }
        return (AccessToken)TokenVerifier.create((String)tokenString, AccessToken.class).getToken();
    }

    public static Set<String> extractRoles(AccessToken token, String realm, String clientId) {
        AccessToken.Access clientAccess;
        HashSet<String> roles = new HashSet<String>();
        if (token.getRealmAccess() != null && token.getRealmAccess().getRoles() != null) {
            roles.addAll(token.getRealmAccess().getRoles());
        }
        if (token.getResourceAccess() != null && (clientAccess = (AccessToken.Access)token.getResourceAccess().get(clientId)) != null && clientAccess.getRoles() != null) {
            roles.addAll(clientAccess.getRoles());
        }
        return roles;
    }

    public static String extractUsername(AccessToken token) {
        String username = token.getPreferredUsername();
        if (username == null) {
            username = token.getName();
        }
        if (username == null) {
            username = token.getSubject();
        }
        return username;
    }

    public static String extractEmail(AccessToken token) {
        return token.getEmail();
    }

    public static Map<String, Object> extractUserInfo(AccessToken token) {
        try {
            String tokenJson = OBJECT_MAPPER.writeValueAsString((Object)token);
            JsonNode tokenNode = OBJECT_MAPPER.readTree(tokenJson);
            return (Map)OBJECT_MAPPER.convertValue((Object)tokenNode, Map.class);
        }
        catch (Exception e) {
            LOG.warn("Failed to extract user info from token", (Throwable)e);
            return Map.of("sub", token.getSubject() != null ? token.getSubject() : "", "preferred_username", token.getPreferredUsername() != null ? token.getPreferredUsername() : "", "email", token.getEmail() != null ? token.getEmail() : "");
        }
    }

    public static boolean isTokenExpired(AccessToken token) {
        if (token.getExp() == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        return token.getExp() < currentTime;
    }

    public static boolean isTokenActive(AccessToken token) {
        if (KeycloakSecurityHelper.isTokenExpired(token)) {
            return false;
        }
        if (token.getNbf() != null) {
            long currentTime = System.currentTimeMillis() / 1000L;
            return token.getNbf() <= currentTime;
        }
        return true;
    }

    public static Set<String> extractPermissions(AccessToken token) {
        String scopesString;
        Object scopesClaim;
        HashSet<String> permissions = new HashSet<String>();
        Object permissionsClaim = token.getOtherClaims().get("permissions");
        if (permissionsClaim instanceof Collection) {
            Collection permissionsCollection = (Collection)permissionsClaim;
            permissions.addAll(permissionsCollection);
        }
        if ((scopesClaim = token.getOtherClaims().get("scope")) instanceof String && !(scopesString = (String)scopesClaim).isEmpty()) {
            permissions.addAll(Arrays.asList(scopesString.split(" ")));
        }
        return permissions;
    }

    public static KeycloakTokenIntrospector.IntrospectionResult introspectToken(String token, KeycloakTokenIntrospector tokenIntrospector) throws IOException {
        return tokenIntrospector.introspect(token);
    }

    public static Set<String> extractRolesFromIntrospection(KeycloakTokenIntrospector.IntrospectionResult introspectionResult, String realm, String clientId) {
        Map clientAccessMap;
        Object clientRoles;
        Map resourceAccessMap;
        Object clientAccess;
        Object resourceAccess;
        Map realmAccessMap;
        Object realmRoles;
        HashSet<String> roles = new HashSet<String>();
        Object realmAccess = introspectionResult.getClaim("realm_access");
        if (realmAccess instanceof Map && (realmRoles = (realmAccessMap = (Map)realmAccess).get("roles")) instanceof Collection) {
            Collection realmRolesCollection = (Collection)realmRoles;
            roles.addAll(realmRolesCollection);
        }
        if ((resourceAccess = introspectionResult.getClaim("resource_access")) instanceof Map && (clientAccess = (resourceAccessMap = (Map)resourceAccess).get(clientId)) instanceof Map && (clientRoles = (clientAccessMap = (Map)clientAccess).get("roles")) instanceof Collection) {
            Collection clientRolesCollection = (Collection)clientRoles;
            roles.addAll(clientRolesCollection);
        }
        return roles;
    }

    public static Set<String> extractPermissionsFromIntrospection(KeycloakTokenIntrospector.IntrospectionResult introspectionResult) {
        String scope;
        HashSet<String> permissions = new HashSet<String>();
        Object permissionsClaim = introspectionResult.getClaim("permissions");
        if (permissionsClaim instanceof Collection) {
            Collection permissionsCollection = (Collection)permissionsClaim;
            permissions.addAll(permissionsCollection);
        }
        if ((scope = introspectionResult.getScope()) != null && !scope.isEmpty()) {
            permissions.addAll(Arrays.asList(scope.split(" ")));
        }
        return permissions;
    }
}

