/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakConsumer.class);
    private static final int MAX_FINGERPRINT_CACHE_SIZE = 1000;
    private Long lastEventTime;
    private final Set<String> processedEventFingerprints = new HashSet<String>();

    public KeycloakConsumer(KeycloakEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public KeycloakEndpoint getEndpoint() {
        return (KeycloakEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Started Keycloak consumer for realm: {}, event type: {}", (Object)this.getEndpoint().getConfiguration().getRealm(), (Object)this.getEndpoint().getConfiguration().getEventType());
    }

    protected int poll() throws Exception {
        Queue<Exchange> queue = "admin-events".equalsIgnoreCase(this.getEndpoint().getConfiguration().getEventType()) ? this.pollAdminEvents() : this.pollEvents();
        return this.processBatch(CastUtils.cast(queue));
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        Exchange exchange;
        int total = exchanges.size();
        int processed = 0;
        for (int i = 0; i < total && this.isBatchAllowed() && (exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll())) != null; ++i) {
            try {
                this.getProcessor().process(exchange);
                ++processed;
                continue;
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
        return processed;
    }

    private Queue<Exchange> pollEvents() throws Exception {
        Keycloak keycloakClient = this.getEndpoint().getKeycloakClient();
        KeycloakConfiguration config = this.getEndpoint().getConfiguration();
        String realm = config.getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Realm must be specified for consuming events");
        }
        List<String> eventTypes = this.parseCommaSeparatedList(config.getTypes());
        List events = keycloakClient.realm(realm).getEvents(eventTypes, config.getClient(), config.getUser(), config.getDateFrom(), config.getDateTo(), config.getIpAddress(), Integer.valueOf(config.getFirst()), Integer.valueOf(config.getMaxResults()));
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        long highestEventTime = this.lastEventTime != null ? this.lastEventTime : 0L;
        for (EventRepresentation event : events) {
            long eventTime = event.getTime();
            if (this.lastEventTime != null && eventTime < this.lastEventTime) continue;
            String fingerprint = this.getEventFingerprint(event);
            if (this.processedEventFingerprints.contains(fingerprint)) {
                LOG.trace("Skipping already processed event: {}", (Object)fingerprint);
                continue;
            }
            Exchange exchange = this.createExchange(false);
            exchange.getIn().setBody((Object)event);
            exchange.getIn().setHeader("CamelKeycloakEventType", (Object)"event");
            exchange.getIn().setHeader("CamelKeycloakEventId", (Object)event.getTime());
            exchange.getIn().setHeader("CamelKeycloakRealmName", (Object)realm);
            queue.add(exchange);
            this.processedEventFingerprints.add(fingerprint);
            if (eventTime > highestEventTime) {
                highestEventTime = eventTime;
            }
            if (this.processedEventFingerprints.size() <= 1000) continue;
            this.processedEventFingerprints.clear();
            LOG.debug("Cleared fingerprint cache due to size limit");
        }
        if (highestEventTime > (this.lastEventTime != null ? this.lastEventTime : 0L)) {
            this.processedEventFingerprints.clear();
            this.lastEventTime = highestEventTime;
            LOG.debug("Updated last event time to: {}", (Object)this.lastEventTime);
        }
        return queue;
    }

    private String getEventFingerprint(EventRepresentation event) {
        return event.getTime() + "|" + event.getType() + "|" + (event.getUserId() != null ? event.getUserId() : "") + "|" + (event.getSessionId() != null ? event.getSessionId() : "") + "|" + (event.getIpAddress() != null ? event.getIpAddress() : "");
    }

    private Queue<Exchange> pollAdminEvents() throws Exception {
        Keycloak keycloakClient = this.getEndpoint().getKeycloakClient();
        KeycloakConfiguration config = this.getEndpoint().getConfiguration();
        String realm = config.getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Realm must be specified for consuming admin events");
        }
        List<String> adminOperationTypes = this.parseCommaSeparatedList(config.getOperationTypes());
        List adminEvents = keycloakClient.realm(realm).getAdminEvents(adminOperationTypes, config.getAuthRealmFilter(), config.getAuthClient(), config.getAuthUser(), config.getAuthIpAddress(), config.getResourcePath(), config.getDateFrom(), config.getDateTo(), Integer.valueOf(config.getFirst()), Integer.valueOf(config.getMaxResults()));
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        long highestEventTime = this.lastEventTime != null ? this.lastEventTime : 0L;
        for (AdminEventRepresentation adminEvent : adminEvents) {
            long eventTime = adminEvent.getTime();
            if (this.lastEventTime != null && eventTime < this.lastEventTime) continue;
            String fingerprint = this.getAdminEventFingerprint(adminEvent);
            if (this.processedEventFingerprints.contains(fingerprint)) {
                LOG.trace("Skipping already processed admin event: {}", (Object)fingerprint);
                continue;
            }
            Exchange exchange = this.createExchange(false);
            exchange.getIn().setBody((Object)adminEvent);
            exchange.getIn().setHeader("CamelKeycloakEventType", (Object)"admin-event");
            exchange.getIn().setHeader("CamelKeycloakEventId", (Object)adminEvent.getTime());
            exchange.getIn().setHeader("CamelKeycloakRealmName", (Object)realm);
            queue.add(exchange);
            this.processedEventFingerprints.add(fingerprint);
            if (eventTime > highestEventTime) {
                highestEventTime = eventTime;
            }
            if (this.processedEventFingerprints.size() <= 1000) continue;
            this.processedEventFingerprints.clear();
            LOG.debug("Cleared fingerprint cache due to size limit");
        }
        if (highestEventTime > (this.lastEventTime != null ? this.lastEventTime : 0L)) {
            this.processedEventFingerprints.clear();
            this.lastEventTime = highestEventTime;
            LOG.debug("Updated last admin event time to: {}", (Object)this.lastEventTime);
        }
        return queue;
    }

    private String getAdminEventFingerprint(AdminEventRepresentation event) {
        return event.getTime() + "|" + (event.getOperationType() != null ? event.getOperationType() : "") + "|" + (event.getResourceType() != null ? event.getResourceType() : "") + "|" + (event.getResourcePath() != null ? event.getResourcePath() : "") + "|" + (event.getAuthDetails() != null && event.getAuthDetails().getUserId() != null ? event.getAuthDetails().getUserId() : "");
    }

    private List<String> parseCommaSeparatedList(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : value.split(",")) {
            String trimmed = item.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result.isEmpty() ? null : result;
    }
}

