/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="keycloak")
public class KeycloakComponent
extends DefaultComponent {
    @Metadata
    private KeycloakConfiguration configuration = new KeycloakConfiguration();

    public KeycloakComponent() {
        this(null);
    }

    public KeycloakComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KeycloakConfiguration configuration = this.configuration != null ? this.configuration.copy() : new KeycloakConfiguration();
        configuration.setLabel(remaining);
        KeycloakEndpoint endpoint = new KeycloakEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getKeycloakClient() == null && (configuration.getServerUrl() == null || configuration.getAccessToken() == null && configuration.getUsername() == null && configuration.getClientId() == null)) {
            throw new IllegalArgumentException("Keycloak client or serverUrl with authentication credentials (accessToken, username/password, or clientId/clientSecret) must be specified");
        }
        return endpoint;
    }

    public KeycloakConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KeycloakConfiguration configuration) {
        this.configuration = configuration;
    }
}

