/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak.security;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.keycloak.security.KeycloakSecurityProcessor;
import org.apache.camel.spi.AuthorizationPolicy;
import org.keycloak.admin.client.Keycloak;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakSecurityPolicy
implements AuthorizationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakSecurityPolicy.class);
    private String serverUrl;
    private String realm;
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private List<String> requiredRoles = new ArrayList<String>();
    private List<String> requiredPermissions = new ArrayList<String>();
    private boolean allRolesRequired = true;
    private boolean allPermissionsRequired = true;
    private boolean useResourceOwnerPasswordCredentials = false;
    private PublicKey publicKey;
    private Keycloak keycloakClient;

    public KeycloakSecurityPolicy() {
    }

    public KeycloakSecurityPolicy(String serverUrl, String realm, String clientId, String clientSecret) {
        this();
        this.serverUrl = serverUrl;
        this.realm = realm;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public KeycloakSecurityPolicy(String serverUrl, String realm, String clientId, String username, String password) {
        this();
        this.serverUrl = serverUrl;
        this.realm = realm;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.useResourceOwnerPasswordCredentials = true;
    }

    public void beforeWrap(Route route, NamedNode definition) {
        if (this.keycloakClient == null) {
            this.initializeKeycloakClient();
        }
    }

    public Processor wrap(Route route, Processor processor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Securing route {} using Keycloak policy {}", (Object)route.getRouteId(), (Object)this);
        }
        return new KeycloakSecurityProcessor(processor, this);
    }

    private void initializeKeycloakClient() {
        if (this.useResourceOwnerPasswordCredentials && this.username != null && this.password != null) {
            this.keycloakClient = Keycloak.getInstance((String)this.serverUrl, (String)this.realm, (String)this.username, (String)this.password, (String)this.clientId);
        } else if (this.clientSecret != null) {
            this.keycloakClient = Keycloak.getInstance((String)this.serverUrl, (String)this.realm, (String)this.clientId, (String)this.clientSecret);
        } else {
            throw new IllegalArgumentException("Either clientSecret or username/password must be provided for Keycloak authentication");
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getRequiredRoles() {
        return this.requiredRoles;
    }

    public void setRequiredRoles(List<String> requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    public List<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public void setRequiredPermissions(List<String> requiredPermissions) {
        this.requiredPermissions = requiredPermissions;
    }

    public boolean isAllRolesRequired() {
        return this.allRolesRequired;
    }

    public void setAllRolesRequired(boolean allRolesRequired) {
        this.allRolesRequired = allRolesRequired;
    }

    public boolean isAllPermissionsRequired() {
        return this.allPermissionsRequired;
    }

    public void setAllPermissionsRequired(boolean allPermissionsRequired) {
        this.allPermissionsRequired = allPermissionsRequired;
    }

    public boolean isUseResourceOwnerPasswordCredentials() {
        return this.useResourceOwnerPasswordCredentials;
    }

    public void setUseResourceOwnerPasswordCredentials(boolean useResourceOwnerPasswordCredentials) {
        this.useResourceOwnerPasswordCredentials = useResourceOwnerPasswordCredentials;
    }

    public Keycloak getKeycloakClient() {
        return this.keycloakClient;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }
}

