/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakEndpoint;
import org.apache.camel.component.keycloak.KeycloakOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakProducer.class);
    public static final String MISSING_REALM_NAME = "Realm name must be specified";
    public static final String MISSING_USER_NAME = "Username must be specified";
    public static final String MISSING_ROLE_NAME = "Role name must be specified";
    public static final String MISSING_USER_ID = "User ID must be specified";
    public static final String MISSING_ROLE_ID = "Role ID must be specified";
    public static final String MISSING_GROUP_NAME = "Group name must be specified";
    public static final String MISSING_GROUP_ID = "Group ID must be specified";
    public static final String MISSING_CLIENT_ID = "Client ID must be specified";
    public static final String MISSING_CLIENT_UUID = "Client UUID must be specified";
    public static final String MISSING_PASSWORD = "Password must be specified";
    private transient String keycloakProducerToString;

    public KeycloakProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        KeycloakOperations operation = this.determineOperation(exchange);
        if (operation == null) {
            throw new IllegalArgumentException("Operation must be provided");
        }
        switch (operation) {
            case createRealm: {
                this.createRealm(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteRealm: {
                this.deleteRealm(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getRealm: {
                this.getRealm(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateRealm: {
                this.updateRealm(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createUser: {
                this.createUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteUser: {
                this.deleteUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getUser: {
                this.getUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateUser: {
                this.updateUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listUsers: {
                this.listUsers(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case searchUsers: {
                this.searchUsers(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createRole: {
                this.createRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteRole: {
                this.deleteRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getRole: {
                this.getRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateRole: {
                this.updateRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listRoles: {
                this.listRoles(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case assignRoleToUser: {
                this.assignRoleToUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case removeRoleFromUser: {
                this.removeRoleFromUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getUserRoles: {
                this.getUserRoles(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createGroup: {
                this.createGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteGroup: {
                this.deleteGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getGroup: {
                this.getGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateGroup: {
                this.updateGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listGroups: {
                this.listGroups(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case addUserToGroup: {
                this.addUserToGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case removeUserFromGroup: {
                this.removeUserFromGroup(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listUserGroups: {
                this.listUserGroups(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createClient: {
                this.createClient(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteClient: {
                this.deleteClient(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getClient: {
                this.getClient(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateClient: {
                this.updateClient(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listClients: {
                this.listClients(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case resetUserPassword: {
                this.resetUserPassword(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createClientRole: {
                this.createClientRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteClientRole: {
                this.deleteClientRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getClientRole: {
                this.getClientRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateClientRole: {
                this.updateClientRole(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listClientRoles: {
                this.listClientRoles(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case assignClientRoleToUser: {
                this.assignClientRoleToUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case removeClientRoleFromUser: {
                this.removeClientRoleFromUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listUserSessions: {
                this.listUserSessions(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case logoutUser: {
                this.logoutUser(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case createClientScope: {
                this.createClientScope(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case deleteClientScope: {
                this.deleteClientScope(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case getClientScope: {
                this.getClientScope(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case updateClientScope: {
                this.updateClientScope(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            case listClientScopes: {
                this.listClientScopes(this.getEndpoint().getKeycloakClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + String.valueOf((Object)operation));
            }
        }
    }

    private KeycloakOperations determineOperation(Exchange exchange) {
        KeycloakOperations operation = (KeycloakOperations)((Object)exchange.getIn().getHeader("CamelKeycloakOperation", KeycloakOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected KeycloakConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.keycloakProducerToString == null) {
            this.keycloakProducerToString = "KeycloakProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.keycloakProducerToString;
    }

    public KeycloakEndpoint getEndpoint() {
        return (KeycloakEndpoint)super.getEndpoint();
    }

    private void createRealm(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RealmRepresentation) {
                keycloakClient.realms().create((RealmRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Realm created successfully");
            }
        } else {
            RealmRepresentation realm = new RealmRepresentation();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakRealmName"))) {
                throw new IllegalArgumentException(MISSING_REALM_NAME);
            }
            String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
            realm.setRealm(realmName);
            realm.setEnabled(Boolean.valueOf(true));
            keycloakClient.realms().create(realm);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)"Realm created successfully");
        }
    }

    private void deleteRealm(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        keycloakClient.realm(realmName).remove();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Realm deleted successfully");
    }

    private void getRealm(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        RealmRepresentation realm = keycloakClient.realm(realmName).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)realm);
    }

    private void updateRealm(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RealmRepresentation) {
                keycloakClient.realm(realmName).update((RealmRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Realm updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update realm requires POJO request with RealmRepresentation");
        }
    }

    private void createUser(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UserRepresentation) {
                Response response = keycloakClient.realm(realmName).users().create((UserRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)response);
            }
        } else {
            UserRepresentation user = new UserRepresentation();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakUsername"))) {
                String username = (String)exchange.getIn().getHeader("CamelKeycloakUsername", String.class);
                user.setUsername(username);
                user.setEnabled(Boolean.valueOf(true));
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakUserEmail"))) {
                    user.setEmail((String)exchange.getIn().getHeader("CamelKeycloakUserEmail", String.class));
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakUserFirstName"))) {
                    user.setFirstName((String)exchange.getIn().getHeader("CamelKeycloakUserFirstName", String.class));
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakUserLastName"))) {
                    user.setLastName((String)exchange.getIn().getHeader("CamelKeycloakUserLastName", String.class));
                }
            } else {
                throw new IllegalArgumentException(MISSING_USER_NAME);
            }
            Response response = keycloakClient.realm(realmName).users().create(user);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)response);
        }
    }

    private void deleteUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        Response response = keycloakClient.realm(realmName).users().delete(userId);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void getUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        UserRepresentation user = keycloakClient.realm(realmName).users().get(userId).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)user);
    }

    private void updateUser(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UserRepresentation) {
                keycloakClient.realm(realmName).users().get(userId).update((UserRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"User updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update user requires POJO request with UserRepresentation");
        }
    }

    private void listUsers(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        List users = keycloakClient.realm(realmName).users().list();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)users);
    }

    private void createRole(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RoleRepresentation) {
                keycloakClient.realm(realmName).roles().create((RoleRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Role created successfully");
            }
        } else {
            RoleRepresentation role = new RoleRepresentation();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakRoleName"))) {
                String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
                role.setName(roleName);
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakRoleDescription"))) {
                    role.setDescription((String)exchange.getIn().getHeader("CamelKeycloakRoleDescription", String.class));
                }
            } else {
                throw new IllegalArgumentException(MISSING_ROLE_NAME);
            }
            keycloakClient.realm(realmName).roles().create(role);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)"Role created successfully");
        }
    }

    private void deleteRole(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        keycloakClient.realm(realmName).roles().deleteRole(roleName);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Role deleted successfully");
    }

    private void getRole(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).roles().get(roleName).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)role);
    }

    private void updateRole(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RoleRepresentation) {
                keycloakClient.realm(realmName).roles().get(roleName).update((RoleRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Role updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update role requires POJO request with RoleRepresentation");
        }
    }

    private void listRoles(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        List roles = keycloakClient.realm(realmName).roles().list();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)roles);
    }

    private void assignRoleToUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).roles().get(roleName).toRepresentation();
        keycloakClient.realm(realmName).users().get(userId).roles().realmLevel().add(List.of(role));
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Role assigned to user successfully");
    }

    private void removeRoleFromUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).roles().get(roleName).toRepresentation();
        keycloakClient.realm(realmName).users().get(userId).roles().realmLevel().remove(List.of(role));
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Role removed from user successfully");
    }

    private void createGroup(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GroupRepresentation) {
                Response response = keycloakClient.realm(realmName).groups().add((GroupRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)response);
            }
        } else {
            GroupRepresentation group = new GroupRepresentation();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakGroupName"))) {
                throw new IllegalArgumentException(MISSING_GROUP_NAME);
            }
            String groupName = (String)exchange.getIn().getHeader("CamelKeycloakGroupName", String.class);
            group.setName(groupName);
            Response response = keycloakClient.realm(realmName).groups().add(group);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)response);
        }
    }

    private void deleteGroup(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String groupId = (String)exchange.getIn().getHeader("CamelKeycloakGroupId", String.class);
        if (ObjectHelper.isEmpty((String)groupId)) {
            throw new IllegalArgumentException(MISSING_GROUP_ID);
        }
        keycloakClient.realm(realmName).groups().group(groupId).remove();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Group deleted successfully");
    }

    private void getGroup(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String groupId = (String)exchange.getIn().getHeader("CamelKeycloakGroupId", String.class);
        if (ObjectHelper.isEmpty((String)groupId)) {
            throw new IllegalArgumentException(MISSING_GROUP_ID);
        }
        GroupRepresentation group = keycloakClient.realm(realmName).groups().group(groupId).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)group);
    }

    private void updateGroup(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String groupId = (String)exchange.getIn().getHeader("CamelKeycloakGroupId", String.class);
        if (ObjectHelper.isEmpty((String)groupId)) {
            throw new IllegalArgumentException(MISSING_GROUP_ID);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GroupRepresentation) {
                keycloakClient.realm(realmName).groups().group(groupId).update((GroupRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Group updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update group requires POJO request with GroupRepresentation");
        }
    }

    private void listGroups(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        List groups = keycloakClient.realm(realmName).groups().groups();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)groups);
    }

    private void addUserToGroup(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String groupId = (String)exchange.getIn().getHeader("CamelKeycloakGroupId", String.class);
        if (ObjectHelper.isEmpty((String)groupId)) {
            throw new IllegalArgumentException(MISSING_GROUP_ID);
        }
        keycloakClient.realm(realmName).users().get(userId).joinGroup(groupId);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"User added to group successfully");
    }

    private void removeUserFromGroup(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String groupId = (String)exchange.getIn().getHeader("CamelKeycloakGroupId", String.class);
        if (ObjectHelper.isEmpty((String)groupId)) {
            throw new IllegalArgumentException(MISSING_GROUP_ID);
        }
        keycloakClient.realm(realmName).users().get(userId).leaveGroup(groupId);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"User removed from group successfully");
    }

    private void listUserGroups(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        List groups = keycloakClient.realm(realmName).users().get(userId).groups();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)groups);
    }

    private void createClient(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ClientRepresentation) {
                Response response = keycloakClient.realm(realmName).clients().create((ClientRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)response);
            }
        } else {
            ClientRepresentation client = new ClientRepresentation();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakClientId"))) {
                throw new IllegalArgumentException(MISSING_CLIENT_ID);
            }
            String clientId = (String)exchange.getIn().getHeader("CamelKeycloakClientId", String.class);
            client.setClientId(clientId);
            client.setEnabled(Boolean.valueOf(true));
            Response response = keycloakClient.realm(realmName).clients().create(client);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)response);
        }
    }

    private void deleteClient(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        keycloakClient.realm(realmName).clients().get(clientUuid).remove();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Client deleted successfully");
    }

    private void getClient(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        ClientRepresentation client = keycloakClient.realm(realmName).clients().get(clientUuid).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)client);
    }

    private void updateClient(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ClientRepresentation) {
                keycloakClient.realm(realmName).clients().get(clientUuid).update((ClientRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Client updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update client requires POJO request with ClientRepresentation");
        }
    }

    private void listClients(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        List clients = keycloakClient.realm(realmName).clients().findAll();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)clients);
    }

    private void resetUserPassword(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String password = (String)exchange.getIn().getHeader("CamelKeycloakUserPassword", String.class);
        if (ObjectHelper.isEmpty((String)password)) {
            throw new IllegalArgumentException(MISSING_PASSWORD);
        }
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        Boolean temporary = (Boolean)exchange.getIn().getHeader("CamelKeycloakPasswordTemporary", Boolean.class);
        credential.setTemporary(Boolean.valueOf(temporary != null ? temporary : false));
        keycloakClient.realm(realmName).users().get(userId).resetPassword(credential);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"User password reset successfully");
    }

    private void getUserRoles(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        List roles = keycloakClient.realm(realmName).users().get(userId).roles().realmLevel().listAll();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)roles);
    }

    private void createClientRole(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RoleRepresentation) {
                keycloakClient.realm(realmName).clients().get(clientUuid).roles().create((RoleRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Client role created successfully");
            }
        } else {
            RoleRepresentation role = new RoleRepresentation();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakRoleName"))) {
                String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
                role.setName(roleName);
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakRoleDescription"))) {
                    role.setDescription((String)exchange.getIn().getHeader("CamelKeycloakRoleDescription", String.class));
                }
            } else {
                throw new IllegalArgumentException(MISSING_ROLE_NAME);
            }
            keycloakClient.realm(realmName).clients().get(clientUuid).roles().create(role);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)"Client role created successfully");
        }
    }

    private void deleteClientRole(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        keycloakClient.realm(realmName).clients().get(clientUuid).roles().deleteRole(roleName);
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Client role deleted successfully");
    }

    private void getClientRole(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).clients().get(clientUuid).roles().get(roleName).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)role);
    }

    private void updateClientRole(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RoleRepresentation) {
                keycloakClient.realm(realmName).clients().get(clientUuid).roles().get(roleName).update((RoleRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Client role updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update client role requires POJO request with RoleRepresentation");
        }
    }

    private void listClientRoles(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        List roles = keycloakClient.realm(realmName).clients().get(clientUuid).roles().list();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)roles);
    }

    private void assignClientRoleToUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).clients().get(clientUuid).roles().get(roleName).toRepresentation();
        keycloakClient.realm(realmName).users().get(userId).roles().clientLevel(clientUuid).add(List.of(role));
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Client role assigned to user successfully");
    }

    private void removeClientRoleFromUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        String clientUuid = (String)exchange.getIn().getHeader("CamelKeycloakClientUuid", String.class);
        if (ObjectHelper.isEmpty((String)clientUuid)) {
            throw new IllegalArgumentException(MISSING_CLIENT_UUID);
        }
        String roleName = (String)exchange.getIn().getHeader("CamelKeycloakRoleName", String.class);
        if (ObjectHelper.isEmpty((String)roleName)) {
            throw new IllegalArgumentException(MISSING_ROLE_NAME);
        }
        RoleRepresentation role = keycloakClient.realm(realmName).clients().get(clientUuid).roles().get(roleName).toRepresentation();
        keycloakClient.realm(realmName).users().get(userId).roles().clientLevel(clientUuid).remove(List.of(role));
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Client role removed from user successfully");
    }

    private void searchUsers(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String searchQuery = (String)exchange.getIn().getHeader("CamelKeycloakSearchQuery", String.class);
        Integer first = (Integer)exchange.getIn().getHeader("CamelKeycloakFirstResult", Integer.class);
        Integer max = (Integer)exchange.getIn().getHeader("CamelKeycloakMaxResults", Integer.class);
        List users = ObjectHelper.isNotEmpty((String)searchQuery) ? (first != null && max != null ? keycloakClient.realm(realmName).users().search(searchQuery, first, max) : keycloakClient.realm(realmName).users().search(searchQuery)) : (first != null && max != null ? keycloakClient.realm(realmName).users().list(first, max) : keycloakClient.realm(realmName).users().list());
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)users);
    }

    private void listUserSessions(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        List sessions = keycloakClient.realm(realmName).users().get(userId).getUserSessions();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)sessions);
    }

    private void logoutUser(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String userId = (String)exchange.getIn().getHeader("CamelKeycloakUserId", String.class);
        if (ObjectHelper.isEmpty((String)userId)) {
            throw new IllegalArgumentException(MISSING_USER_ID);
        }
        keycloakClient.realm(realmName).users().get(userId).logout();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"User logged out successfully");
    }

    private void createClientScope(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ClientScopeRepresentation) {
                Response response = keycloakClient.realm(realmName).clientScopes().create((ClientScopeRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)response);
            }
        } else {
            ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelKeycloakClientScopeName"))) {
                throw new IllegalArgumentException("Client scope name must be specified");
            }
            String scopeName = (String)exchange.getIn().getHeader("CamelKeycloakClientScopeName", String.class);
            clientScope.setName(scopeName);
            Response response = keycloakClient.realm(realmName).clientScopes().create(clientScope);
            Message message = KeycloakProducer.getMessageForResponse(exchange);
            message.setBody((Object)response);
        }
    }

    private void deleteClientScope(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientScopeId = (String)exchange.getIn().getHeader("CamelKeycloakClientScopeId", String.class);
        if (ObjectHelper.isEmpty((String)clientScopeId)) {
            throw new IllegalArgumentException("Client scope ID must be specified");
        }
        keycloakClient.realm(realmName).clientScopes().get(clientScopeId).remove();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)"Client scope deleted successfully");
    }

    private void getClientScope(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientScopeId = (String)exchange.getIn().getHeader("CamelKeycloakClientScopeId", String.class);
        if (ObjectHelper.isEmpty((String)clientScopeId)) {
            throw new IllegalArgumentException("Client scope ID must be specified");
        }
        ClientScopeRepresentation clientScope = keycloakClient.realm(realmName).clientScopes().get(clientScopeId).toRepresentation();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)clientScope);
    }

    private void updateClientScope(Keycloak keycloakClient, Exchange exchange) throws InvalidPayloadException {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        String clientScopeId = (String)exchange.getIn().getHeader("CamelKeycloakClientScopeId", String.class);
        if (ObjectHelper.isEmpty((String)clientScopeId)) {
            throw new IllegalArgumentException("Client scope ID must be specified");
        }
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ClientScopeRepresentation) {
                keycloakClient.realm(realmName).clientScopes().get(clientScopeId).update((ClientScopeRepresentation)payload);
                Message message = KeycloakProducer.getMessageForResponse(exchange);
                message.setBody((Object)"Client scope updated successfully");
            }
        } else {
            throw new IllegalArgumentException("Update client scope requires POJO request with ClientScopeRepresentation");
        }
    }

    private void listClientScopes(Keycloak keycloakClient, Exchange exchange) {
        String realmName = (String)exchange.getIn().getHeader("CamelKeycloakRealmName", String.class);
        if (ObjectHelper.isEmpty((String)realmName)) {
            throw new IllegalArgumentException(MISSING_REALM_NAME);
        }
        List clientScopes = keycloakClient.realm(realmName).clientScopes().findAll();
        Message message = KeycloakProducer.getMessageForResponse(exchange);
        message.setBody((Object)clientScopes);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

