/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.keycloak.KeycloakComponent;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakConstants;
import org.apache.camel.component.keycloak.KeycloakConsumer;
import org.apache.camel.component.keycloak.KeycloakProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;

@UriEndpoint(firstVersion="4.15.0", scheme="keycloak", title="Keycloak", syntax="keycloak:label", category={Category.SECURITY, Category.MANAGEMENT}, headersClass=KeycloakConstants.class)
public class KeycloakEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private Keycloak keycloakClient;
    @UriParam
    private KeycloakConfiguration configuration;

    public KeycloakEndpoint(String uri, Component component, KeycloakConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KeycloakConsumer consumer = new KeycloakConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        return new KeycloakProducer((Endpoint)this);
    }

    public KeycloakComponent getComponent() {
        return (KeycloakComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.keycloakClient = this.configuration.getKeycloakClient() != null ? this.configuration.getKeycloakClient() : this.createKeycloakClient();
    }

    protected void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getKeycloakClient()) && this.keycloakClient != null) {
            this.keycloakClient.close();
        }
        super.doStop();
    }

    public KeycloakConfiguration getConfiguration() {
        return this.configuration;
    }

    public Keycloak getKeycloakClient() {
        return this.keycloakClient;
    }

    private Keycloak createKeycloakClient() {
        String authenticationRealm = this.configuration.getAuthRealm() != null ? this.configuration.getAuthRealm() : this.configuration.getRealm();
        KeycloakBuilder builder = KeycloakBuilder.builder().serverUrl(this.configuration.getServerUrl()).realm(authenticationRealm);
        if (this.configuration.getUsername() != null && this.configuration.getPassword() != null) {
            builder.username(this.configuration.getUsername()).password(this.configuration.getPassword()).clientId("admin-cli");
        } else if (this.configuration.getClientId() != null && this.configuration.getClientSecret() != null) {
            builder.clientId(this.configuration.getClientId()).clientSecret(this.configuration.getClientSecret()).grantType("client_credentials");
        } else {
            throw new IllegalArgumentException("Either username/password or clientId/clientSecret must be provided");
        }
        return builder.build();
    }

    public String getServiceUrl() {
        return this.configuration.getServerUrl();
    }

    public String getServiceProtocol() {
        return "keycloak";
    }
}

