/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.keycloak.KeycloakOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.keycloak.admin.client.Keycloak;

@UriParams
public class KeycloakConfiguration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam
    @Metadata(autowired=true)
    private Keycloak keycloakClient;
    @UriParam(description="Keycloak server URL")
    private String serverUrl;
    @UriParam(description="Keycloak realm, the default is master because usually all the operations are done starting from the master realm", defaultValue="master")
    private String realm = "master";
    @UriParam(description="Keycloak realm to authenticate against. If not specified, the realm parameter is used for authentication. This is useful when you want to authenticate against one realm (e.g., master) but perform operations on another realm.", defaultValue="master")
    private String authRealm;
    @UriParam(description="Keycloak client ID")
    private String clientId;
    @UriParam(description="Keycloak client secret", secret=true)
    private String clientSecret;
    @UriParam(description="Keycloak username", secret=true)
    private String username;
    @UriParam(description="Keycloak password", secret=true)
    private String password;
    @UriParam(description="The operation to perform")
    private KeycloakOperations operation;
    @UriParam(description="If we want to use a POJO request as body or not")
    private boolean pojoRequest;
    @UriParam(description="Type of events to consume: events or admin-events", defaultValue="events")
    private String eventType = "events";
    @UriParam(description="Maximum number of events to retrieve per poll", defaultValue="100")
    private int maxResults = 100;
    @UriParam(description="Offset for pagination (first result index)", defaultValue="0")
    private int first = 0;
    @UriParam(description="Filter events by client ID")
    private String client;
    @UriParam(description="Filter events by user ID")
    private String user;
    @UriParam(description="Filter events by start date/time in milliseconds since epoch")
    private String dateFrom;
    @UriParam(description="Filter events by end date/time in milliseconds since epoch")
    private String dateTo;
    @UriParam(description="Filter events by IP address")
    private String ipAddress;
    @UriParam(description="Filter events by event types (comma-separated list, e.g., LOGIN,LOGOUT)")
    private String types;
    @UriParam(description="Filter admin events by operation types (comma-separated list, e.g., CREATE,UPDATE,DELETE)")
    private String operationTypes;
    @UriParam(description="Filter admin events by authentication realm")
    private String authRealmFilter;
    @UriParam(description="Filter admin events by authentication client ID")
    private String authClient;
    @UriParam(description="Filter admin events by authentication user ID")
    private String authUser;
    @UriParam(description="Filter admin events by authentication IP address")
    private String authIpAddress;
    @UriParam(description="Filter admin events by resource path")
    private String resourcePath;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Keycloak getKeycloakClient() {
        return this.keycloakClient;
    }

    public void setKeycloakClient(Keycloak keycloakClient) {
        this.keycloakClient = keycloakClient;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getAuthRealm() {
        return this.authRealm;
    }

    public void setAuthRealm(String authRealm) {
        this.authRealm = authRealm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KeycloakOperations getOperation() {
        return this.operation;
    }

    public void setOperation(KeycloakOperations operation) {
        this.operation = operation;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public String getOperationTypes() {
        return this.operationTypes;
    }

    public void setOperationTypes(String operationTypes) {
        this.operationTypes = operationTypes;
    }

    public String getAuthRealmFilter() {
        return this.authRealmFilter;
    }

    public void setAuthRealmFilter(String authRealmFilter) {
        this.authRealmFilter = authRealmFilter;
    }

    public String getAuthClient() {
        return this.authClient;
    }

    public void setAuthClient(String authClient) {
        this.authClient = authClient;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthIpAddress() {
        return this.authIpAddress;
    }

    public void setAuthIpAddress(String authIpAddress) {
        this.authIpAddress = authIpAddress;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public KeycloakConfiguration copy() {
        try {
            return (KeycloakConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

