/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.keycloak;

import org.apache.camel.CamelContext;
import org.apache.camel.component.keycloak.KeycloakComponent;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.keycloak.admin.client.Keycloak;

public class KeycloakComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private KeycloakConfiguration getOrCreateConfiguration(KeycloakComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KeycloakConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KeycloakComponent target = (KeycloakComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "authclient": 
            case "authClient": {
                this.getOrCreateConfiguration(target).setAuthClient((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "authipaddress": 
            case "authIpAddress": {
                this.getOrCreateConfiguration(target).setAuthIpAddress((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "authrealm": 
            case "authRealm": {
                this.getOrCreateConfiguration(target).setAuthRealm((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "authrealmfilter": 
            case "authRealmFilter": {
                this.getOrCreateConfiguration(target).setAuthRealmFilter((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "authuser": 
            case "authUser": {
                this.getOrCreateConfiguration(target).setAuthUser((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)KeycloakComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)KeycloakComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "client": {
                this.getOrCreateConfiguration(target).setClient((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                this.getOrCreateConfiguration(target).setClientSecret((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KeycloakConfiguration)KeycloakComponentConfigurer.property((CamelContext)camelContext, KeycloakConfiguration.class, (Object)value));
                return true;
            }
            case "datefrom": 
            case "dateFrom": {
                this.getOrCreateConfiguration(target).setDateFrom((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "dateto": 
            case "dateTo": {
                this.getOrCreateConfiguration(target).setDateTo((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "eventtype": 
            case "eventType": {
                this.getOrCreateConfiguration(target).setEventType((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "first": {
                this.getOrCreateConfiguration(target).setFirst((Integer)KeycloakComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "ipaddress": 
            case "ipAddress": {
                this.getOrCreateConfiguration(target).setIpAddress((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keycloakclient": 
            case "keycloakClient": {
                this.getOrCreateConfiguration(target).setKeycloakClient((Keycloak)KeycloakComponentConfigurer.property((CamelContext)camelContext, Keycloak.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KeycloakComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults((Integer)KeycloakComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((KeycloakOperations)((Object)KeycloakComponentConfigurer.property((CamelContext)camelContext, KeycloakOperations.class, (Object)value)));
                return true;
            }
            case "operationtypes": 
            case "operationTypes": {
                this.getOrCreateConfiguration(target).setOperationTypes((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)KeycloakComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "realm": {
                this.getOrCreateConfiguration(target).setRealm((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "resourcepath": 
            case "resourcePath": {
                this.getOrCreateConfiguration(target).setResourcePath((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                this.getOrCreateConfiguration(target).setServerUrl((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "types": {
                this.getOrCreateConfiguration(target).setTypes((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "user": {
                this.getOrCreateConfiguration(target).setUser((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)KeycloakComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"keycloakClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "authclient": 
            case "authClient": {
                return String.class;
            }
            case "authipaddress": 
            case "authIpAddress": {
                return String.class;
            }
            case "authrealm": 
            case "authRealm": {
                return String.class;
            }
            case "authrealmfilter": 
            case "authRealmFilter": {
                return String.class;
            }
            case "authuser": 
            case "authUser": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "client": {
                return String.class;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "configuration": {
                return KeycloakConfiguration.class;
            }
            case "datefrom": 
            case "dateFrom": {
                return String.class;
            }
            case "dateto": 
            case "dateTo": {
                return String.class;
            }
            case "eventtype": 
            case "eventType": {
                return String.class;
            }
            case "first": {
                return Integer.TYPE;
            }
            case "ipaddress": 
            case "ipAddress": {
                return String.class;
            }
            case "keycloakclient": 
            case "keycloakClient": {
                return Keycloak.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresults": 
            case "maxResults": {
                return Integer.TYPE;
            }
            case "operation": {
                return KeycloakOperations.class;
            }
            case "operationtypes": 
            case "operationTypes": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "realm": {
                return String.class;
            }
            case "resourcepath": 
            case "resourcePath": {
                return String.class;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "types": {
                return String.class;
            }
            case "user": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KeycloakComponent target = (KeycloakComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "authclient": 
            case "authClient": {
                return this.getOrCreateConfiguration(target).getAuthClient();
            }
            case "authipaddress": 
            case "authIpAddress": {
                return this.getOrCreateConfiguration(target).getAuthIpAddress();
            }
            case "authrealm": 
            case "authRealm": {
                return this.getOrCreateConfiguration(target).getAuthRealm();
            }
            case "authrealmfilter": 
            case "authRealmFilter": {
                return this.getOrCreateConfiguration(target).getAuthRealmFilter();
            }
            case "authuser": 
            case "authUser": {
                return this.getOrCreateConfiguration(target).getAuthUser();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return this.getOrCreateConfiguration(target).getClient();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return this.getOrCreateConfiguration(target).getClientSecret();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "datefrom": 
            case "dateFrom": {
                return this.getOrCreateConfiguration(target).getDateFrom();
            }
            case "dateto": 
            case "dateTo": {
                return this.getOrCreateConfiguration(target).getDateTo();
            }
            case "eventtype": 
            case "eventType": {
                return this.getOrCreateConfiguration(target).getEventType();
            }
            case "first": {
                return this.getOrCreateConfiguration(target).getFirst();
            }
            case "ipaddress": 
            case "ipAddress": {
                return this.getOrCreateConfiguration(target).getIpAddress();
            }
            case "keycloakclient": 
            case "keycloakClient": {
                return this.getOrCreateConfiguration(target).getKeycloakClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "operationtypes": 
            case "operationTypes": {
                return this.getOrCreateConfiguration(target).getOperationTypes();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "realm": {
                return this.getOrCreateConfiguration(target).getRealm();
            }
            case "resourcepath": 
            case "resourcePath": {
                return this.getOrCreateConfiguration(target).getResourcePath();
            }
            case "serverurl": 
            case "serverUrl": {
                return this.getOrCreateConfiguration(target).getServerUrl();
            }
            case "types": {
                return this.getOrCreateConfiguration(target).getTypes();
            }
            case "user": {
                return this.getOrCreateConfiguration(target).getUser();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
        }
        return null;
    }
}

