/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.subcription;

import org.apache.camel.component.kafka.consumer.support.TopicHelper;
import org.apache.camel.component.kafka.consumer.support.subcription.SubscribeAdapter;
import org.apache.camel.component.kafka.consumer.support.subcription.TopicInfo;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscribeAdapter
implements SubscribeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSubscribeAdapter.class);

    @Override
    public void subscribe(Consumer<?, ?> consumer, ConsumerRebalanceListener reBalanceListener, TopicInfo topicInfo) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Subscribing to {}", (Object)TopicHelper.getPrintableTopic(topicInfo));
        }
        if (topicInfo.isPattern()) {
            consumer.subscribe(topicInfo.getPattern(), reBalanceListener);
        } else {
            consumer.subscribe(topicInfo.getTopics(), reBalanceListener);
        }
    }
}

