/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegatingCallback
implements Callback {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingCallback.class);
    private final Callback callback1;
    private final Callback callback2;

    public DelegatingCallback(Callback callback1, Callback callback2) {
        this.callback1 = callback1;
        this.callback2 = callback2;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
        try {
            this.callback1.onCompletion(metadata, exception);
        }
        catch (Exception e) {
            LOG.warn("Error invoking 1st onCompletion. This exception is ignored.", (Throwable)e);
        }
        try {
            this.callback2.onCompletion(metadata, exception);
        }
        catch (Exception e) {
            LOG.warn("Error invoking 2nd onCompletion. This exception is ignored.", (Throwable)e);
        }
    }
}

