/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.support.SimpleTypeConverter;

public class KafkaHeaderDeserializer
implements Processor {
    public boolean enabled = false;
    private final SimpleTypeConverter defaultTypeConverter = new SimpleTypeConverter(true, KafkaHeaderDeserializer::convert);

    public void process(Exchange exchange) throws Exception {
        if (!this.enabled) {
            return;
        }
        Map headers = exchange.getMessage().getHeaders();
        TypeConverter typeConverter = exchange.getContext().getTypeConverter();
        if (typeConverter == null) {
            typeConverter = this.defaultTypeConverter;
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (!this.shouldDeserialize(entry)) continue;
            entry.setValue(typeConverter.convertTo(String.class, entry.getValue()));
        }
    }

    private static Object convert(Class<?> type, Exchange exchange, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value, StandardCharsets.UTF_8);
        }
        return value.toString();
    }

    private boolean shouldDeserialize(Map.Entry<String, Object> entry) {
        return !entry.getKey().equals("kafka.HEADERS") && !entry.getKey().equals("CamelKafkaManualCommit");
    }

    public void setEnabled(String enabled) {
        this.enabled = Boolean.parseBoolean(enabled);
    }
}

