/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.util.ObjectHelper;

public class MaskField {
    private static final Map<Class<?>, Function<String, ?>> MAPPING_FUNC = new HashMap();
    private static final Map<Class<?>, Object> BASIC_MAPPING = new HashMap();

    public JsonNode process(@ExchangeProperty(value="fields") String fields, @ExchangeProperty(value="replacement") String replacement, Exchange ex) throws InvalidPayloadException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> splittedFields = new ArrayList();
        JsonNode jsonNodeBody = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        Map body = (Map)mapper.convertValue((Object)jsonNodeBody, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        if (ObjectHelper.isNotEmpty((String)fields)) {
            splittedFields = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        }
        HashMap updatedBody = new HashMap();
        for (Map.Entry entry : body.entrySet()) {
            String fieldName = (String)entry.getKey();
            Object origFieldValue = entry.getValue();
            updatedBody.put(fieldName, this.filterNames(fieldName, splittedFields) ? this.masked(origFieldValue, replacement) : origFieldValue);
        }
        if (!updatedBody.isEmpty()) {
            return mapper.valueToTree(updatedBody);
        }
        return mapper.valueToTree((Object)body);
    }

    boolean filterNames(String fieldName, List<String> splittedFields) {
        return splittedFields.contains(fieldName);
    }

    private Object masked(Object value, String replacement) {
        if (value == null) {
            return null;
        }
        return replacement == null ? MaskField.maskWithNullValue(value) : MaskField.maskWithCustomReplacement(value, replacement);
    }

    private static Object maskWithCustomReplacement(Object value, String replacement) {
        Function<String, ?> replacementMapper = MAPPING_FUNC.get(value.getClass());
        if (replacementMapper == null) {
            throw new IllegalArgumentException("Unable to mask value of type " + String.valueOf(value.getClass()) + " with custom replacement.");
        }
        try {
            return replacementMapper.apply(replacement);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Unable to convert " + replacement + " (" + String.valueOf(replacement.getClass()) + ") to number", ex);
        }
    }

    private static Object maskWithNullValue(Object value) {
        List maskedValue = BASIC_MAPPING.get(value.getClass());
        if (maskedValue == null) {
            if (value instanceof List) {
                maskedValue = Collections.emptyList();
            } else if (value instanceof Map) {
                maskedValue = Collections.emptyMap();
            } else {
                throw new IllegalArgumentException("Unable to mask value of type: " + String.valueOf(value.getClass()));
            }
        }
        return maskedValue;
    }

    static {
        BASIC_MAPPING.put(Boolean.class, Boolean.FALSE);
        BASIC_MAPPING.put(Byte.class, (byte)0);
        BASIC_MAPPING.put(Short.class, (short)0);
        BASIC_MAPPING.put(Integer.class, 0);
        BASIC_MAPPING.put(Long.class, 0L);
        BASIC_MAPPING.put(Float.class, Float.valueOf(0.0f));
        BASIC_MAPPING.put(Double.class, 0.0);
        BASIC_MAPPING.put(BigInteger.class, BigInteger.ZERO);
        BASIC_MAPPING.put(BigDecimal.class, BigDecimal.ZERO);
        BASIC_MAPPING.put(Date.class, new Date(0L));
        BASIC_MAPPING.put(String.class, "");
        MAPPING_FUNC.put(Byte.class, Byte::parseByte);
        MAPPING_FUNC.put(Short.class, Short::parseShort);
        MAPPING_FUNC.put(Integer.class, Integer::parseInt);
        MAPPING_FUNC.put(Long.class, Long::parseLong);
        MAPPING_FUNC.put(Float.class, Float::parseFloat);
        MAPPING_FUNC.put(Double.class, Double::parseDouble);
        MAPPING_FUNC.put(String.class, Function.identity());
        MAPPING_FUNC.put(BigDecimal.class, BigDecimal::new);
        MAPPING_FUNC.put(BigInteger.class, BigInteger::new);
    }
}

