/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.kafka.DefaultKafkaClientFactory;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="kafka")
public class KafkaComponent
extends HealthCheckComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaComponent.class);
    @Metadata
    private KafkaConfiguration configuration = new KafkaConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(autowired=true, label="consumer,advanced")
    private KafkaManualCommitFactory kafkaManualCommitFactory;
    @Metadata(autowired=true, label="advanced")
    private KafkaClientFactory kafkaClientFactory;
    @Metadata(autowired=true, label="consumer,advanced")
    private PollExceptionStrategy pollExceptionStrategy;
    @Metadata(label="consumer,advanced")
    private int createConsumerBackoffMaxAttempts;
    @Metadata(label="consumer,advanced", defaultValue="5000")
    private long createConsumerBackoffInterval = 5000L;
    @Metadata(label="consumer,advanced")
    private int subscribeConsumerBackoffMaxAttempts;
    @Metadata(label="consumer,advanced", defaultValue="5000")
    private long subscribeConsumerBackoffInterval = 5000L;
    @Metadata(label="consumer,advanced")
    private boolean subscribeConsumerTopicMustExists;

    public KafkaComponent() {
    }

    public KafkaComponent(CamelContext context) {
        super(context);
    }

    protected KafkaEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new IllegalArgumentException("Topic must be configured on endpoint using syntax kafka:topic");
        }
        Map endpointAdditionalProperties = PropertiesHelper.extractProperties(parameters, (String)"additionalProperties.");
        KafkaEndpoint endpoint = new KafkaEndpoint(uri, this);
        KafkaConfiguration copy = this.getConfiguration().copy();
        endpoint.setConfiguration(copy);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        if (!endpointAdditionalProperties.isEmpty()) {
            HashMap map = new HashMap();
            PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), map, (Map)endpointAdditionalProperties);
            endpoint.getConfiguration().getAdditionalProperties().putAll(map);
        }
        if (endpoint.getConfiguration().getTopic() == null) {
            endpoint.getConfiguration().setTopic(remaining);
        }
        return endpoint;
    }

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public KafkaManualCommitFactory getKafkaManualCommitFactory() {
        return this.kafkaManualCommitFactory;
    }

    public void setKafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
        this.kafkaManualCommitFactory = kafkaManualCommitFactory;
    }

    public KafkaClientFactory getKafkaClientFactory() {
        return this.kafkaClientFactory;
    }

    public void setKafkaClientFactory(KafkaClientFactory kafkaClientFactory) {
        this.kafkaClientFactory = kafkaClientFactory;
    }

    public PollExceptionStrategy getPollExceptionStrategy() {
        return this.pollExceptionStrategy;
    }

    public void setPollExceptionStrategy(PollExceptionStrategy pollExceptionStrategy) {
        this.pollExceptionStrategy = pollExceptionStrategy;
    }

    public int getCreateConsumerBackoffMaxAttempts() {
        return this.createConsumerBackoffMaxAttempts;
    }

    public void setCreateConsumerBackoffMaxAttempts(int createConsumerBackoffMaxAttempts) {
        this.createConsumerBackoffMaxAttempts = createConsumerBackoffMaxAttempts;
    }

    public long getCreateConsumerBackoffInterval() {
        return this.createConsumerBackoffInterval;
    }

    public void setCreateConsumerBackoffInterval(long createConsumerBackoffInterval) {
        this.createConsumerBackoffInterval = createConsumerBackoffInterval;
    }

    public int getSubscribeConsumerBackoffMaxAttempts() {
        return this.subscribeConsumerBackoffMaxAttempts;
    }

    public void setSubscribeConsumerBackoffMaxAttempts(int subscribeConsumerBackoffMaxAttempts) {
        this.subscribeConsumerBackoffMaxAttempts = subscribeConsumerBackoffMaxAttempts;
    }

    public long getSubscribeConsumerBackoffInterval() {
        return this.subscribeConsumerBackoffInterval;
    }

    public void setSubscribeConsumerBackoffInterval(long subscribeConsumerBackoffInterval) {
        this.subscribeConsumerBackoffInterval = subscribeConsumerBackoffInterval;
    }

    public boolean isSubscribeConsumerTopicMustExists() {
        return this.subscribeConsumerTopicMustExists;
    }

    public void setSubscribeConsumerTopicMustExists(boolean subscribeConsumerTopicMustExists) {
        this.subscribeConsumerTopicMustExists = subscribeConsumerTopicMustExists;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.kafkaClientFactory == null) {
            this.kafkaClientFactory = new DefaultKafkaClientFactory();
        }
        if (this.configuration.isAllowManualCommit() && this.kafkaManualCommitFactory == null) {
            LOG.warn("The component was setup for allowing manual commits, but a manual commit factory was not set");
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        HashMap<String, Object> map = new HashMap<String, Object>();
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), map, this.configuration.getAdditionalProperties());
        this.configuration.setAdditionalProperties(map);
    }
}

