/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeAdapter;
import org.apache.camel.component.kafka.consumer.support.KafkaResumable;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekPolicyKafkaConsumerResumeAdapter
implements KafkaConsumerResumeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SeekPolicyKafkaConsumerResumeAdapter.class);
    private final SeekPolicy seekPolicy;
    private Consumer<?, ?> consumer;

    public SeekPolicyKafkaConsumerResumeAdapter(SeekPolicy seekPolicy) {
        this.seekPolicy = seekPolicy;
    }

    @Override
    public void setConsumer(Consumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void setKafkaResumable(KafkaResumable kafkaResumable) {
    }

    public void resume() {
        if (this.seekPolicy == SeekPolicy.BEGINNING) {
            LOG.debug("Seeking from the beginning of topic");
            this.consumer.seekToBeginning((Collection)this.consumer.assignment());
        } else if (this.seekPolicy == SeekPolicy.END) {
            LOG.debug("Seeking from the end off the topic");
            this.consumer.seekToEnd((Collection)this.consumer.assignment());
        }
    }
}

