/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400ConnectionPool;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.component.jt400.Jt400Type;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400Component
extends UriEndpointComponent {
    static final String CONNECTION_POOL = "connectionPool";
    private static final Logger LOG = LoggerFactory.getLogger(Jt400Component.class);
    @Metadata(label="advanced")
    private AS400ConnectionPool connectionPool;

    public Jt400Component() {
        super(Jt400Endpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> properties) throws Exception {
        AS400ConnectionPool connectionPool;
        if (properties.containsKey(CONNECTION_POOL)) {
            LOG.trace("AS400ConnectionPool instance specified in the URI - will look it up.");
            String poolId = properties.remove(CONNECTION_POOL).toString();
            connectionPool = (AS400ConnectionPool)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)poolId, AS400ConnectionPool.class, (boolean)true);
        } else {
            LOG.trace("No AS400ConnectionPool instance specified in the URI - one will be provided.");
            connectionPool = this.getConnectionPool();
        }
        String type = remaining.substring(remaining.lastIndexOf(".") + 1).toUpperCase();
        Jt400Endpoint endpoint = new Jt400Endpoint(uri, this, connectionPool);
        this.setProperties((Object)endpoint, properties);
        endpoint.setType(Jt400Type.valueOf(type));
        return endpoint;
    }

    public synchronized AS400ConnectionPool getConnectionPool() {
        if (this.connectionPool == null) {
            LOG.info("Instantiating the default connection pool ...");
            this.connectionPool = new AS400ConnectionPool();
        }
        return this.connectionPool;
    }

    public void setConnectionPool(AS400ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.connectionPool != null) {
            LOG.info("Shutting down the default connection pool {} ...", (Object)this.connectionPool);
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }
}

