/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonata;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jsonata.JsonataEndpoint;
import org.apache.camel.component.jsonata.JsonataFrameBinding;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="jsonata")
public class JsonataComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata(label="advanced", description="To configure custom frame bindings and inject user functions.")
    protected JsonataFrameBinding frameBinding;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        JsonataFrameBinding frameBinding = (JsonataFrameBinding)this.resolveAndRemoveReferenceParameter(parameters, "frameBinding", JsonataFrameBinding.class);
        if (frameBinding == null) {
            frameBinding = this.getFrameBinding();
        }
        JsonataEndpoint answer = new JsonataEndpoint(uri, this, remaining, frameBinding);
        answer.setContentCache(cache);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public void setFrameBinding(JsonataFrameBinding frameBinding) {
        this.frameBinding = frameBinding;
    }

    public JsonataFrameBinding getFrameBinding() {
        return this.frameBinding;
    }
}

