/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.module.loaders.BuiltinModuleLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.StaticService;
import org.apache.camel.language.jq.JqExpression;
import org.apache.camel.language.jq.JqFunctions;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.SingleInputTypedLanguageSupport;

@Language(value="jq")
public class JqLanguage
extends SingleInputTypedLanguageSupport
implements StaticService {
    private Scope rootScope;

    public void init() {
        if (this.getCamelContext() != null) {
            this.rootScope = (Scope)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), Scope.class);
        }
        if (this.rootScope == null) {
            this.rootScope = Scope.newEmptyScope();
            this.rootScope.setModuleLoader((ModuleLoader)BuiltinModuleLoader.getInstance());
            if (this.getCamelContext() != null) {
                JqFunctions.load(this.getCamelContext(), this.rootScope);
            }
        }
        if (this.getCamelContext() != null) {
            JqFunctions.loadFromRegistry(this.getCamelContext(), this.rootScope);
        }
        JqFunctions.loadLocal(this.rootScope);
    }

    public Scope getRootScope() {
        return this.rootScope;
    }

    public void start() {
    }

    public void stop() {
    }

    public Expression createExpression(Expression source, String expression, Object[] properties) {
        JqExpression answer = new JqExpression(Scope.newChildScope((Scope)this.rootScope), expression);
        answer.setResultType((Class)this.property(Class.class, properties, 0, null));
        answer.setSource(source);
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    public boolean validateExpression(String expression) throws Exception {
        this.init();
        JsonQuery jq = JsonQuery.compile((String)expression, (Version)Versions.JQ_1_7);
        return true;
    }

    public boolean validatePredicate(String expression) throws Exception {
        this.init();
        JsonQuery.compile((String)expression, (Version)Versions.JQ_1_7);
        return true;
    }
}

