/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaProducer.class);
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionTemplate transactionTemplate;
    private final Expression expression;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, this.getEndpoint().isUsePassedInEntityManager(), this.getEndpoint().isSharedEntityManager(), true);
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                        entityManager.joinTransaction();
                    }
                    if (values.getClass().isArray()) {
                        Object[] array;
                        for (Object element : array = (Object[])values) {
                            if (!JpaProducer.this.getEndpoint().isRemove()) {
                                this.save(element);
                                continue;
                            }
                            this.remove(element);
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        for (Object entity : collection) {
                            if (!JpaProducer.this.getEndpoint().isRemove()) {
                                this.save(entity);
                                continue;
                            }
                            this.remove(entity);
                        }
                    } else {
                        Object managedEntity = null;
                        managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(values) : this.remove(values);
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }

                private Object save(Object entity) {
                    LOG.debug("save: {}", entity);
                    if (JpaProducer.this.getEndpoint().isUsePersist()) {
                        entityManager.persist(entity);
                        return entity;
                    }
                    return entityManager.merge(entity);
                }

                private Object remove(Object entity) {
                    LOG.debug("remove: {}", entity);
                    entityManager.remove(entity);
                    return entity;
                }
            });
        }
    }
}

