/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.component.jpa.JpaConsumer;
import org.apache.camel.component.jpa.JpaProducer;
import org.apache.camel.component.jpa.JpaTemplateTransactionStrategy;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaEndpoint
extends ScheduledPollEndpoint<Exchange> {
    private EntityManagerFactory entityManagerFactory;
    private String persistenceUnit = "camel";
    private JpaTemplate template;
    private Expression<Exchange> producerExpression;
    private int maximumResults = -1;
    private Class<?> entityType;
    private Map entityManagerProperties;
    private boolean consumeDelete = true;
    private boolean consumeLockEntity = true;
    private boolean flushOnSend = true;

    public JpaEndpoint(String uri, JpaComponent component) {
        super(uri, (Component)component);
        this.entityManagerFactory = component.getEntityManagerFactory();
    }

    public JpaEndpoint(String endpointUri, EntityManagerFactory entityManagerFactory) {
        super(endpointUri);
        this.entityManagerFactory = entityManagerFactory;
    }

    public JpaEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer<Exchange> createProducer() throws Exception {
        this.validate();
        return new JpaProducer(this, this.getProducerExpression());
    }

    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        this.validate();
        JpaConsumer consumer = new JpaConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void configureProperties(Map options) {
        super.configureProperties(options);
        Map emProperties = IntrospectionSupport.extractProperties((Map)options, (String)"emf.");
        if (emProperties != null) {
            this.setEntityManagerProperties(emProperties);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public JpaTemplate getTemplate() {
        if (this.template == null) {
            this.template = this.createTemplate();
        }
        return this.template;
    }

    public void setTemplate(JpaTemplate template) {
        this.template = template;
    }

    public Expression<Exchange> getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    public void setProducerExpression(Expression<Exchange> producerExpression) {
        this.producerExpression = producerExpression;
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        this.maximumResults = maximumResults;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.createEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Map getEntityManagerProperties() {
        if (this.entityManagerProperties == null) {
            this.entityManagerProperties = System.getProperties();
        }
        return this.entityManagerProperties;
    }

    public void setEntityManagerProperties(Map entityManagerProperties) {
        this.entityManagerProperties = entityManagerProperties;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public boolean isConsumeDelete() {
        return this.consumeDelete;
    }

    public void setConsumeDelete(boolean consumeDelete) {
        this.consumeDelete = consumeDelete;
    }

    public boolean isConsumeLockEntity() {
        return this.consumeLockEntity;
    }

    public void setConsumeLockEntity(boolean consumeLockEntity) {
        this.consumeLockEntity = consumeLockEntity;
    }

    public boolean isFlushOnSend() {
        return this.flushOnSend;
    }

    public void setFlushOnSend(boolean flushOnSend) {
        this.flushOnSend = flushOnSend;
    }

    protected void validate() {
        ObjectHelper.notNull((Object)this.getEntityManagerFactory(), (String)"entityManagerFactory property");
    }

    protected JpaTemplate createTemplate() {
        return new JpaTemplate(this.getEntityManagerFactory());
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.persistenceUnit, (Map)this.getEntityManagerProperties());
    }

    protected EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    protected TransactionStrategy createTransactionStrategy() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        return JpaTemplateTransactionStrategy.newInstance(emf, this.getTemplate());
    }

    protected Expression<Exchange> createProducerExpression() {
        final Class<?> type = this.getEntityType();
        if (type == null) {
            return ExpressionBuilder.bodyExpression();
        }
        return new Expression<Exchange>(){

            public Object evaluate(Exchange exchange) {
                Object answer = exchange.getIn().getBody(type);
                if (answer == null) {
                    Object defaultValue = exchange.getIn().getBody();
                    if (defaultValue != null) {
                        throw new NoTypeConversionAvailableException(defaultValue, type);
                    }
                    answer = exchange.getContext().getInjector().newInstance(type);
                }
                return answer;
            }
        };
    }
}

