/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CompileStrategy;

public class CamelJoorClassLoader
extends URLClassLoader {
    private final CamelContext camelContext;
    private final ClassLoader parent;

    public CamelJoorClassLoader(URLClassLoader parent, CamelContext camelContext) {
        super(parent.getURLs(), (ClassLoader)parent);
        this.parent = parent;
        this.camelContext = camelContext;
    }

    @Override
    public String getName() {
        return "CamelJoorClassLoader";
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> answer = new ArrayList<URL>();
        CompileStrategy cs = (CompileStrategy)this.camelContext.getCamelContextExtension().getContextPlugin(CompileStrategy.class);
        if (cs != null && cs.getWorkDir() != null) {
            try {
                File dir = new File(cs.getWorkDir() + "/joor");
                answer.add(dir.toURI().toURL());
            }
            catch (MalformedURLException dir) {
                // empty catch block
            }
        }
        answer.addAll(Arrays.asList(super.getURLs()));
        URL[] arr = answer.toArray(new URL[0]);
        return arr;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.doLoadClass(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.doLoadClass(name);
    }

    public Class<?> doLoadClass(String name) throws ClassNotFoundException {
        ClassLoader joorClassLoader = this.camelContext.getClassResolver().getClassLoader("JavaJoorClassLoader");
        if (joorClassLoader != null) {
            try {
                return joorClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (ClassLoader cl : this.camelContext.getClassResolver().getClassLoaders()) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return this.parent.loadClass(name);
    }
}

