/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.Transform;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jolt.JoltEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="jolt")
public class JoltComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata(label="advanced")
    private Transform transform;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        JoltEndpoint answer = new JoltEndpoint(uri, this, remaining);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setContentCache(cache);
        answer.setTransform((JoltTransform)this.transform);
        this.setProperties((Endpoint)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }
}

