/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.io.File;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.trait.message.MessageTrait;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessage
extends DefaultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMessage.class);
    private jakarta.jms.Message jmsMessage;
    private Session jmsSession;
    private JmsBinding binding;

    public JmsMessage(Exchange exchange, jakarta.jms.Message jmsMessage, Session jmsSession, JmsBinding binding) {
        super(exchange);
        this.setJmsMessage(jmsMessage);
        this.setJmsSession(jmsSession);
        this.setBinding(binding);
    }

    public void init(Exchange exchange, jakarta.jms.Message jmsMessage, Session jmsSession, JmsBinding binding) {
        this.setExchange(exchange);
        this.setJmsMessage(jmsMessage);
        this.setJmsSession(jmsSession);
        this.setBinding(binding);
        this.populateInitialHeaders(this.getHeaders());
    }

    public void reset() {
        super.reset();
        this.setExchange(null);
        this.jmsMessage = null;
        this.jmsSession = null;
        this.binding = null;
    }

    public String toString() {
        if (this.jmsMessage != null) {
            try {
                return "JmsMessage[JmsMessageID: " + this.jmsMessage.getJMSMessageID() + "]";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "JmsMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }

    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        this.getHeaders().clear();
        boolean copyMessageId = true;
        if (that instanceof JmsMessage) {
            JmsMessage thatMessage = (JmsMessage)that;
            this.jmsMessage = thatMessage.jmsMessage;
            if (this.jmsMessage != null) {
                copyMessageId = false;
            }
        }
        if (copyMessageId) {
            this.setMessageId(that.getMessageId());
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        MessageHelper.copyBody((Message)that, (Message)this);
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = (JmsBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), JmsBinding.class);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public jakarta.jms.Message getJmsMessage() {
        return this.jmsMessage;
    }

    public void setJmsMessage(jakarta.jms.Message jmsMessage) {
        if (jmsMessage != null) {
            try {
                this.setMessageId(jmsMessage.getJMSMessageID());
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from JMS Message", (Throwable)e);
            }
        }
        this.jmsMessage = jmsMessage;
        this.setPayloadForTrait(MessageTrait.REDELIVERY, JmsMessageHelper.evalRedeliveryMessageTrait(jmsMessage));
    }

    public Session getJmsSession() {
        return this.jmsSession;
    }

    public void setJmsSession(Session jmsSession) {
        this.jmsSession = jmsSession;
    }

    public void setBody(Object body) {
        super.setBody(body);
        if (body == null) {
            this.ensureInitialHeaders();
            this.jmsMessage = null;
        }
    }

    public Object getHeader(String name) {
        this.ensureInitialHeaders();
        return super.getHeader(name);
    }

    public Map<String, Object> getHeaders() {
        this.ensureInitialHeaders();
        return super.getHeaders();
    }

    public Object removeHeader(String name) {
        this.ensureInitialHeaders();
        return super.removeHeader(name);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.ensureInitialHeaders();
        super.setHeaders(headers);
    }

    public void setHeader(String name, Object value) {
        this.ensureInitialHeaders();
        super.setHeader(name, value);
    }

    public JmsMessage newInstance() {
        JmsMessage answer = new JmsMessage(null, null, null, this.binding);
        answer.setCamelContext(this.getCamelContext());
        return answer;
    }

    public boolean shouldCreateNewMessage() {
        return super.hasPopulatedHeaders();
    }

    protected void ensureInitialHeaders() {
        if (this.jmsMessage != null && !this.hasPopulatedHeaders()) {
            super.setHeaders(this.createHeaders());
        }
    }

    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    protected boolean isPopulateHeadersSupported() {
        return true;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null && map != null) {
            map.putAll(this.getBinding().extractHeadersFromJms(this.jmsMessage, this.getExchange()));
            try {
                map.put("CamelMessageTimestamp", this.jmsMessage.getJMSTimestamp());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected String createMessageId() {
        if (this.jmsMessage == null) {
            LOG.trace("No jakarta.jms.Message set so generating a new message id");
            return super.createMessageId();
        }
        try {
            Object id = this.getDestinationAsString(this.jmsMessage.getJMSDestination());
            id = id != null ? (String)id + this.jmsMessage.getJMSMessageID() : this.jmsMessage.getJMSMessageID();
            return this.getSanitizedString(id);
        }
        catch (JMSException e) {
            throw new RuntimeExchangeException("Unable to retrieve JMSMessageID from JMS Message", this.getExchange(), (Throwable)e);
        }
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = null;
        if (destination == null) {
            result = "null destination!" + File.separator;
        } else if (destination instanceof Topic) {
            Topic topic = (Topic)destination;
            result = "topic" + File.separator + topic.getTopicName() + File.separator;
        } else if (destination instanceof Queue) {
            Queue queue = (Queue)destination;
            result = "queue" + File.separator + queue.getQueueName() + File.separator;
        }
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

