/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.PassThroughJmsKeyFormatStrategy;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@Component(value="jms")
@Metadata(excludeProperties="bridgeErrorHandler")
public class JmsComponent
extends HeaderFilterStrategyComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JmsComponent.class);
    private static final String KEY_FORMAT_STRATEGY_PARAM = "jmsKeyFormatStrategy";
    private ExecutorService asyncStartStopExecutorService;
    @Metadata(label="advanced", description="To use a shared JMS configuration")
    private JmsConfiguration configuration;
    @Metadata(label="advanced", description="To use a custom QueueBrowseStrategy when browsing queues")
    private QueueBrowseStrategy queueBrowseStrategy;
    @Metadata(label="advanced", description="Whether to auto-discover ConnectionFactory from the registry, if no connection factory has been configured. If only one instance of ConnectionFactory is found then it will be used. This is enabled by default.", defaultValue="true")
    private boolean allowAutoWiredConnectionFactory = true;
    @Metadata(label="advanced", description="Whether to auto-discover DestinationResolver from the registry, if no destination resolver has been configured. If only one instance of DestinationResolver is found then it will be used. This is enabled by default.", defaultValue="true")
    private boolean allowAutoWiredDestinationResolver = true;

    public JmsComponent() {
        this.configuration = this.createConfiguration();
    }

    public JmsComponent(CamelContext context) {
        super(context);
        this.configuration = this.createConfiguration();
    }

    public JmsComponent(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public static JmsComponent jmsComponent() {
        return new JmsComponent();
    }

    public static JmsComponent jmsComponent(JmsConfiguration configuration) {
        return new JmsComponent(configuration);
    }

    public static JmsComponent jmsComponent(ConnectionFactory connectionFactory) {
        return JmsComponent.jmsComponent(new JmsConfiguration(connectionFactory));
    }

    public static JmsComponent jmsComponentClientAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setAcknowledgementMode(2);
        return JmsComponent.jmsComponent(configuration);
    }

    public static JmsComponent jmsComponentAutoAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setAcknowledgementMode(1);
        return JmsComponent.jmsComponent(configuration);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory) {
        JmsTransactionManager transactionManager = new JmsTransactionManager();
        transactionManager.setConnectionFactory(connectionFactory);
        return JmsComponent.jmsComponentTransacted(connectionFactory, (PlatformTransactionManager)transactionManager);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory, PlatformTransactionManager transactionManager) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setTransactionManager(transactionManager);
        configuration.setTransacted(true);
        configuration.setTransactedInOut(true);
        return JmsComponent.jmsComponent(configuration);
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isAllowAutoWiredConnectionFactory() {
        return this.allowAutoWiredConnectionFactory;
    }

    public void setAllowAutoWiredConnectionFactory(boolean allowAutoWiredConnectionFactory) {
        this.allowAutoWiredConnectionFactory = allowAutoWiredConnectionFactory;
    }

    public boolean isAllowAutoWiredDestinationResolver() {
        return this.allowAutoWiredDestinationResolver;
    }

    public void setAllowAutoWiredDestinationResolver(boolean allowAutoWiredDestinationResolver) {
        this.allowAutoWiredDestinationResolver = allowAutoWiredDestinationResolver;
    }

    public QueueBrowseStrategy getQueueBrowseStrategy() {
        if (this.queueBrowseStrategy == null) {
            this.queueBrowseStrategy = new DefaultQueueBrowseStrategy();
        }
        return this.queueBrowseStrategy;
    }

    public void setQueueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public JmsConfiguration copy() {
        return this.configuration.copy();
    }

    public JmsOperations createInOutTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination, long requestTimeout) {
        return this.configuration.createInOutTemplate(endpoint, pubSubDomain, destination, requestTimeout);
    }

    public JmsOperations createInOnlyTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination) {
        return this.configuration.createInOnlyTemplate(endpoint, pubSubDomain, destination);
    }

    public AbstractMessageListenerContainer createMessageListenerContainer(JmsEndpoint endpoint) {
        return this.configuration.createMessageListenerContainer(endpoint);
    }

    public AbstractMessageListenerContainer chooseMessageListenerContainerImplementation(JmsEndpoint endpoint) {
        return this.configuration.chooseMessageListenerContainerImplementation(endpoint);
    }

    public ConsumerType getConsumerType() {
        return this.configuration.getConsumerType();
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.configuration.setConsumerType(consumerType);
    }

    public ConsumerType getReplyToConsumerType() {
        return this.configuration.getReplyToConsumerType();
    }

    public void setReplyToConsumerType(ConsumerType replyToConsumerType) {
        this.configuration.setReplyToConsumerType(replyToConsumerType);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.configuration.getConnectionFactory();
    }

    public ConnectionFactory getOrCreateConnectionFactory() {
        return this.configuration.getOrCreateConnectionFactory();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.configuration.setConnectionFactory(connectionFactory);
    }

    public String getUsername() {
        return this.configuration.getUsername();
    }

    public void setUsername(String username) {
        this.configuration.setUsername(username);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public ConnectionFactory getListenerConnectionFactory() {
        return this.configuration.getListenerConnectionFactory();
    }

    public ConnectionFactory getOrCreateListenerConnectionFactory() {
        return this.configuration.getOrCreateListenerConnectionFactory();
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.configuration.setListenerConnectionFactory(listenerConnectionFactory);
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        return this.configuration.getTemplateConnectionFactory();
    }

    public ConnectionFactory getOrCreateTemplateConnectionFactory() {
        return this.configuration.getOrCreateTemplateConnectionFactory();
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.configuration.setTemplateConnectionFactory(templateConnectionFactory);
    }

    public boolean isAutoStartup() {
        return this.configuration.isAutoStartup();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.configuration.setAutoStartup(autoStartup);
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.configuration.isAcceptMessagesWhileStopping();
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.configuration.setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    public boolean isAllowReplyManagerQuickStop() {
        return this.configuration.isAllowReplyManagerQuickStop();
    }

    public void setAllowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
        this.configuration.setAllowReplyManagerQuickStop(allowReplyManagerQuickStop);
    }

    public String getClientId() {
        return this.configuration.getClientId();
    }

    public void setClientId(String consumerClientId) {
        this.configuration.setClientId(consumerClientId);
    }

    public String getDurableSubscriptionName() {
        return this.configuration.getDurableSubscriptionName();
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.configuration.setDurableSubscriptionName(durableSubscriptionName);
    }

    public ExceptionListener getExceptionListener() {
        return this.configuration.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.configuration.setExceptionListener(exceptionListener);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.configuration.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.configuration.getErrorHandler();
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.configuration.getErrorHandlerLoggingLevel();
    }

    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.configuration.setErrorHandlerLoggingLevel(errorHandlerLoggingLevel);
    }

    public boolean isErrorHandlerLogStackTrace() {
        return this.configuration.isErrorHandlerLogStackTrace();
    }

    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.configuration.setErrorHandlerLogStackTrace(errorHandlerLogStackTrace);
    }

    public String getAcknowledgementModeName() {
        return this.configuration.getAcknowledgementModeName();
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.configuration.setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    public boolean isExposeListenerSession() {
        return this.configuration.isExposeListenerSession();
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.configuration.setExposeListenerSession(exposeListenerSession);
    }

    public TaskExecutor getTaskExecutor() {
        return this.configuration.getTaskExecutor();
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.configuration.setTaskExecutor(taskExecutor);
    }

    public boolean isPubSubNoLocal() {
        return this.configuration.isPubSubNoLocal();
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.configuration.setPubSubNoLocal(pubSubNoLocal);
    }

    public int getConcurrentConsumers() {
        return this.configuration.getConcurrentConsumers();
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.configuration.setConcurrentConsumers(concurrentConsumers);
    }

    public int getReplyToConcurrentConsumers() {
        return this.configuration.getReplyToConcurrentConsumers();
    }

    public void setReplyToConcurrentConsumers(int replyToConcurrentConsumers) {
        this.configuration.setReplyToConcurrentConsumers(replyToConcurrentConsumers);
    }

    public int getMaxMessagesPerTask() {
        return this.configuration.getMaxMessagesPerTask();
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.configuration.setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public int getCacheLevel() {
        return this.configuration.getCacheLevel();
    }

    public void setCacheLevel(int cacheLevel) {
        this.configuration.setCacheLevel(cacheLevel);
    }

    public String getCacheLevelName() {
        return this.configuration.getCacheLevelName();
    }

    public void setCacheLevelName(String cacheName) {
        this.configuration.setCacheLevelName(cacheName);
    }

    public long getRecoveryInterval() {
        return this.configuration.getRecoveryInterval();
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.configuration.setRecoveryInterval(recoveryInterval);
    }

    public long getReceiveTimeout() {
        return this.configuration.getReceiveTimeout();
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.configuration.setReceiveTimeout(receiveTimeout);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.configuration.getTransactionManager();
    }

    public PlatformTransactionManager getOrCreateTransactionManager() {
        return this.configuration.getOrCreateTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.configuration.setTransactionManager(transactionManager);
    }

    public String getTransactionName() {
        return this.configuration.getTransactionName();
    }

    public void setTransactionName(String transactionName) {
        this.configuration.setTransactionName(transactionName);
    }

    public int getTransactionTimeout() {
        return this.configuration.getTransactionTimeout();
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.configuration.setTransactionTimeout(transactionTimeout);
    }

    public int getIdleTaskExecutionLimit() {
        return this.configuration.getIdleTaskExecutionLimit();
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.configuration.setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    public int getIdleConsumerLimit() {
        return this.configuration.getIdleConsumerLimit();
    }

    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.configuration.setIdleConsumerLimit(idleConsumerLimit);
    }

    public int getWaitForProvisionCorrelationToBeUpdatedCounter() {
        return this.configuration.getWaitForProvisionCorrelationToBeUpdatedCounter();
    }

    public void setWaitForProvisionCorrelationToBeUpdatedCounter(int counter) {
        this.configuration.setWaitForProvisionCorrelationToBeUpdatedCounter(counter);
    }

    public long getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime() {
        return this.configuration.getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
    }

    public void setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long sleepingTime) {
        this.configuration.setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(sleepingTime);
    }

    public int getMaxConcurrentConsumers() {
        return this.configuration.getMaxConcurrentConsumers();
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.configuration.setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    public int getReplyToMaxConcurrentConsumers() {
        return this.configuration.getReplyToMaxConcurrentConsumers();
    }

    public void setReplyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
        this.configuration.setReplyToMaxConcurrentConsumers(replyToMaxConcurrentConsumers);
    }

    public int getReplyToOnTimeoutMaxConcurrentConsumers() {
        return this.configuration.getReplyToOnTimeoutMaxConcurrentConsumers();
    }

    public void setReplyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
        this.configuration.setReplyToOnTimeoutMaxConcurrentConsumers(replyToOnTimeoutMaxConcurrentConsumers);
    }

    public boolean isExplicitQosEnabled() {
        return this.configuration.isExplicitQosEnabled();
    }

    public Boolean getExplicitQosEnabled() {
        return this.configuration.getExplicitQosEnabled();
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.configuration.setExplicitQosEnabled(explicitQosEnabled);
    }

    public boolean isDeliveryPersistent() {
        return this.configuration.isDeliveryPersistent();
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.configuration.setDeliveryPersistent(deliveryPersistent);
    }

    public Integer getDeliveryMode() {
        return this.configuration.getDeliveryMode();
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.configuration.setDeliveryMode(deliveryMode);
    }

    public boolean isReplyToDeliveryPersistent() {
        return this.configuration.isReplyToDeliveryPersistent();
    }

    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.configuration.setReplyToDeliveryPersistent(replyToDeliveryPersistent);
    }

    public long getTimeToLive() {
        return this.configuration.getTimeToLive();
    }

    public void setTimeToLive(long timeToLive) {
        this.configuration.setTimeToLive(timeToLive);
    }

    public MessageConverter getMessageConverter() {
        return this.configuration.getMessageConverter();
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.configuration.setMessageConverter(messageConverter);
    }

    public boolean isMapJmsMessage() {
        return this.configuration.isMapJmsMessage();
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.configuration.setMapJmsMessage(mapJmsMessage);
    }

    public boolean isMessageIdEnabled() {
        return this.configuration.isMessageIdEnabled();
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.configuration.setMessageIdEnabled(messageIdEnabled);
    }

    public boolean isMessageTimestampEnabled() {
        return this.configuration.isMessageTimestampEnabled();
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.configuration.setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public int getPriority() {
        return this.configuration.getPriority();
    }

    public void setPriority(int priority) {
        this.configuration.setPriority(priority);
    }

    public int getAcknowledgementMode() {
        return this.configuration.getAcknowledgementMode();
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.configuration.setAcknowledgementMode(consumerAcknowledgementMode);
    }

    public boolean isTransacted() {
        return this.configuration.isTransacted();
    }

    public void setTransacted(boolean transacted) {
        this.configuration.setTransacted(transacted);
    }

    public boolean isTransactedInOut() {
        return this.configuration.isTransactedInOut();
    }

    public void setTransactedInOut(boolean transacted) {
        this.configuration.setTransactedInOut(transacted);
    }

    public boolean isLazyCreateTransactionManager() {
        return this.configuration.isLazyCreateTransactionManager();
    }

    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.configuration.setLazyCreateTransactionManager(lazyCreating);
    }

    public String getEagerPoisonBody() {
        return this.configuration.getEagerPoisonBody();
    }

    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.configuration.setEagerPoisonBody(eagerPoisonBody);
    }

    public boolean isEagerLoadingOfProperties() {
        return this.configuration.isEagerLoadingOfProperties();
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.configuration.setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    public boolean isDisableReplyTo() {
        return this.configuration.isDisableReplyTo();
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.configuration.setDisableReplyTo(disableReplyTo);
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.configuration.setPreserveMessageQos(preserveMessageQos);
    }

    public JmsOperations getJmsOperations() {
        return this.configuration.getJmsOperations();
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.configuration.setJmsOperations(jmsOperations);
    }

    public DestinationResolver getDestinationResolver() {
        return this.configuration.getDestinationResolver();
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.configuration.setDestinationResolver(destinationResolver);
    }

    public static DestinationResolver createDestinationResolver(DestinationEndpoint destinationEndpoint) {
        return JmsConfiguration.createDestinationResolver(destinationEndpoint);
    }

    public void configureMessageListenerContainer(AbstractMessageListenerContainer container, JmsEndpoint endpoint) {
        this.configuration.configureMessageListenerContainer(container, endpoint);
    }

    public void configureMessageListener(EndpointMessageListener listener) {
        this.configuration.configureMessageListener(listener);
    }

    public int defaultCacheLevel(JmsEndpoint endpoint) {
        return this.configuration.defaultCacheLevel(endpoint);
    }

    public ConnectionFactory createConnectionFactory() {
        return this.configuration.createConnectionFactory();
    }

    public ConnectionFactory createListenerConnectionFactory() {
        return this.configuration.createListenerConnectionFactory();
    }

    public ConnectionFactory createTemplateConnectionFactory() {
        return this.configuration.createTemplateConnectionFactory();
    }

    public PlatformTransactionManager createTransactionManager() {
        return this.configuration.createTransactionManager();
    }

    public boolean isPreserveMessageQos() {
        return this.configuration.isPreserveMessageQos();
    }

    public void configuredQoS() {
        this.configuration.configuredQoS();
    }

    public boolean isAlwaysCopyMessage() {
        return this.configuration.isAlwaysCopyMessage();
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.configuration.setAlwaysCopyMessage(alwaysCopyMessage);
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.configuration.isUseMessageIDAsCorrelationID();
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.configuration.setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public long getRequestTimeout() {
        return this.configuration.getRequestTimeout();
    }

    public void setRequestTimeout(long requestTimeout) {
        this.configuration.setRequestTimeout(requestTimeout);
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.configuration.getRequestTimeoutCheckerInterval();
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.configuration.setRequestTimeoutCheckerInterval(requestTimeoutCheckerInterval);
    }

    public String getReplyTo() {
        return this.configuration.getReplyTo();
    }

    public void setReplyTo(String replyToDestination) {
        this.configuration.setReplyTo(replyToDestination);
    }

    public String getReplyToDestinationSelectorName() {
        return this.configuration.getReplyToDestinationSelectorName();
    }

    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.configuration.setReplyToDestinationSelectorName(replyToDestinationSelectorName);
    }

    public String getReplyToOverride() {
        return this.configuration.getReplyToOverride();
    }

    public void setReplyToOverride(String replyToDestination) {
        this.configuration.setReplyToOverride(replyToDestination);
    }

    public boolean isReplyToSameDestinationAllowed() {
        return this.configuration.isReplyToSameDestinationAllowed();
    }

    public void setReplyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
        this.configuration.setReplyToSameDestinationAllowed(replyToSameDestinationAllowed);
    }

    public JmsMessageType getJmsMessageType() {
        return this.configuration.getJmsMessageType();
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        this.configuration.setJmsMessageType(jmsMessageType);
    }

    public boolean supportBlobMessage() {
        return this.configuration.supportBlobMessage();
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.configuration.getJmsKeyFormatStrategy();
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.configuration.setJmsKeyFormatStrategy(jmsKeyFormatStrategy);
    }

    public boolean isTransferExchange() {
        return this.configuration.isTransferExchange();
    }

    public void setTransferExchange(boolean transferExchange) {
        this.configuration.setTransferExchange(transferExchange);
    }

    public boolean isAllowSerializedHeaders() {
        return this.configuration.isAllowSerializedHeaders();
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.configuration.setAllowSerializedHeaders(allowSerializedHeaders);
    }

    public boolean isTransferException() {
        return this.configuration.isTransferException();
    }

    public void setTransferException(boolean transferException) {
        this.configuration.setTransferException(transferException);
    }

    public boolean isAsyncStartListener() {
        return this.configuration.isAsyncStartListener();
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.configuration.setAsyncStartListener(asyncStartListener);
    }

    public boolean isAsyncStopListener() {
        return this.configuration.isAsyncStopListener();
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.configuration.setAsyncStopListener(asyncStopListener);
    }

    public boolean isTestConnectionOnStartup() {
        return this.configuration.isTestConnectionOnStartup();
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.configuration.setTestConnectionOnStartup(testConnectionOnStartup);
    }

    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.configuration.setForceSendOriginalMessage(forceSendOriginalMessage);
    }

    public boolean isForceSendOriginalMessage() {
        return this.configuration.isForceSendOriginalMessage();
    }

    public boolean isDisableTimeToLive() {
        return this.configuration.isDisableTimeToLive();
    }

    public void setDisableTimeToLive(boolean disableTimeToLive) {
        this.configuration.setDisableTimeToLive(disableTimeToLive);
    }

    public ReplyToType getReplyToType() {
        return this.configuration.getReplyToType();
    }

    public void setReplyToType(ReplyToType replyToType) {
        this.configuration.setReplyToType(replyToType);
    }

    public boolean isAsyncConsumer() {
        return this.configuration.isAsyncConsumer();
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.configuration.setAsyncConsumer(asyncConsumer);
    }

    public void setReplyToCacheLevelName(String name) {
        this.configuration.setReplyToCacheLevelName(name);
    }

    public String getReplyToCacheLevelName() {
        return this.configuration.getReplyToCacheLevelName();
    }

    public boolean isAllowNullBody() {
        return this.configuration.isAllowNullBody();
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.configuration.setAllowNullBody(allowNullBody);
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return this.configuration.getMessageListenerContainerFactory();
    }

    public void setMessageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
        this.configuration.setMessageListenerContainerFactory(messageListenerContainerFactory);
    }

    public boolean isIncludeSentJMSMessageID() {
        return this.configuration.isIncludeSentJMSMessageID();
    }

    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.configuration.setIncludeSentJMSMessageID(includeSentJMSMessageID);
    }

    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return this.configuration.getDefaultTaskExecutorType();
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
        this.configuration.setDefaultTaskExecutorType(defaultTaskExecutorType);
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.configuration.isIncludeAllJMSXProperties();
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.configuration.setIncludeAllJMSXProperties(includeAllJMSXProperties);
    }

    public String getSelector() {
        return this.configuration.getSelector();
    }

    public void setSelector(String selector) {
        this.configuration.setSelector(selector);
    }

    public void setCorrelationProperty(String correlationProperty) {
        this.configuration.setCorrelationProperty(correlationProperty);
    }

    public String getCorrelationProperty() {
        return this.configuration.getCorrelationProperty();
    }

    public String getAllowAdditionalHeaders() {
        return this.configuration.getAllowAdditionalHeaders();
    }

    public void setAllowAdditionalHeaders(String allowAdditionalHeaders) {
        this.configuration.setAllowAdditionalHeaders(allowAdditionalHeaders);
    }

    public boolean isSubscriptionDurable() {
        return this.configuration.isSubscriptionDurable();
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.configuration.setSubscriptionDurable(subscriptionDurable);
    }

    public boolean isSubscriptionShared() {
        return this.configuration.isSubscriptionShared();
    }

    public void setSubscriptionShared(boolean subscriptionShared) {
        this.configuration.setSubscriptionShared(subscriptionShared);
    }

    public String getSubscriptionName() {
        return this.configuration.getSubscriptionName();
    }

    public void setSubscriptionName(String subscriptionName) {
        this.configuration.setSubscriptionName(subscriptionName);
    }

    public boolean isStreamMessageTypeEnabled() {
        return this.configuration.isStreamMessageTypeEnabled();
    }

    public void setStreamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
        this.configuration.setStreamMessageTypeEnabled(streamMessageTypeEnabled);
    }

    public boolean isFormatDateHeadersToIso8601() {
        return this.configuration.isFormatDateHeadersToIso8601();
    }

    public void setFormatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
        this.configuration.setFormatDateHeadersToIso8601(formatDateHeadersToIso8601);
    }

    public long getDeliveryDelay() {
        return this.configuration.getDeliveryDelay();
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.configuration.setDeliveryDelay(deliveryDelay);
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.configuration.getMessageCreatedStrategy();
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.configuration.setMessageCreatedStrategy(messageCreatedStrategy);
    }

    public boolean isArtemisStreamingEnabled() {
        return this.configuration.isArtemisStreamingEnabled();
    }

    public void setArtemisStreamingEnabled(boolean artemisStreamingEnabled) {
        this.configuration.setArtemisStreamingEnabled(artemisStreamingEnabled);
    }

    public void setArtemisConsumerPriority(int priority) {
        this.configuration.setArtemisConsumerPriority(priority);
    }

    public int getArtemisConsumerPriority() {
        return this.configuration.getArtemisConsumerPriority();
    }

    protected void doInit() throws Exception {
        Set beans;
        if (this.configuration.getConnectionFactory() == null && this.configuration.getOrCreateTransactionManager() == null && this.isAllowAutoWiredConnectionFactory()) {
            beans = this.getCamelContext().getRegistry().findByType(ConnectionFactory.class);
            if (beans.size() == 1) {
                ConnectionFactory cf = (ConnectionFactory)beans.iterator().next();
                this.configuration.setConnectionFactory(cf);
            } else if (beans.size() > 1) {
                LOG.debug("Cannot autowire ConnectionFactory as {} instances found in registry.", (Object)beans.size());
            }
        }
        if (this.configuration.getDestinationResolver() == null && this.isAllowAutoWiredDestinationResolver()) {
            beans = this.getCamelContext().getRegistry().findByType(DestinationResolver.class);
            if (beans.size() == 1) {
                DestinationResolver destinationResolver = (DestinationResolver)beans.iterator().next();
                this.configuration.setDestinationResolver(destinationResolver);
            } else if (beans.size() > 1) {
                LOG.debug("Cannot autowire ConnectionFactory as {} instances found in registry.", (Object)beans.size());
            }
        }
        if (this.getHeaderFilterStrategy() == null) {
            this.setHeaderFilterStrategy((HeaderFilterStrategy)new JmsHeaderFilterStrategy(this.configuration.isIncludeAllJMSXProperties()));
        }
        super.doInit();
    }

    protected void doShutdown() throws Exception {
        if (this.asyncStartStopExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.asyncStartStopExecutorService);
            this.asyncStartStopExecutorService = null;
        }
        super.doShutdown();
    }

    protected synchronized ExecutorService getAsyncStartStopExecutorService() {
        if (this.asyncStartStopExecutorService == null) {
            this.asyncStartStopExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AsyncStartStopListener");
        }
        return this.asyncStartStopExecutorService;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint;
        boolean pubSubDomain = false;
        boolean tempDestination = false;
        if (ObjectHelper.isNotEmpty((String)remaining)) {
            if (remaining.startsWith("queue:")) {
                pubSubDomain = false;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            } else if (remaining.startsWith("topic:")) {
                pubSubDomain = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
            } else if (remaining.startsWith("temp-queue:")) {
                pubSubDomain = false;
                tempDestination = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("temp-queue:".length()), (char)'/');
            } else if (remaining.startsWith("temp-topic:")) {
                pubSubDomain = true;
                tempDestination = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("temp-topic:".length()), (char)'/');
            }
        }
        String subject = this.convertPathToActualDestination(remaining, parameters);
        JmsConfiguration newConfiguration = this.getConfiguration().copy();
        if (pubSubDomain) {
            endpoint = tempDestination ? this.createTemporaryTopicEndpoint(uri, this, subject, newConfiguration) : this.createTopicEndpoint(uri, this, subject, newConfiguration);
        } else {
            QueueBrowseStrategy strategy = this.getQueueBrowseStrategy();
            endpoint = tempDestination ? this.createTemporaryQueueEndpoint(uri, this, subject, newConfiguration, strategy) : this.createQueueEndpoint(uri, this, subject, newConfiguration, strategy);
        }
        ConnectionFactory cf = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(parameters, "connectionFactory", ConnectionFactory.class);
        if (cf != null) {
            endpoint.getConfiguration().setConnectionFactory(cf);
        }
        String cfUsername = (String)this.getAndRemoveParameter(parameters, "username", String.class, this.getConfiguration().getUsername());
        String cfPassword = (String)this.getAndRemoveParameter(parameters, "password", String.class, this.getConfiguration().getPassword());
        if (cfUsername != null && cfPassword != null) {
            cf = endpoint.getConfiguration().getOrCreateConnectionFactory();
            ObjectHelper.notNull((Object)cf, (String)"ConnectionFactory");
            LOG.debug("Wrapping existing ConnectionFactory with UserCredentialsConnectionFactoryAdapter using username: {} and password: ******", (Object)cfUsername);
            UserCredentialsConnectionFactoryAdapter ucfa = new UserCredentialsConnectionFactoryAdapter();
            ucfa.setTargetConnectionFactory(cf);
            ucfa.setPassword(cfPassword);
            ucfa.setUsername(cfUsername);
            endpoint.getConfiguration().setConnectionFactory((ConnectionFactory)ucfa);
        } else if (cfUsername != null || cfPassword != null) {
            if (cfUsername == null) {
                throw new IllegalArgumentException("Username must also be provided when using username/password as credentials.");
            }
            throw new IllegalArgumentException("Password must also be provided when using username/password as credentials.");
        }
        String strategyVal = (String)this.getAndRemoveParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, String.class);
        JmsKeyFormatStrategy strategy = JmsComponent.resolveStandardJmsKeyFormatStrategy(strategyVal);
        if (strategy != null) {
            endpoint.setJmsKeyFormatStrategy(strategy);
        } else {
            parameters.put(KEY_FORMAT_STRATEGY_PARAM, strategyVal);
            endpoint.setJmsKeyFormatStrategy((JmsKeyFormatStrategy)this.resolveAndRemoveReferenceParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, JmsKeyFormatStrategy.class));
        }
        MessageListenerContainerFactory messageListenerContainerFactory = (MessageListenerContainerFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageListenerContainerFactoryRef", MessageListenerContainerFactory.class);
        if (messageListenerContainerFactory == null) {
            messageListenerContainerFactory = (MessageListenerContainerFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageListenerContainerFactory", MessageListenerContainerFactory.class);
        }
        if (messageListenerContainerFactory != null) {
            endpoint.setMessageListenerContainerFactory(messageListenerContainerFactory);
        }
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected JmsEndpoint createTemporaryTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new JmsTemporaryTopicEndpoint(uri, component, subject, configuration);
    }

    protected JmsEndpoint createTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new JmsEndpoint(uri, component, subject, true, configuration);
    }

    protected JmsEndpoint createTemporaryQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new JmsTemporaryQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    protected JmsEndpoint createQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new JmsQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    private static JmsKeyFormatStrategy resolveStandardJmsKeyFormatStrategy(String name) {
        if ("default".equalsIgnoreCase(name)) {
            return new DefaultJmsKeyFormatStrategy();
        }
        if ("passthrough".equalsIgnoreCase(name)) {
            return new PassThroughJmsKeyFormatStrategy();
        }
        return null;
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        return path;
    }

    protected JmsConfiguration createConfiguration() {
        return new JmsConfiguration();
    }
}

