/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.PassThroughJmsKeyFormatStrategy;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@Component(value="jms")
public class JmsComponent
extends HeaderFilterStrategyComponent {
    private static final String KEY_FORMAT_STRATEGY_PARAM = "jmsKeyFormatStrategy";
    private ExecutorService asyncStartStopExecutorService;
    @Metadata(label="advanced", description="To use a shared JMS configuration")
    private JmsConfiguration configuration;
    @Metadata(label="advanced", description="To use a custom QueueBrowseStrategy when browsing queues")
    private QueueBrowseStrategy queueBrowseStrategy;
    @Metadata(label="advanced", description="To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.")
    private MessageCreatedStrategy messageCreatedStrategy;

    public JmsComponent() {
        this.configuration = this.createConfiguration();
    }

    public JmsComponent(CamelContext context) {
        super(context);
        this.configuration = this.createConfiguration();
    }

    public JmsComponent(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public static JmsComponent jmsComponent() {
        return new JmsComponent();
    }

    public static JmsComponent jmsComponent(JmsConfiguration configuration) {
        return new JmsComponent(configuration);
    }

    public static JmsComponent jmsComponent(ConnectionFactory connectionFactory) {
        return JmsComponent.jmsComponent(new JmsConfiguration(connectionFactory));
    }

    public static JmsComponent jmsComponentClientAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setAcknowledgementMode(2);
        return JmsComponent.jmsComponent(configuration);
    }

    public static JmsComponent jmsComponentAutoAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setAcknowledgementMode(1);
        return JmsComponent.jmsComponent(configuration);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory) {
        JmsTransactionManager transactionManager = new JmsTransactionManager();
        transactionManager.setConnectionFactory(connectionFactory);
        return JmsComponent.jmsComponentTransacted(connectionFactory, (PlatformTransactionManager)transactionManager);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory, PlatformTransactionManager transactionManager) {
        JmsConfiguration configuration = new JmsConfiguration(connectionFactory);
        configuration.setTransactionManager(transactionManager);
        configuration.setTransacted(true);
        return JmsComponent.jmsComponent(configuration);
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isAllowAutoWiredConnectionFactory() {
        return true;
    }

    public boolean isAllowAutoWiredDestinationResolver() {
        return true;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Metadata(label="consumer,advanced", description="Specifies whether the consumer accept messages while it is stopping. You may consider enabling this option, if you start and stop JMS routes at runtime, while there are still messages enqueued on the queue. If this option is false, and you stop the JMS route, then messages may be rejected, and the JMS broker would have to attempt redeliveries, which yet again may be rejected, and eventually the message may be moved at a dead letter queue on the JMS broker. To avoid this its recommended to enable this option.")
    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    @Metadata(label="consumer,advanced", description="Whether the DefaultMessageListenerContainer used in the reply managers for request-reply messaging allow  the DefaultMessageListenerContainer.runningAllowed flag to quick stop in case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and org.apache.camel.CamelContext is currently being stopped. This quick stop ability is enabled by default in the regular JMS consumers but to enable for reply managers you must enable this flag.")
    public void setAllowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
        this.getConfiguration().setAllowReplyManagerQuickStop(allowReplyManagerQuickStop);
    }

    @Metadata(label="consumer", description="The JMS acknowledgement mode defined as an Integer. Allows you to set vendor-specific extensions to the acknowledgment mode. For the regular modes, it is preferable to use the acknowledgementModeName instead.")
    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    @Metadata(label="consumer,advanced", defaultValue="Poison JMS message due to ${exception.message}", description="If eagerLoadingOfProperties is enabled and the JMS message payload (JMS body or JMS properties) is poison (cannot be read/mapped), then set this text as the message body instead so the message can be processed (the cause of the poison are already stored as exception on the Exchange). This can be turned off by setting eagerPoisonBody=false. See also the option eagerLoadingOfProperties.")
    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.getConfiguration().setEagerPoisonBody(eagerPoisonBody);
    }

    @Metadata(label="consumer,advanced", description="Enables eager loading of JMS properties as soon as a message is loaded which generally is inefficient as the JMS properties may not be required but sometimes can catch early any issues with the underlying JMS provider and the use of JMS properties. See also the option eagerLoadingOfBody.")
    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.getConfiguration().setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    @Metadata(defaultValue="AUTO_ACKNOWLEDGE", label="consumer", enums="SESSION_TRANSACTED,CLIENT_ACKNOWLEDGE,AUTO_ACKNOWLEDGE,DUPS_OK_ACKNOWLEDGE", description="The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE")
    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    @Metadata(label="consumer", defaultValue="true", description="Specifies whether the consumer container should auto-startup.")
    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    @Metadata(label="consumer", description="Sets the cache level by ID for the underlying JMS resources. See cacheLevelName option for more details.")
    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    @Metadata(defaultValue="CACHE_AUTO", label="consumer", enums="CACHE_AUTO,CACHE_CONNECTION,CACHE_CONSUMER,CACHE_NONE,CACHE_SESSION", description="Sets the cache level by name for the underlying JMS resources. Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER, CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See the Spring documentation and Transactions Cache Levels for more information.")
    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    @Metadata(label="producer,advanced", enums="CACHE_AUTO,CACHE_CONNECTION,CACHE_CONSUMER,CACHE_NONE,CACHE_SESSION", description="Sets the cache level by name for the reply consumer when doing request/reply over JMS. This option only applies when using fixed reply queues (not temporary). Camel will by default use: CACHE_CONSUMER for exclusive or shared w/ replyToSelectorName. And CACHE_SESSION for shared without replyToSelectorName. Some JMS brokers such as IBM WebSphere may require to set the replyToCacheLevelName=CACHE_NONE to work. Note: If using temporary queues then CACHE_NONE is not allowed, and you must use a higher value such as CACHE_CONSUMER or CACHE_SESSION.")
    public void setReplyToCacheLevelName(String cacheName) {
        this.getConfiguration().setReplyToCacheLevelName(cacheName);
    }

    @Metadata(description="Sets the JMS client ID to use. Note that this value, if specified, must be unique and can only be used by a single JMS connection instance. It is typically only required for durable topic subscriptions. If using Apache ActiveMQ you may prefer to use Virtual Topics instead.")
    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    @Metadata(defaultValue="1", label="consumer", description="Specifies the default number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.")
    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    @Metadata(defaultValue="1", label="producer", description="Specifies the default number of concurrent consumers when doing request/reply over JMS. See also the maxMessagesPerTask option to control dynamic scaling up/down of threads.")
    public void setReplyToConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setReplyToConcurrentConsumers(concurrentConsumers);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.getConfiguration().getConnectionFactory();
    }

    @Metadata(description="The connection factory to be use. A connection factory must be configured either on the component or endpoint.")
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    @Metadata(label="security", secret=true, description="Username to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.")
    public void setUsername(String username) {
        this.getConfiguration().setUsername(username);
    }

    @Metadata(label="security", secret=true, description="Password to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.")
    public void setPassword(String password) {
        this.getConfiguration().setPassword(password);
    }

    @Metadata(defaultValue="true", label="producer", description="Specifies whether persistent delivery is used by default.")
    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    @Metadata(label="producer", enums="1,2", description="Specifies the delivery mode to be used. Possibles values are those defined by javax.jms.DeliveryMode. NON_PERSISTENT = 1 and PERSISTENT = 2.")
    public void setDeliveryMode(Integer deliveryMode) {
        this.getConfiguration().setDeliveryMode(deliveryMode);
    }

    @Metadata(description="The durable subscriber name for specifying durable topic subscriptions. The clientId option must be configured as well.")
    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    @Metadata(label="advanced", description="Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.")
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    @Metadata(label="advanced", description="Specifies a org.springframework.util.ErrorHandler to be invoked in case of any uncaught exceptions thrown while processing a Message. By default these exceptions will be logged at the WARN level, if no errorHandler has been configured. You can configure logging level and whether stack traces should be logged using errorHandlerLoggingLevel and errorHandlerLogStackTrace options. This makes it much easier to configure, than having to code a custom errorHandler.")
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getConfiguration().setErrorHandler(errorHandler);
    }

    @Metadata(defaultValue="WARN", label="consumer,logging", description="Allows to configure the default errorHandler logging level for logging uncaught exceptions.")
    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.getConfiguration().setErrorHandlerLoggingLevel(errorHandlerLoggingLevel);
    }

    @Metadata(defaultValue="true", label="consumer,logging", description="Allows to control whether stacktraces should be logged or not, by the default errorHandler.")
    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.getConfiguration().setErrorHandlerLogStackTrace(errorHandlerLogStackTrace);
    }

    @Metadata(label="producer", defaultValue="false", description="Set if the deliveryMode, priority or timeToLive qualities of service should be used when sending messages. This option is based on Spring's JmsTemplate. The deliveryMode, priority and timeToLive options are applied to the current endpoint. This contrasts with the preserveMessageQos option, which operates at message granularity, reading QoS properties exclusively from the Camel In message headers.")
    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    @Metadata(label="consumer,advanced", description="Specifies whether the listener session should be exposed when consuming messages.")
    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    @Metadata(defaultValue="1", label="advanced", description="Specifies the limit for idle executions of a receive task, not having received any message within its execution. If this limit is reached, the task will shut down and leave receiving to other executing tasks (in the case of dynamic scheduling; see the maxConcurrentConsumers setting). There is additional doc available from Spring.")
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    @Metadata(defaultValue="1", label="advanced", description="Specify the limit for the number of consumers that are allowed to be idle at any given time.")
    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.getConfiguration().setIdleConsumerLimit(idleConsumerLimit);
    }

    @Metadata(label="consumer", description="Specifies the maximum number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToMaxConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.")
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @Metadata(label="producer", description="Specifies the maximum number of concurrent consumers when using request/reply over JMS. See also the maxMessagesPerTask option to control dynamic scaling up/down of threads.")
    public void setReplyToMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setReplyToMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @Metadata(label="producer", defaultValue="1", description="Specifies the maximum number of concurrent consumers for continue routing when timeout occurred when using request/reply over JMS.")
    public void setReplyOnTimeoutToMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setReplyToOnTimeoutMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @Metadata(defaultValue="-1", label="advanced", description="The number of messages per task. -1 is unlimited. If you use a range for concurrent consumers (eg min < max), then this option can be used to set a value to eg 100 to control how fast the consumers will shrink when less work is required.")
    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    @Metadata(label="advanced", description="To use a custom Spring org.springframework.jms.support.converter.MessageConverter so you can be in control how to map to/from a javax.jms.Message.")
    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    @Metadata(defaultValue="true", label="advanced", description="Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc.")
    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.getConfiguration().setMapJmsMessage(mapJmsMessage);
    }

    @Metadata(defaultValue="true", label="advanced", description="When sending, specifies whether message IDs should be added. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the message ID set to null; if the provider ignores the hint, the message ID must be set to its normal unique value.")
    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    @Metadata(defaultValue="true", label="advanced", description="Specifies whether timestamps should be enabled by default on sending messages. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the timestamp set to zero; if the provider ignores the hint the timestamp must be set to its normal value.")
    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    @Metadata(label="producer,advanced", description="If true, Camel will always make a JMS message copy of the message when it is passed to the producer for sending. Copying the message is needed in some situations, such as when a replyToDestinationSelectorName is set (incidentally, Camel will set the alwaysCopyMessage option to true, if a replyToDestinationSelectorName is set).")
    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    @Metadata(label="advanced", description="Specifies whether JMSMessageID should always be used as JMSCorrelationID for InOut messages.")
    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    @Metadata(defaultValue="4", enums="1,2,3,4,5,6,7,8,9", label="producer", description="Values greater than 1 specify the message priority when sending (where 0 is the lowest priority and 9 is the highest). The explicitQosEnabled option must also be enabled in order for this option to have any effect.")
    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    @Metadata(label="advanced", description="Specifies whether to inhibit the delivery of messages published by its own connection.")
    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    @Metadata(defaultValue="1000", label="advanced", description="The timeout for receiving messages (in milliseconds).")
    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    @Metadata(defaultValue="5000", label="advanced", description="Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.")
    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    @Metadata(label="consumer,advanced", description="Allows you to specify a custom task executor for consuming messages.")
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    @Metadata(defaultValue="-1", label="producer", description="When sending messages, specifies the time-to-live of the message (in milliseconds).")
    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    @Metadata(label="transaction", description="Specifies whether to use transacted mode")
    public void setTransacted(boolean consumerTransacted) {
        this.getConfiguration().setTransacted(consumerTransacted);
    }

    @Metadata(defaultValue="true", label="transaction,advanced", description="If true, Camel will create a JmsTransactionManager, if there is no transactionManager injected when option transacted=true.")
    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.getConfiguration().setLazyCreateTransactionManager(lazyCreating);
    }

    @Metadata(label="transaction,advanced", description="The Spring transaction manager to use.")
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    @Metadata(label="transaction,advanced", description="The name of the transaction to use.")
    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    @Metadata(defaultValue="-1", label="transaction,advanced", description="The timeout value of the transaction (in seconds), if using transacted mode.")
    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    @Metadata(description="Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.")
    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.getConfiguration().setTestConnectionOnStartup(testConnectionOnStartup);
    }

    @Metadata(label="advanced", description="Whether to startup the JmsConsumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.")
    public void setAsyncStartListener(boolean asyncStartListener) {
        this.getConfiguration().setAsyncStartListener(asyncStartListener);
    }

    @Metadata(label="advanced", description="Whether to stop the JmsConsumer message listener asynchronously, when stopping a route.")
    public void setAsyncStopListener(boolean asyncStopListener) {
        this.getConfiguration().setAsyncStopListener(asyncStopListener);
    }

    @Metadata(label="producer,advanced", description="When using mapJmsMessage=false Camel will create a new JMS message to send to a new JMS destination if you touch the headers (get or set) during the route. Set this option to true to force Camel to send the original JMS message that was received.")
    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.getConfiguration().setForceSendOriginalMessage(forceSendOriginalMessage);
    }

    @Metadata(defaultValue="20000", label="producer", description="The timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds). The default is 20 seconds. You can include the header \"CamelJmsRequestTimeout\" to override this endpoint configured timeout value, and thus have per message individual timeout values. See also the requestTimeoutCheckerInterval option.")
    public void setRequestTimeout(long requestTimeout) {
        this.getConfiguration().setRequestTimeout(requestTimeout);
    }

    @Metadata(defaultValue="1000", label="advanced", description="Configures how often Camel should check for timed out Exchanges when doing request/reply over JMS. By default Camel checks once per second. But if you must react faster when a timeout occurs, then you can lower this interval, to check more frequently. The timeout is determined by the option requestTimeout.")
    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.getConfiguration().setRequestTimeoutCheckerInterval(requestTimeoutCheckerInterval);
    }

    @Metadata(label="advanced", description="You can transfer the exchange over the wire instead of just the body and headers. The following fields are transferred: In body, Out body, Fault body, In headers, Out headers, Fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level. You must enable this option on both the producer and consumer side, so Camel knows the payloads is an Exchange and not a regular payload. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level,  which forces a strong coupling between the producers and consumer having to use compatible Camel versions!")
    public void setTransferExchange(boolean transferExchange) {
        this.getConfiguration().setTransferExchange(transferExchange);
    }

    @Metadata(label="advanced", description="If enabled and you are using Request Reply messaging (InOut) and an Exchange failed on the consumer side, then the caused Exception will be send back in response as a javax.jms.ObjectMessage. If the client is Camel, the returned Exception is rethrown. This allows you to use Camel JMS as a bridge in your routing - for example, using persistent queues to enable robust routing. Notice that if you also have transferExchange enabled, this option takes precedence. The caught exception is required to be serializable. The original Exception on the consumer side can be wrapped in an outer exception such as org.apache.camel.RuntimeCamelException when returned to the producer. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level,  which forces a strong coupling between the producers and consumer!")
    public void setTransferException(boolean transferException) {
        this.getConfiguration().setTransferException(transferException);
    }

    @Metadata(label="advanced", description="Allows you to use your own implementation of the org.springframework.jms.core.JmsOperations interface. Camel uses JmsTemplate as default. Can be used for testing purpose, but not used much as stated in the spring API docs.")
    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    @Metadata(label="advanced", description="A pluggable org.springframework.jms.support.destination.DestinationResolver that allows you to use your own resolver (for example, to lookup the real destination in a JNDI registry).")
    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    @Metadata(label="producer", description="Allows for explicitly specifying which kind of strategy to use for replyTo queues when doing request/reply over JMS. Possible values are: Temporary, Shared, or Exclusive. By default Camel will use temporary queues. However if replyTo has been configured, then Shared is used by default. This option allows you to use exclusive queues instead of shared ones. See Camel JMS documentation for more details, and especially the notes about the implications if running in a clustered environment, and the fact that Shared reply queues has lower performance than its alternatives Temporary and Exclusive.")
    public void setReplyToType(ReplyToType replyToType) {
        this.getConfiguration().setReplyToType(replyToType);
    }

    @Metadata(label="producer", description="Set to true, if you want to send message using the QoS settings specified on the message, instead of the QoS settings on the JMS endpoint. The following three headers are considered JMSPriority, JMSDeliveryMode, and JMSExpiration. You can provide all or only some of them. If not provided, Camel will fall back to use the values from the endpoint instead. So, when using this option, the headers override the values from the endpoint. The explicitQosEnabled option, by contrast, will only use options set on the endpoint, and not values from the message header.")
    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.getConfiguration().setPreserveMessageQos(preserveMessageQos);
    }

    @Metadata(label="consumer", description="Whether the JmsConsumer processes the Exchange asynchronously. If enabled then the JmsConsumer may pickup the next message from the JMS queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the JmsConsumer will pickup the next message from the JMS queue. Note if transacted has been enabled, then asyncConsumer=true does not run asynchronously, as transaction  must be executed synchronously (Camel 3.0 may support async transactions).")
    public void setAsyncConsumer(boolean asyncConsumer) {
        this.getConfiguration().setAsyncConsumer(asyncConsumer);
    }

    @Metadata(defaultValue="true", label="producer,advanced", description="Whether to allow sending messages with no body. If this option is false and the message body is null, then an JMSException is thrown.")
    public void setAllowNullBody(boolean allowNullBody) {
        this.getConfiguration().setAllowNullBody(allowNullBody);
    }

    @Metadata(label="producer,advanced", description="Only applicable when sending to JMS destination using InOnly (eg fire and forget). Enabling this option will enrich the Camel Exchange with the actual JMSMessageID that was used by the JMS client when the message was sent to the JMS destination.")
    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.getConfiguration().setIncludeSentJMSMessageID(includeSentJMSMessageID);
    }

    @Metadata(label="advanced", description="Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.")
    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.getConfiguration().setIncludeAllJMSXProperties(includeAllJMSXProperties);
    }

    @Metadata(label="consumer,advanced", description="Specifies what default TaskExecutor type to use in the DefaultMessageListenerContainer, for both consumer endpoints and the ReplyTo consumer of producer endpoints. Possible values: SimpleAsync (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's ThreadPoolTaskExecutor with optimal values - cached threadpool-like). If not set, it defaults to the previous behaviour, which uses a cached thread pool for consumer endpoints and SimpleAsync for reply consumers. The use of ThreadPool is recommended to reduce thread trash in elastic configurations with dynamically increasing and decreasing concurrent consumers.")
    public void setDefaultTaskExecutorType(DefaultTaskExecutorType type) {
        this.getConfiguration().setDefaultTaskExecutorType(type);
    }

    @Metadata(label="advanced", description="Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.")
    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.getConfiguration().setJmsKeyFormatStrategy(jmsKeyFormatStrategy);
    }

    public void setJmsKeyFormatStrategy(String jmsKeyFormatStrategyName) {
        JmsKeyFormatStrategy strategy = JmsComponent.resolveStandardJmsKeyFormatStrategy(jmsKeyFormatStrategyName);
        if (strategy == null) {
            throw new IllegalArgumentException("JmsKeyFormatStrategy with name " + jmsKeyFormatStrategyName + " is not a standard supported name");
        }
        this.getConfiguration().setJmsKeyFormatStrategy(strategy);
    }

    @Metadata(label="producer,advanced", description="This option is used to allow additional headers which may have values that are invalid according to JMS specification. For example some message systems such as WMQ do this with header names using prefix JMS_IBM_MQMD_ containing values with byte array or other invalid types. You can specify multiple header names separated by comma, and use * as suffix for wildcard matching.")
    public void setAllowAdditionalHeaders(String allowAdditionalHeaders) {
        this.getConfiguration().setAllowAdditionalHeaders(allowAdditionalHeaders);
    }

    public QueueBrowseStrategy getQueueBrowseStrategy() {
        if (this.queueBrowseStrategy == null) {
            this.queueBrowseStrategy = new DefaultQueueBrowseStrategy();
        }
        return this.queueBrowseStrategy;
    }

    public void setQueueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public int getWaitForProvisionCorrelationToBeUpdatedCounter() {
        return this.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedCounter();
    }

    @Metadata(defaultValue="50", label="advanced", description="Number of times to wait for provisional correlation id to be updated to the actual correlation id when doing request/reply over JMS and when the option useMessageIDAsCorrelationID is enabled.")
    public void setWaitForProvisionCorrelationToBeUpdatedCounter(int counter) {
        this.getConfiguration().setWaitForProvisionCorrelationToBeUpdatedCounter(counter);
    }

    public long getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime() {
        return this.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
    }

    @Metadata(defaultValue="100", label="advanced", description="Interval in millis to sleep each time while waiting for provisional correlation id to be updated.")
    public void setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long sleepingTime) {
        this.getConfiguration().setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(sleepingTime);
    }

    @Metadata(label="producer,advanced", description="Use this JMS property to correlate messages in InOut exchange pattern (request-reply) instead of JMSCorrelationID property. This allows you to exchange messages with systems that do not correlate messages using JMSCorrelationID JMS property. If used JMSCorrelationID will not be used or set by Camel. The value of here named property will be generated if not supplied in the header of the message under the same name.")
    public void setCorrelationProperty(String correlationProperty) {
        this.getConfiguration().setCorrelationProperty(correlationProperty);
    }

    public boolean isSubscriptionDurable() {
        return this.getConfiguration().isSubscriptionDurable();
    }

    @Metadata(label="consumer", description="Set whether to make the subscription durable. The durable subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a durable subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well.")
    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    public boolean isSubscriptionShared() {
        return this.getConfiguration().isSubscriptionShared();
    }

    @Metadata(label="consumer", description="Set whether to make the subscription shared. The shared subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a shared subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Note that shared subscriptions may also be durable, so this flag can (and often will) be combined with subscriptionDurable as well. Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well. Requires a JMS 2.0 compatible message broker.")
    public void setSubscriptionShared(boolean subscriptionShared) {
        this.getConfiguration().setSubscriptionShared(subscriptionShared);
    }

    public String getSubscriptionName() {
        return this.getConfiguration().getSubscriptionName();
    }

    @Metadata(label="consumer", description="Set the name of a subscription to create. To be applied in case of a topic (pub-sub domain) with a shared or durable subscription. The subscription name needs to be unique within this client's JMS client id. Default is the class name of the specified message listener. Note: Only 1 concurrent consumer (which is the default of this message listener container) is allowed for each subscription, except for a shared subscription (which requires JMS 2.0).")
    public void setSubscriptionName(String subscriptionName) {
        this.getConfiguration().setSubscriptionName(subscriptionName);
    }

    public boolean isStreamMessageTypeEnabled() {
        return this.getConfiguration().isStreamMessageTypeEnabled();
    }

    @Metadata(label="producer,advanced", description="Sets whether StreamMessage type is enabled or not. Message payloads of streaming kind such as files, InputStream, etc will either by sent as BytesMessage or StreamMessage. This option controls which kind will be used. By default BytesMessage is used which enforces the entire message payload to be read into memory. By enabling this option the message payload is read into memory in chunks and each chunk is then written to the StreamMessage until no more data.")
    public void setStreamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
        this.getConfiguration().setStreamMessageTypeEnabled(streamMessageTypeEnabled);
    }

    public boolean isFormatDateHeadersToIso8601() {
        return this.getConfiguration().isFormatDateHeadersToIso8601();
    }

    @Metadata(label="producer", description="Sets whether date headers should be formatted according to the ISO 8601 standard.")
    public void setFormatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
        this.getConfiguration().setFormatDateHeadersToIso8601(formatDateHeadersToIso8601);
    }

    protected void doStart() throws Exception {
        Set beans;
        if (this.configuration.getConnectionFactory() == null && this.isAllowAutoWiredConnectionFactory()) {
            beans = this.getCamelContext().getRegistry().findByType(ConnectionFactory.class);
            if (beans.size() == 1) {
                ConnectionFactory cf = (ConnectionFactory)beans.iterator().next();
                this.configuration.setConnectionFactory(cf);
            } else if (beans.size() > 1) {
                this.log.debug("Cannot autowire ConnectionFactory as " + beans.size() + " instances found in registry.");
            }
        }
        if (this.configuration.getDestinationResolver() == null && this.isAllowAutoWiredDestinationResolver()) {
            beans = this.getCamelContext().getRegistry().findByType(DestinationResolver.class);
            if (beans.size() == 1) {
                DestinationResolver destinationResolver = (DestinationResolver)beans.iterator().next();
                this.configuration.setDestinationResolver(destinationResolver);
            } else if (beans.size() > 1) {
                this.log.debug("Cannot autowire ConnectionFactory as " + beans.size() + " instances found in registry.");
            }
        }
        if (this.getHeaderFilterStrategy() == null) {
            this.setHeaderFilterStrategy((HeaderFilterStrategy)new JmsHeaderFilterStrategy(this.configuration.isIncludeAllJMSXProperties()));
        }
    }

    protected void doShutdown() throws Exception {
        if (this.asyncStartStopExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.asyncStartStopExecutorService);
            this.asyncStartStopExecutorService = null;
        }
        super.doShutdown();
    }

    protected synchronized ExecutorService getAsyncStartStopExecutorService() {
        if (this.asyncStartStopExecutorService == null) {
            this.asyncStartStopExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AsyncStartStopListener");
        }
        return this.asyncStartStopExecutorService;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint;
        boolean pubSubDomain = false;
        boolean tempDestination = false;
        if (ObjectHelper.isNotEmpty((Object)remaining)) {
            if (remaining.startsWith("queue:")) {
                pubSubDomain = false;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            } else if (remaining.startsWith("topic:")) {
                pubSubDomain = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
            } else if (remaining.startsWith("temp-queue:")) {
                pubSubDomain = false;
                tempDestination = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("temp-queue:".length()), (char)'/');
            } else if (remaining.startsWith("temp-topic:")) {
                pubSubDomain = true;
                tempDestination = true;
                remaining = StringHelper.removeStartingCharacters((String)remaining.substring("temp-topic:".length()), (char)'/');
            }
        }
        String subject = this.convertPathToActualDestination(remaining, parameters);
        JmsConfiguration newConfiguration = this.getConfiguration().copy();
        if (pubSubDomain) {
            endpoint = tempDestination ? this.createTemporaryTopicEndpoint(uri, this, subject, newConfiguration) : this.createTopicEndpoint(uri, this, subject, newConfiguration);
        } else {
            QueueBrowseStrategy strategy = this.getQueueBrowseStrategy();
            endpoint = tempDestination ? this.createTemporaryQueueEndpoint(uri, this, subject, newConfiguration, strategy) : this.createQueueEndpoint(uri, this, subject, newConfiguration, strategy);
        }
        ConnectionFactory cf = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(parameters, "connectionFactory", ConnectionFactory.class);
        if (cf != null) {
            endpoint.getConfiguration().setConnectionFactory(cf);
        }
        String cfUsername = (String)this.getAndRemoveParameter(parameters, "username", String.class, this.getConfiguration().getUsername());
        String cfPassword = (String)this.getAndRemoveParameter(parameters, "password", String.class, this.getConfiguration().getPassword());
        if (cfUsername != null && cfPassword != null) {
            cf = endpoint.getConfiguration().getOrCreateConnectionFactory();
            ObjectHelper.notNull((Object)cf, (String)"ConnectionFactory");
            this.log.debug("Wrapping existing ConnectionFactory with UserCredentialsConnectionFactoryAdapter using username: {} and password: ******", (Object)cfUsername);
            UserCredentialsConnectionFactoryAdapter ucfa = new UserCredentialsConnectionFactoryAdapter();
            ucfa.setTargetConnectionFactory(cf);
            ucfa.setPassword(cfPassword);
            ucfa.setUsername(cfUsername);
            endpoint.getConfiguration().setConnectionFactory((ConnectionFactory)ucfa);
        } else if (cfUsername != null || cfPassword != null) {
            if (cfUsername == null) {
                throw new IllegalArgumentException("Username must also be provided when using username/password as credentials.");
            }
            throw new IllegalArgumentException("Password must also be provided when using username/password as credentials.");
        }
        String strategyVal = (String)this.getAndRemoveParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, String.class);
        JmsKeyFormatStrategy strategy = JmsComponent.resolveStandardJmsKeyFormatStrategy(strategyVal);
        if (strategy != null) {
            endpoint.setJmsKeyFormatStrategy(strategy);
        } else {
            parameters.put(KEY_FORMAT_STRATEGY_PARAM, strategyVal);
            endpoint.setJmsKeyFormatStrategy((JmsKeyFormatStrategy)this.resolveAndRemoveReferenceParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, JmsKeyFormatStrategy.class));
        }
        MessageListenerContainerFactory messageListenerContainerFactory = (MessageListenerContainerFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageListenerContainerFactoryRef", MessageListenerContainerFactory.class);
        if (messageListenerContainerFactory == null) {
            messageListenerContainerFactory = (MessageListenerContainerFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageListenerContainerFactory", MessageListenerContainerFactory.class);
        }
        if (messageListenerContainerFactory != null) {
            endpoint.setMessageListenerContainerFactory(messageListenerContainerFactory);
        }
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        this.setProperties(endpoint.getConfiguration(), parameters);
        return endpoint;
    }

    protected JmsEndpoint createTemporaryTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new JmsTemporaryTopicEndpoint(uri, component, subject, configuration);
    }

    protected JmsEndpoint createTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new JmsEndpoint(uri, component, subject, true, configuration);
    }

    protected JmsEndpoint createTemporaryQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new JmsTemporaryQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    protected JmsEndpoint createQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new JmsQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    private static JmsKeyFormatStrategy resolveStandardJmsKeyFormatStrategy(String name) {
        if ("default".equalsIgnoreCase(name)) {
            return new DefaultJmsKeyFormatStrategy();
        }
        if ("passthrough".equalsIgnoreCase(name)) {
            return new PassThroughJmsKeyFormatStrategy();
        }
        return null;
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        return path;
    }

    protected JmsConfiguration createConfiguration() {
        return new JmsConfiguration();
    }
}

