/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.reply.CorrelationTimeoutMap;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHolder;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public abstract class ReplyManagerSupport
extends ServiceSupport
implements ReplyManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ScheduledExecutorService executorService;
    protected JmsEndpoint endpoint;
    protected Destination replyTo;
    protected AbstractMessageListenerContainer listenerContainer;
    protected final CountDownLatch replyToLatch = new CountDownLatch(1);
    protected final long replyToTimeout = 10000L;
    protected CorrelationTimeoutMap correlation;

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void setEndpoint(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setReplyTo(Destination replyTo) {
        this.log.trace("ReplyTo destination: {}", (Object)replyTo);
        this.replyTo = replyTo;
        this.replyToLatch.countDown();
    }

    @Override
    public Destination getReplyTo() {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        try {
            this.log.trace("Waiting for replyTo to be set");
            boolean done = this.replyToLatch.await(10000L, TimeUnit.MILLISECONDS);
            if (!done) {
                this.log.warn("ReplyTo destination was not set and timeout occurred");
            } else {
                this.log.trace("Waiting for replyTo to be set done");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.replyTo;
    }

    public void onMessage(javax.jms.Message message) {
        String correlationID = null;
        try {
            correlationID = message.getJMSCorrelationID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (correlationID == null) {
            this.log.warn("Ignoring message with no correlationID: " + message);
            return;
        }
        this.log.debug("Received reply message with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        this.handleReplyMessage(correlationID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processReply(ReplyHolder holder) {
        if (holder != null && this.isRunAllowed()) {
            try {
                Exchange exchange = holder.getExchange();
                javax.jms.Message message = holder.getMessage();
                boolean timeout = holder.isTimeout();
                if (timeout) {
                    this.log.warn("Timeout occurred after {} millis waiting for reply message with correlationID [{}]. Setting ExchangeTimedOutException on ExchangeId: {} and continue routing.", new Object[]{holder.getRequestTimeout(), holder.getCorrelationId(), exchange.getExchangeId()});
                    String msg = "reply message with correlationID: " + holder.getCorrelationId() + " not received";
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, holder.getRequestTimeout(), msg));
                } else {
                    JmsMessage response = new JmsMessage(message, this.endpoint.getBinding());
                    Object body = response.getBody();
                    if (this.endpoint.isTransferException() && body instanceof Exception) {
                        this.log.debug("Reply received. Setting reply as an Exception: {}", body);
                        exchange.setException((Throwable)((Exception)body));
                    } else {
                        this.log.debug("Reply received. Setting reply as OUT message: {}", body);
                        exchange.setOut((Message)response);
                    }
                    if (holder.getOriginalCorrelationId() != null) {
                        JmsMessageHelper.setCorrelationId(message, holder.getOriginalCorrelationId());
                        exchange.getOut().setHeader("JMSCorrelationID", (Object)holder.getOriginalCorrelationId());
                    }
                }
            }
            finally {
                AsyncCallback callback = holder.getCallback();
                callback.done(false);
            }
        }
    }

    protected abstract void handleReplyMessage(String var1, javax.jms.Message var2);

    protected abstract AbstractMessageListenerContainer createListenerContainer() throws Exception;

    protected ReplyHandler waitForProvisionCorrelationToBeUpdated(String correlationID, javax.jms.Message message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("Early reply received with correlationID [" + correlationID + "] -> " + message);
        }
        ReplyHandler answer = null;
        boolean done = false;
        int counter = 0;
        while (!done && counter++ < 50) {
            this.log.trace("Early reply not found handler at attempt {}. Waiting a bit longer.", (Object)counter);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            answer = (ReplyHandler)this.correlation.get(correlationID);
            boolean bl = done = answer != null;
            if (answer == null || !this.log.isTraceEnabled()) continue;
            this.log.trace("Early reply with correlationID [{}] has been matched after {} attempts and can be processed using handler: {}", new Object[]{correlationID, counter, answer});
        }
        return answer;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.executorService, (String)"executorService", (Object)this);
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint", (Object)this);
        this.correlation = new CorrelationTimeoutMap(this.executorService, 1000L);
        ServiceHelper.startService((Service)this.correlation);
        this.listenerContainer = this.createListenerContainer();
        this.listenerContainer.afterPropertiesSet();
        this.log.info("Starting reply listener container on endpoint: " + (Object)((Object)this.endpoint));
        this.listenerContainer.start();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.correlation));
        if (this.listenerContainer != null) {
            this.log.info("Stopping reply listener container on endpoint: " + (Object)((Object)this.endpoint));
            this.listenerContainer.stop();
            this.listenerContainer.destroy();
            this.listenerContainer = null;
        }
    }
}

