/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.RuntimeJmsException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsBinding {
    private static final transient Log LOG = LogFactory.getLog(JmsBinding.class);
    private JmsEndpoint endpoint;
    private Set<String> ignoreJmsHeaders;
    private XmlConverter xmlConverter = new XmlConverter();

    public JmsBinding() {
    }

    public JmsBinding(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Object extractBodyFromJms(Exchange exchange, javax.jms.Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage) {
                return this.createByteArrayFromBytesMessage((BytesMessage)message);
            }
            if (message instanceof StreamMessage) {
                return message;
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeJmsException("Failed to extract body due to: " + (Object)((Object)e) + ". Message: " + message, e);
        }
    }

    protected byte[] createByteArrayFromBytesMessage(BytesMessage message) throws JMSException {
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            return null;
        }
        byte[] result = new byte[(int)message.getBodyLength()];
        message.readBytes(result);
        return result;
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Session session) throws JMSException {
        return this.makeJmsMessage(exchange, exchange.getIn(), session);
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Message camelMessage, Session session) throws JMSException {
        JmsMessage jmsMessage;
        boolean alwaysCopy;
        javax.jms.Message answer = null;
        boolean bl = alwaysCopy = this.endpoint != null ? this.endpoint.getConfiguration().isAlwaysCopyMessage() : false;
        if (!alwaysCopy && camelMessage instanceof JmsMessage && !(jmsMessage = (JmsMessage)camelMessage).shouldCreateNewMessage()) {
            answer = jmsMessage.getJmsMessage();
        }
        if (answer == null) {
            answer = this.createJmsMessage(camelMessage.getBody(), session, exchange.getContext());
            this.appendJmsProperties(answer, exchange, camelMessage);
        }
        return answer;
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange) throws JMSException {
        this.appendJmsProperties(jmsMessage, exchange, exchange.getIn());
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange, Message in) throws JMSException {
        Set entries = in.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            this.appendJmsProperty(jmsMessage, exchange, in, headerName, headerValue);
        }
    }

    public void appendJmsProperty(javax.jms.Message jmsMessage, Exchange exchange, Message in, String headerName, Object headerValue) throws JMSException {
        if (headerName.startsWith("JMS") && !headerName.startsWith("JMSX")) {
            if (headerName.equals("JMSCorrelationID")) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSCorrelationID")) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSReplyTo") && headerValue != null) {
                jmsMessage.setJMSReplyTo((Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, (Object)headerValue));
            } else if (headerName.equals("JMSType")) {
                jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring JMS header: " + headerName + " with value: " + headerValue));
            }
        } else if (this.shouldOutputHeader(in, headerName, headerValue)) {
            String key = JmsBinding.encodeToSafeJmsHeaderName(headerName);
            Object value = this.getValidJMSHeaderValue(headerName, headerValue);
            if (value != null) {
                jmsMessage.setObjectProperty(key, headerValue);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring non primitive header: " + headerName + " of class: " + headerValue.getClass().getName() + " with value: " + headerValue));
            }
        }
    }

    protected Object getValidJMSHeaderValue(String headerName, Object headerValue) {
        if (headerValue.getClass().isPrimitive()) {
            return headerValue;
        }
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Character) {
            return headerValue.toString();
        }
        if (headerValue instanceof BigDecimal || headerValue instanceof BigInteger) {
            return headerValue.toString();
        }
        if (headerValue instanceof CharSequence) {
            return headerValue.toString();
        }
        if (headerValue instanceof Date) {
            return headerValue.toString();
        }
        return null;
    }

    protected javax.jms.Message createJmsMessage(Object body, Session session, CamelContext context) throws JMSException {
        if (body instanceof Node) {
            try {
                body = this.xmlConverter.toString((Node)body);
            }
            catch (TransformerException e) {
                JMSException jmsException = new JMSException(e.getMessage());
                jmsException.setLinkedException((Exception)e);
                throw jmsException;
            }
        }
        if (body instanceof byte[]) {
            BytesMessage result = session.createBytesMessage();
            result.writeBytes((byte[])body);
            return result;
        }
        if (body instanceof Map) {
            MapMessage result = session.createMapMessage();
            Map map = (Map)body;
            try {
                this.populateMapMessage(result, map, context);
                return result;
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (body instanceof String) {
            return session.createTextMessage((String)body);
        }
        if (body instanceof Serializable) {
            return session.createObjectMessage((Serializable)body);
        }
        return session.createMessage();
    }

    protected void populateMapMessage(MapMessage message, Map<?, ?> map, CamelContext context) throws JMSException {
        for (Object key : map.keySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, key);
            if (keyString == null) continue;
            message.setObject(keyString, map.get(key));
        }
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    public Set<String> getIgnoreJmsHeaders() {
        if (this.ignoreJmsHeaders == null) {
            this.ignoreJmsHeaders = new HashSet<String>();
            this.populateIgnoreJmsHeaders(this.ignoreJmsHeaders);
        }
        return this.ignoreJmsHeaders;
    }

    public void setIgnoreJmsHeaders(Set<String> ignoreJmsHeaders) {
        this.ignoreJmsHeaders = ignoreJmsHeaders;
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        String key = JmsBinding.encodeToSafeJmsHeaderName(headerName);
        return headerValue != null && !this.getIgnoreJmsHeaders().contains(headerName) && ObjectHelper.isJavaIdentifier((String)key);
    }

    public static String encodeToSafeJmsHeaderName(String headerName) {
        return headerName.replace(".", "_");
    }

    public static String decodeFromSafeJmsHeaderName(String headerName) {
        return headerName.replace("_", ".");
    }

    protected void populateIgnoreJmsHeaders(Set<String> set) {
        String[] ignore = new String[]{"JMSXUserID", "JMSXAppID", "JMSXDeliveryCount", "JMSXProducerTXID", "JMSXConsumerTXID", "JMSXRcvTimestamp", "JMSXRecvTimestamp", "JMSXState"};
        set.addAll(Arrays.asList(ignore));
    }
}

