/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.MessageJMSPropertyAccessException;
import org.apache.camel.component.jms.MessagePropertyAccessException;
import org.apache.camel.component.jms.MessagePropertyNamesAccessException;
import org.apache.camel.impl.DefaultMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessage
extends DefaultMessage {
    private static final transient Log LOG = LogFactory.getLog(JmsMessage.class);
    private Message jmsMessage;
    private JmsBinding binding;

    public JmsMessage() {
    }

    public JmsMessage(Message jmsMessage) {
        this.setJmsMessage(jmsMessage);
    }

    public JmsMessage(Message jmsMessage, JmsBinding binding) {
        this(jmsMessage);
        this.setBinding(binding);
    }

    public String toString() {
        if (this.jmsMessage != null) {
            return "JmsMessage: " + this.jmsMessage;
        }
        return "JmsMessage: " + this.getBody();
    }

    public Message getJmsMessage() {
        return this.jmsMessage;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            Exchange exchange = this.getExchange();
            if (exchange instanceof JmsExchange) {
                JmsExchange jmsExchange = (JmsExchange)exchange;
                return jmsExchange.getBinding();
            }
            return new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public void setJmsMessage(Message jmsMessage) {
        this.jmsMessage = jmsMessage;
        try {
            String id = this.getDestinationAsString(jmsMessage.getJMSDestination());
            id = id + this.getSanitizedString(jmsMessage.getJMSMessageID());
            this.setMessageId(id);
        }
        catch (JMSException e) {
            LOG.error((Object)("Failed to get message id from message " + jmsMessage), (Throwable)e);
        }
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.jmsMessage != null && !name.startsWith("JMS")) {
            try {
                answer = this.jmsMessage.getObjectProperty(name);
            }
            catch (JMSException e) {
                throw new MessagePropertyAccessException(name, e);
            }
        }
        if (answer == null) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public JmsMessage newInstance() {
        return new JmsMessage();
    }

    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null) {
            Enumeration names;
            try {
                map.put("JMSCorrelationID", this.jmsMessage.getJMSCorrelationID());
                map.put("JMSDeliveryMode", this.jmsMessage.getJMSDeliveryMode());
                map.put("JMSDestination", this.jmsMessage.getJMSDestination());
                map.put("JMSExpiration", this.jmsMessage.getJMSExpiration());
                map.put("JMSMessageID", this.jmsMessage.getJMSMessageID());
                map.put("JMSPriority", this.jmsMessage.getJMSPriority());
                map.put("JMSRedelivered", this.jmsMessage.getJMSRedelivered());
                map.put("JMSReplyTo", this.jmsMessage.getJMSReplyTo());
                map.put("JMSTimestamp", this.jmsMessage.getJMSTimestamp());
                map.put("JMSType", this.jmsMessage.getJMSType());
                map.put("JMSXGroupID", this.jmsMessage.getStringProperty("JMSXGroupID"));
            }
            catch (JMSException e) {
                throw new MessageJMSPropertyAccessException(e);
            }
            try {
                names = this.jmsMessage.getPropertyNames();
            }
            catch (JMSException e) {
                throw new MessagePropertyNamesAccessException(e);
            }
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                try {
                    Object value = this.jmsMessage.getObjectProperty(name);
                    map.put(name, value);
                }
                catch (JMSException e) {
                    throw new MessagePropertyAccessException(name, e);
                }
            }
        }
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = "";
        result = destination == null ? "null destination!" : (destination instanceof Topic ? result + "topic" + File.separator + this.getSanitizedString(((Topic)destination).getTopicName()) : result + "queue" + File.separator + this.getSanitizedString(((Queue)destination).getQueueName()));
        result = result + File.separator;
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

