/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty.cloud;

import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.util.ObjectHelper;

public final class JettyServiceExpression
extends DefaultServiceCallExpression {
    public JettyServiceExpression() {
    }

    public JettyServiceExpression(String hostHeader, String portHeader) {
        super(hostHeader, portHeader);
    }

    protected String doBuildCamelEndpointUri(String host, Integer port, String contextPath, String scheme) {
        if (!ObjectHelper.equal((Object)scheme, (Object)"jetty")) {
            return super.doBuildCamelEndpointUri(host, port, contextPath, scheme);
        }
        String answer = scheme + ":http://" + host;
        if (port != null) {
            answer = answer + ":" + port;
        }
        if (contextPath != null) {
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            answer = answer + contextPath;
        }
        return answer;
    }
}

