/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcProducer
extends DefaultProducer<DefaultExchange> {
    private static final transient Log LOG = LogFactory.getLog(JdbcProducer.class);
    private DataSource dataSource;
    private int readSize;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, int readSize) throws Exception {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.readSize = readSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing JDBC statement: " + sql));
            }
            if (stmt.execute(sql)) {
                rs = stmt.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getOut().setHeader("jdbc.updateCount", (Object)updateCount);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)("Error closing JDBC resource: " + e), (Throwable)e);
            }
        }
    }

    protected void setResultSet(Exchange exchange, ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        HashMap props = new HashMap();
        IntrospectionSupport.getProperties((Object)meta, props, (String)"jdbc.");
        exchange.getOut().setHeaders(props);
        int count = meta.getColumnCount();
        ArrayList data = new ArrayList();
        for (int rowNumber = 0; rs.next() && (this.readSize == 0 || rowNumber < this.readSize); ++rowNumber) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                int columnNumber = i + 1;
                String columnName = meta.getColumnName(columnNumber);
                row.put(columnName, rs.getObject(columnName));
            }
            data.add(row);
        }
        exchange.getOut().setBody(data);
    }
}

