/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jdbc.JdbcComponent;
import org.apache.camel.component.jdbc.JdbcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcEndpoint
extends DefaultEndpoint<DefaultExchange> {
    private URI uri;
    private String remaining;
    private int readSize = 20000;

    protected JdbcEndpoint(String endpointUri, String remaining, JdbcComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.uri = new URI(endpointUri);
        this.remaining = remaining;
    }

    public JdbcEndpoint(String endpointUri, String remaining) throws URISyntaxException {
        super(endpointUri);
        this.remaining = remaining;
        this.uri = new URI(endpointUri);
    }

    public boolean isSingleton() {
        return false;
    }

    public Consumer<DefaultExchange> createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("A JDBC Consumer would be the server side of database! No such support here");
    }

    public Producer<DefaultExchange> createProducer() throws Exception {
        return new JdbcProducer(this, this.remaining, this.readSize);
    }

    public String getName() {
        String path = this.uri.getPath();
        if (path == null) {
            path = this.uri.getSchemeSpecificPart();
        }
        return path;
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }
}

