/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.camel.Converter;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;

@Converter(generateLoader=true)
public final class JcrConverter {
    private JcrConverter() {
    }

    @Converter
    public static Value toValue(Boolean bool) {
        return new BooleanValue(bool);
    }

    @Converter
    public static Value toValue(InputStream stream) {
        return new BinaryValue(stream);
    }

    @Converter
    public static Value toValue(Calendar calendar) {
        return new DateValue(calendar);
    }

    @Converter
    public static Value toValue(String value) {
        return new StringValue(value);
    }

    @Converter
    public static Boolean toBoolean(Value value) throws RepositoryException {
        return value.getBoolean();
    }

    @Converter
    public static InputStream toValue(Value value) throws RepositoryException {
        return value.getBinary().getStream();
    }

    @Converter
    public static Calendar toCalendar(Value value) throws RepositoryException {
        return value.getDate();
    }

    @Converter
    public static String toString(Value value) throws RepositoryException {
        return value.getString();
    }
}

