/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.ExportHelper;
import org.apache.camel.dsl.jbang.core.commands.test.TestCommand;
import org.apache.camel.dsl.jbang.core.commands.test.TestPluginExporter;
import org.apache.camel.dsl.jbang.core.common.CamelJBangPlugin;
import org.apache.camel.dsl.jbang.core.common.Plugin;
import org.apache.camel.dsl.jbang.core.common.PluginExporter;
import org.apache.camel.util.IOHelper;
import org.citrusframework.CitrusVersion;
import org.citrusframework.jbang.JBangSettings;
import org.citrusframework.jbang.JBangSupport;
import org.citrusframework.jbang.ProcessAndOutput;
import picocli.CommandLine;

@CamelJBangPlugin(name="camel-jbang-plugin-test", firstVersion="4.14.0")
public class TestPlugin
implements Plugin {
    public void customize(CommandLine commandLine, CamelJBangMain main) {
        commandLine.setExecutionStrategy((CommandLine.IExecutionStrategy)new CitrusExecutionStrategy(main)).addSubcommand("test", (Object)new CommandLine((Object)new TestCommand(main)).setUnmatchedArgumentsAllowed(true).setUnmatchedOptionsAllowedAsOptionParameters(true));
    }

    public Optional<PluginExporter> getExporter() {
        return Optional.of(new TestPluginExporter());
    }

    private record CitrusExecutionStrategy(CamelJBangMain main) implements CommandLine.IExecutionStrategy
    {
        public static final String TEST_DIR = "test";

        public int execute(CommandLine.ParseResult parseResult) throws CommandLine.ExecutionException, CommandLine.ParameterException {
            String command;
            List<String> args = Collections.emptyList();
            if (parseResult.originalArgs().size() > 2) {
                command = (String)parseResult.originalArgs().get(1);
                args = parseResult.originalArgs().subList(2, parseResult.originalArgs().size());
            } else {
                command = parseResult.originalArgs().size() == 2 ? (String)parseResult.originalArgs().get(1) : "--help";
            }
            JBangSupport citrus = JBangSupport.jbang().app(JBangSettings.getApp()).withSystemProperty("citrus.jbang.version", CitrusVersion.version());
            if ("init".equals(command)) {
                this.prepareInitCommand(citrus);
            } else if ("run".equals(command)) {
                args = this.prepareRunCommand(citrus, args);
            }
            ProcessAndOutput pao = citrus.run(command, args);
            this.main.getOut().print(pao.getOutput());
            return pao.getProcess().exitValue();
        }

        private void prepareInitCommand(JBangSupport citrus) {
            Path workingDir;
            Path currentDir = Paths.get(".", new String[0]);
            if (TEST_DIR.equals(currentDir.getFileName().toString())) {
                workingDir = currentDir;
            } else if (currentDir.resolve(TEST_DIR).toFile().exists()) {
                workingDir = currentDir.resolve(TEST_DIR);
                citrus.workingDir(workingDir);
            } else if (currentDir.resolve(TEST_DIR).toFile().mkdirs()) {
                workingDir = currentDir.resolve(TEST_DIR);
                citrus.workingDir(workingDir);
            } else {
                throw new RuntimeCamelException("Cannot create test working directory in: " + String.valueOf(currentDir));
            }
            if (!workingDir.resolve("jbang.properties").toFile().exists()) {
                Path jbangProperties = workingDir.resolve("jbang.properties");
                try (InputStream is = TestPlugin.class.getClassLoader().getResourceAsStream("templates/jbang-properties.tmpl");){
                    String context = IOHelper.loadText((InputStream)is);
                    context = context.replaceAll("\\{\\{ \\.CitrusVersion }}", CitrusVersion.version());
                    ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(context.getBytes(StandardCharsets.UTF_8)), (Path)jbangProperties);
                }
                catch (Exception e) {
                    this.main.getOut().println("Failed to create jbang.properties for tests in:" + String.valueOf(jbangProperties));
                }
            }
        }

        private List<String> prepareRunCommand(JBangSupport citrus, List<String> args) {
            Path currentDir = Paths.get(".", new String[0]);
            if (currentDir.resolve(TEST_DIR).toFile().exists()) {
                citrus.workingDir(currentDir.resolve(TEST_DIR));
                if (!args.isEmpty() && args.get(0).startsWith("test/")) {
                    ArrayList<String> newArgs = new ArrayList<String>(args.subList(1, args.size()));
                    newArgs.add(0, args.get(0).substring("test/".length()));
                    return newArgs;
                }
            }
            return args;
        }
    }
}

