/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.test;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.ExportHelper;
import org.apache.camel.dsl.jbang.core.commands.test.TestPlugin;
import org.apache.camel.dsl.jbang.core.common.PluginExporter;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.citrusframework.CitrusSettings;
import org.citrusframework.CitrusVersion;
import org.citrusframework.util.FileUtils;

public class TestPluginExporter
implements PluginExporter {
    public static final Pattern NAME_SEPARATOR_PATTERN = Pattern.compile("[-._]([a-z])");

    public boolean isEnabled() {
        return Files.exists(Path.of(".", new String[0]).resolve("test"), new LinkOption[0]);
    }

    public Properties getBuildProperties() {
        Properties props = new Properties();
        if (this.isEnabled()) {
            props.setProperty("citrus.version", CitrusVersion.version());
        }
        return props;
    }

    public Set<String> getDependencies() {
        HashSet<String> deps = new HashSet<String>();
        if (!this.isEnabled()) {
            return deps;
        }
        deps.add(this.asDependency("citrus-base"));
        deps.add(this.asDependency("citrus-junit5"));
        deps.add(this.asDependency("citrus-http"));
        deps.add(this.asDependency("citrus-yaml"));
        deps.add(this.asDependency("citrus-xml"));
        deps.add(this.asDependency("citrus-groovy"));
        deps.add(this.asDependency("citrus-validation-xml"));
        deps.add(this.asDependency("citrus-validation-json"));
        deps.add(this.asDependency("citrus-validation-yaml"));
        Path testDir = Path.of(".", new String[0]).resolve("test");
        if (Files.exists(testDir.resolve("jbang.properties"), new LinkOption[0])) {
            try (FileInputStream fis = new FileInputStream(testDir.resolve("jbang.properties").toFile());){
                String[] dependencies;
                Properties props = new Properties();
                props.load(fis);
                for (String dependency : dependencies = props.getOrDefault((Object)"run.deps", "").toString().split(",")) {
                    if (dependency.startsWith("org.citrusframework:")) {
                        deps.add(this.asDependency(this.extractArtifactId(dependency)));
                        continue;
                    }
                    if (dependency.startsWith("org.apache.camel")) {
                        String[] parts = dependency.split(":");
                        deps.add("mvn@test:%s:%s".formatted(parts[0], parts[1]));
                        continue;
                    }
                    deps.add("mvn@test:" + dependency);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return deps;
    }

    public void addSourceFiles(Path buildDir, String packageName, Printer printer) throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        Path srcTestSrcDir = buildDir.resolve("src/test/java");
        Path srcTestResourcesDir = buildDir.resolve("src/test/resources");
        Files.createDirectories(srcTestSrcDir, new FileAttribute[0]);
        Files.createDirectories(srcTestResourcesDir, new FileAttribute[0]);
        Path testDir = Path.of(".", new String[0]).resolve("test");
        Path testProfile = testDir.resolve("application.test.properties");
        if (Files.exists(testProfile, new LinkOption[0])) {
            ExportHelper.safeCopy((Path)testProfile, (Path)srcTestResourcesDir.resolve("application.test.properties"), (boolean)true);
        }
        Set testSources = Files.list(testDir).filter(path -> !path.getFileName().toString().startsWith(".")).filter(path -> {
            String ext = FileUtils.getFileExtension((String)path.getFileName().toString());
            return CitrusSettings.getTestFileNamePattern((String)ext).stream().map(Pattern::compile).anyMatch(pattern -> pattern.matcher(path.getFileName().toString()).matches());
        }).collect(Collectors.toSet());
        for (Path testSource : testSources) {
            String ext = FileUtils.getFileExtension((String)testSource.getFileName().toString());
            if (ext.equals("java")) {
                Path javaSource = packageName != null ? srcTestSrcDir.resolve(packageName.replaceAll("\\.", "/") + "/" + String.valueOf(testSource.getFileName())) : srcTestSrcDir.resolve(testSource.getFileName());
                ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(this.readTestSource(testSource).getBytes(StandardCharsets.UTF_8)), (Path)javaSource);
                continue;
            }
            Path resource = srcTestResourcesDir.resolve(testSource.getFileName());
            ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(this.readTestSource(testSource).getBytes(StandardCharsets.UTF_8)), (Path)resource);
            String javaClassName = this.getJavaClassName(FileUtils.getBaseName((String)testSource.getFileName().toString()));
            Path javaSource = packageName != null ? srcTestSrcDir.resolve(packageName.replaceAll("\\.", "/") + "/" + javaClassName + ".java") : srcTestSrcDir.resolve(javaClassName + ".java");
            InputStream is = TestPlugin.class.getClassLoader().getResourceAsStream("templates/junit-test.tmpl");
            try {
                String context = IOHelper.loadText((InputStream)is);
                context = context.replaceAll("\\{\\{ \\.PackageDeclaration }}", this.getPackageDeclaration(packageName));
                context = context.replaceAll("\\{\\{ \\.Type }}", ext);
                context = context.replaceAll("\\{\\{ \\.Name }}", javaClassName);
                context = context.replaceAll("\\{\\{ \\.MethodName }}", StringHelper.decapitalize((String)javaClassName));
                context = context.replaceAll("\\{\\{ \\.ResourcePath }}", testSource.getFileName().toString());
                ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(context.getBytes(StandardCharsets.UTF_8)), (Path)javaSource);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private String readTestSource(Path source) throws IOException {
        String context = Files.readString(source, StandardCharsets.UTF_8);
        context = context.replaceAll("\\.\\./", "camel/");
        return context;
    }

    private String getPackageDeclaration(String packageName) {
        if (packageName == null || packageName.isEmpty()) {
            return "";
        }
        return "package %s;%n%n".formatted(packageName);
    }

    private String getJavaClassName(String resourceName) {
        Matcher matcher = NAME_SEPARATOR_PATTERN.matcher(resourceName);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (matcher.find()) {
            sb.append(resourceName, last, matcher.start());
            sb.append(matcher.group(0).toUpperCase());
            last = matcher.end();
        }
        sb.append(resourceName.substring(last));
        Object javaClassName = StringHelper.capitalize((String)sb.toString().replaceAll("\\W", ""));
        if (((String)javaClassName).endsWith("It")) {
            javaClassName = ((String)javaClassName).substring(0, ((String)javaClassName).length() - 1) + "T";
        }
        return javaClassName;
    }

    private String extractArtifactId(String dependency) {
        return dependency.split(":")[1];
    }

    private String asDependency(String artifactName) {
        return "mvn@test:org.citrusframework:%s:\\$\\{citrus.version}".formatted(artifactName);
    }
}

