/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitProfile;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Service;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;

public class ServiceTrait
extends BaseTrait {
    public static final int SERVICE_TRAIT_ORDER = 1500;
    public static final int DEFAULT_SERVICE_PORT = 80;

    public ServiceTrait() {
        super("service", 1500);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (context.getService().isPresent() || context.getKnativeService().isPresent()) {
            return false;
        }
        if (traitConfig.getService() != null && traitConfig.getService().getEnabled() != null) {
            return traitConfig.getService().getEnabled();
        }
        if (traitConfig.getContainer().getPort() != null) {
            return true;
        }
        return TraitHelper.exposesHttpService(context);
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Service serviceTrait = Optional.ofNullable(traitConfig.getService()).orElseGet(Service::new);
        String serviceType = Optional.ofNullable(serviceTrait.getType()).map(Service.Type::getValue).orElse(Service.Type.CLUSTERIP.getValue());
        Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
        ServiceBuilder service = (ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(context.getName())).endMetadata()).withNewSpec().withType(serviceType)).withSelector(Map.of("app.kubernetes.io/name", context.getName()))).addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(Optional.ofNullable(containerTrait.getServicePortName()).orElse("http"))).withPort(Optional.ofNullable(containerTrait.getServicePort()).map(Long::intValue).orElse(80))).withTargetPort(new IntOrString((Object)Optional.ofNullable(containerTrait.getPortName()).orElse("http")))).withProtocol("TCP")).build()})).endSpec();
        context.add((VisitableBuilder<?, ?>)service);
    }

    @Override
    public boolean accept(TraitProfile profile) {
        return TraitProfile.KNATIVE != profile;
    }
}

