/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesDelete;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesExport;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesPodLogs;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.FileWatcherResourceReloadStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run Camel application on Kubernetes"}, sortOptions=false)
public class KubernetesRun
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file(s) to run."}, arity="0..9", paramLabel="<files>")
    String[] filePaths;
    @CommandLine.Option(names={"--trait-profile"}, description={"The trait profile to use for the deployment."})
    String traitProfile;
    @CommandLine.Option(names={"--service-account"}, description={"The service account used to run the application."})
    String serviceAccount;
    @CommandLine.Option(names={"--property"}, description={"Add a runtime property or properties file from a path, a config map or a secret (syntax: [my-key=my-value|file:/path/to/my-conf.properties|[configmap|secret]:name])."})
    String[] properties;
    @CommandLine.Option(names={"--config"}, description={"Add a runtime configuration from a ConfigMap or a Secret (syntax: [configmap|secret]:name[/key], where name represents the configmap/secret name and key optionally represents the configmap/secret key to be filtered)."})
    String[] configs;
    @CommandLine.Option(names={"--resource"}, description={"Add a runtime resource from a Configmap or a Secret (syntax: [configmap|secret]:name[/key][@path], where name represents the configmap/secret name, key optionally represents the configmap/secret key to be filtered and path represents the destination path)."})
    String[] resources;
    @CommandLine.Option(names={"--open-api"}, description={"Add an OpenAPI spec (syntax: [configmap|file]:name)."})
    String openApi;
    @CommandLine.Option(names={"--env"}, description={"Set an environment variable in the integration container, for instance \"-e MY_VAR=my-value\"."})
    String[] envVars;
    @CommandLine.Option(names={"--volume"}, description={"Mount a volume into the integration container, for instance \"-v pvcname:/container/path\"."})
    String[] volumes;
    @CommandLine.Option(names={"--connect"}, description={"A Service that the integration should bind to, specified as [[apigroup/]version:]kind:[namespace/]name."})
    String[] connects;
    @CommandLine.Option(names={"--annotation"}, description={"Add an annotation to the integration. Use name values pairs like \"--annotation my.company=hello\"."})
    String[] annotations;
    @CommandLine.Option(names={"--label"}, description={"Add a label to the integration. Use name values pairs like \"--label my.company=hello\"."})
    String[] labels;
    @CommandLine.Option(names={"--trait"}, description={"Add a trait configuration to the integration. Use name values pairs like \"--trait trait.name.config=hello\"."})
    String[] traits;
    @CommandLine.Option(names={"--wait"}, description={"Wait for the deployment to become ready."})
    boolean wait;
    @CommandLine.Option(names={"--logs"}, description={"Print logs after Camel application has been started."})
    boolean logs;
    @CommandLine.Option(names={"--reload", "--dev"}, description={"Enables dev mode (live reload when source files are updated and saved)"})
    boolean dev;
    @CommandLine.Option(names={"--quiet"}, description={"Quiet output - only show errors for build/deploy."})
    boolean quiet;
    @CommandLine.Option(names={"--cleanup"}, defaultValue="true", description={"Automatically removes deployment when process is stopped. Only in combination with --dev, --reload option."})
    boolean cleanup = true;
    @CommandLine.Option(names={"--output"}, description={"Just output the generated integration custom resource (supports: yaml or json)."})
    String output;
    @CommandLine.Option(names={"--image"}, description={"The image name to be built."})
    String image;
    @CommandLine.Option(names={"--image-registry"}, description={"The image registry to hold the app container image."})
    String imageRegistry;
    @CommandLine.Option(names={"--image-group"}, description={"The image registry group used to push images to."})
    String imageGroup;
    @CommandLine.Option(names={"--image-builder"}, defaultValue="jib", description={"The image builder used to build the container image (e.g. docker, jib, podman)."})
    String imageBuilder;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube."})
    String clusterType = "Kubernetes";
    @CommandLine.Option(names={"--image-build"}, defaultValue="true", description={"Whether to build container image as part of the run."})
    boolean imageBuild = true;
    @CommandLine.Option(names={"--image-push"}, defaultValue="false", description={"Whether to push image to given image registry as part of the run."})
    boolean imagePush = false;
    @CommandLine.Option(names={"--image-platforms"}, description={"List of target platforms. Each platform is defined using the pattern."})
    String imagePlatforms;
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    String repositories;
    @CommandLine.Option(names={"--dep", "--dependency"}, description={"Add additional dependencies"}, split=",")
    List<String> dependencies = new ArrayList<String>();
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, defaultValue="quarkus", converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime = RuntimeType.quarkus;
    @CommandLine.Option(names={"--gav"}, description={"The Maven group:artifact:version"})
    String gav;
    @CommandLine.Option(names={"--exclude"}, description={"Exclude files by name or pattern"})
    List<String> excludes = new ArrayList<String>();
    @CommandLine.Option(names={"--maven-settings"}, description={"Optional location of Maven settings.xml file to configure servers, repositories, mirrors and proxies. If set to \"false\", not even the default ~/.m2/settings.xml will be used."})
    String mavenSettings;
    @CommandLine.Option(names={"--maven-settings-security"}, description={"Optional location of Maven settings-security.xml file to decrypt settings.xml"})
    String mavenSettingsSecurity;
    @CommandLine.Option(names={"--maven-central-enabled"}, description={"Whether downloading JARs from Maven Central repository is enabled"})
    boolean mavenCentralEnabled = true;
    @CommandLine.Option(names={"--maven-apache-snapshot-enabled"}, description={"Whether downloading JARs from ASF Maven Snapshot repository is enabled"})
    boolean mavenApacheSnapshotEnabled = true;
    @CommandLine.Option(names={"--java-version"}, description={"Java version"}, defaultValue="17")
    String javaVersion = "17";
    @CommandLine.Option(names={"--camel-version"}, description={"To export using a different Camel version than the default version."})
    String camelVersion;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    String kameletsVersion;
    @CommandLine.Option(names={"--profile"}, scope=CommandLine.ScopeType.INHERIT, description={"Profile to export (dev, test, or prod)."})
    String profile;
    @CommandLine.Option(names={"--local-kamelet-dir"}, description={"Local directory for loading Kamelets (takes precedence)"})
    String localKameletDir;
    @CommandLine.Option(names={"--spring-boot-version"}, description={"Spring Boot version"}, defaultValue="3.3.4")
    String springBootVersion = "3.3.4";
    @CommandLine.Option(names={"--camel-spring-boot-version"}, description={"Camel version to use with Spring Boot"})
    String camelSpringBootVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--quarkus-artifact-id"}, description={"Quarkus Platform Maven artifactId"}, defaultValue="quarkus-bom")
    String quarkusArtifactId = "quarkus-bom";
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.15.1")
    String quarkusVersion = "3.15.1";
    @CommandLine.Option(names={"--package-name"}, description={"For Java source files should they have the given package name. By default the package name is computed from the Maven GAV. Use false to turn off and not include package name in the Java source files."})
    String packageName;
    @CommandLine.Option(names={"--build-property"}, description={"Maven/Gradle build properties, ex. --build-property=prop1=foo"})
    List<String> buildProperties = new ArrayList<String>();
    private CamelContext devModeContext;
    private Thread devModeShutdownTask;
    private int devModeReloadCount;
    private KubernetesPodLogs reusablePodLogs;

    public KubernetesRun(CamelJBangMain main) {
        this(main, null);
    }

    public KubernetesRun(CamelJBangMain main, String[] files) {
        super(main);
        this.filePaths = files;
        this.projectNameSuppliers.add(() -> this.projectNameFromImage(() -> this.image));
        this.projectNameSuppliers.add(() -> this.projectNameFromGav(() -> this.gav));
        this.projectNameSuppliers.add(() -> this.projectNameFromFilePath(() -> this.firstFilePath()));
    }

    private String firstFilePath() {
        return this.filePaths != null && this.filePaths.length > 0 ? this.filePaths[0] : null;
    }

    public Integer doCall() throws Exception {
        String projectName = this.getProjectName();
        String workingDir = this.getIndexedWorkingDir(projectName);
        KubernetesExport export = this.configureExport(workingDir);
        int exit = export.export();
        if (exit != 0) {
            this.printer().println("Project export failed!");
            return exit;
        }
        if (this.output != null) {
            File manifest;
            exit = this.buildProject(workingDir);
            if (exit != 0) {
                this.printer().println("Project build failed!");
                return exit;
            }
            switch (this.output) {
                case "yaml": {
                    manifest = KubernetesHelper.resolveKubernetesManifest(this.clusterType, workingDir + "/target/kubernetes");
                    break;
                }
                case "json": {
                    manifest = KubernetesHelper.resolveKubernetesManifest(this.clusterType, workingDir + "/target/kubernetes", "json");
                    break;
                }
                default: {
                    this.printer().printf("Unsupported output format '%s' (supported: yaml, json)%n", new Object[]{this.output});
                    return 1;
                }
            }
            try (FileInputStream fis = new FileInputStream(manifest);){
                this.printer().println(IOHelper.loadText((InputStream)fis));
            }
            return 0;
        }
        exit = this.deployProject(workingDir, false);
        if (exit != 0) {
            this.printer().println("Project deploy failed!");
            return exit;
        }
        if (this.dev || this.wait || this.logs) {
            this.waitForRunningPod(projectName);
        }
        if (this.dev) {
            this.setupDevMode(projectName, workingDir);
        }
        if (this.dev || this.logs) {
            this.startPodLogging(projectName);
        }
        return 0;
    }

    private String getIndexedWorkingDir(String projectName) {
        String workingDir = ".camel-jbang-run/" + projectName;
        if (this.devModeReloadCount > 0) {
            workingDir = workingDir + "-%03d".formatted(this.devModeReloadCount);
        }
        return workingDir;
    }

    private KubernetesExport configureExport(String workingDir) {
        KubernetesExport.ExportConfigurer configurer = new KubernetesExport.ExportConfigurer(this.runtime, this.quarkusVersion, List.of(this.filePaths), this.name, this.gav, this.repositories, this.dependencies, this.excludes, this.mavenSettings, this.mavenSettingsSecurity, this.mavenCentralEnabled, this.mavenApacheSnapshotEnabled, this.javaVersion, this.camelVersion, this.kameletsVersion, this.profile, this.localKameletDir, this.springBootVersion, this.camelSpringBootVersion, this.quarkusGroupId, this.quarkusArtifactId, "maven", this.openApi, workingDir, this.packageName, this.buildProperties, true, false, true, true, false, true, true, false, false, "off");
        KubernetesExport export = new KubernetesExport(this.getMain(), configurer);
        export.image = this.image;
        export.imageRegistry = this.imageRegistry;
        export.imageGroup = this.imageGroup;
        export.imageBuilder = this.imageBuilder;
        export.clusterType = this.clusterType;
        export.traitProfile = this.traitProfile;
        export.serviceAccount = this.serviceAccount;
        export.properties = this.properties;
        export.configs = this.configs;
        export.resources = this.resources;
        export.envVars = this.envVars;
        export.volumes = this.volumes;
        export.connects = this.connects;
        export.annotations = this.annotations;
        export.labels = this.labels;
        export.traits = this.traits;
        return export;
    }

    private void setupDevMode(String projectName, String workingDir) throws Exception {
        String firstPath = this.firstFilePath();
        String watchDir = ".";
        FileFilter filter = null;
        if (firstPath != null) {
            String filePath = FileUtil.onlyPath((String)SourceScheme.onlyName((String)firstPath));
            if (filePath != null) {
                watchDir = filePath;
            }
            filter = pathname -> Arrays.stream(this.filePaths).map(FileUtil::stripPath).anyMatch(name -> name.equals(pathname.getName()));
        }
        FileWatcherResourceReloadStrategy reloadStrategy = new FileWatcherResourceReloadStrategy(watchDir);
        reloadStrategy.setResourceReload((name, resource) -> {
            KubernetesRun kubernetesRun = this;
            synchronized (kubernetesRun) {
                this.printer().printf("Reloading project due to file change: %s%n", new Object[]{FileUtil.stripPath((String)name)});
                String currentWorkingDir = this.getIndexedWorkingDir(projectName);
                ++this.devModeReloadCount;
                String reloadWorkingDir = this.getIndexedWorkingDir(projectName);
                this.devModeContext.close();
                KubernetesExport export = this.configureExport(reloadWorkingDir);
                int exit = export.export();
                if (exit != 0) {
                    this.printer().printf("Project reexport failed for: %s%n", new Object[]{reloadWorkingDir});
                    return;
                }
                this.reusablePodLogs.retryForReload = true;
                try {
                    KubernetesDelete deleteCommand = new KubernetesDelete(this.getMain());
                    deleteCommand.workingDir = currentWorkingDir;
                    deleteCommand.clusterType = this.clusterType;
                    deleteCommand.name = projectName;
                    deleteCommand.doCall();
                    exit = this.deployProject(reloadWorkingDir, true);
                    if (exit != 0) {
                        this.printer().printf("Project redeploy failed for: %s%n", new Object[]{reloadWorkingDir});
                        return;
                    }
                    this.waitForRunningPod(projectName);
                }
                finally {
                    this.reusablePodLogs.retryForReload = false;
                }
                Runtime.getRuntime().removeShutdownHook(this.devModeShutdownTask);
                this.setupDevMode(projectName, reloadWorkingDir);
                this.printer().printf("Project reloaded: %s%n", new Object[]{reloadWorkingDir});
            }
        });
        if (filter != null) {
            reloadStrategy.setFileFilter(filter);
        }
        this.devModeContext = new DefaultCamelContext(false);
        this.devModeContext.addService((Object)reloadStrategy);
        this.devModeContext.start();
        if (this.cleanup) {
            this.installShutdownHook(projectName, workingDir);
        }
    }

    private void startPodLogging(String projectName) throws Exception {
        try {
            this.reusablePodLogs = new KubernetesPodLogs(this.getMain());
            if (!ObjectHelper.isEmpty((String)this.namespace)) {
                this.reusablePodLogs.namespace = this.namespace;
            }
            this.reusablePodLogs.name = projectName;
            this.reusablePodLogs.doCall();
        }
        catch (Exception e) {
            this.printer().println("Failed to read pod logs - " + String.valueOf(e));
            throw e;
        }
    }

    private void waitForRunningPod(String projectName) {
        if (!this.quiet) {
            Object kubectlCmd = "kubectl get pod";
            kubectlCmd = (String)kubectlCmd + " -l %s=%s".formatted("app.kubernetes.io/name", projectName);
            if (!ObjectHelper.isEmpty((String)this.namespace)) {
                kubectlCmd = (String)kubectlCmd + " -n %s".formatted(this.namespace);
            }
            this.printer().println("Run: " + (String)kubectlCmd);
        }
        Pod pod = (Pod)((FilterWatchListDeletable)this.client(Pod.class).withLabel("app.kubernetes.io/name", projectName)).waitUntilCondition(it -> "Running".equals(KubernetesHelper.getPodPhase(it)), 10L, TimeUnit.MINUTES);
        if (!this.quiet) {
            this.printer().println(String.format("Pod '%s' in phase %s", pod.getMetadata().getName(), KubernetesHelper.getPodPhase(pod)));
        }
    }

    private void installShutdownHook(String projectName, String workingDir) {
        KubernetesDelete deleteCommand = new KubernetesDelete(this.getMain());
        deleteCommand.clusterType = this.clusterType;
        deleteCommand.workingDir = workingDir;
        deleteCommand.name = projectName;
        this.devModeShutdownTask = new Thread(() -> {
            try {
                deleteCommand.doCall();
                CommandHelper.cleanExportDir((String)deleteCommand.workingDir, (boolean)false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.devModeShutdownTask.setName(ThreadHelper.resolveThreadName(null, (String)"CamelShutdownInterceptor"));
        Runtime.getRuntime().addShutdownHook(this.devModeShutdownTask);
    }

    private Integer buildProject(String workingDir) throws IOException, InterruptedException {
        this.printer().println("Building Camel application ...");
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(workingDir + mvnw);
        if (this.quiet) {
            args.add("--quiet");
        }
        args.add("--file");
        args.add(workingDir);
        if (!ObjectHelper.isEmpty((String)this.namespace)) {
            args.add("-Djkube.namespace=%s".formatted(this.namespace));
        }
        args.add("package");
        if (!this.quiet) {
            this.printer().println("Run: " + String.join((CharSequence)" ", args));
        }
        pb.command((String[])args.toArray(String[]::new));
        pb.inheritIO();
        Process p = pb.start();
        int exit = p.waitFor();
        if (exit != 0) {
            this.printer().println("Build failed!");
            return exit;
        }
        return 0;
    }

    private Integer deployProject(String workingDir, boolean reload) throws Exception {
        boolean isOpenshift;
        this.printer().println("Deploying to %s ...".formatted(this.clusterType));
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(workingDir + mvnw);
        if (this.quiet) {
            args.add("--quiet");
        }
        args.add("--file");
        args.add(workingDir);
        if (!this.imageBuild) {
            args.add("-Djkube.skip.build=true");
        }
        if (this.imagePush) {
            args.add("-Djkube.%s.push=true".formatted(this.imageBuilder));
        }
        if (!ObjectHelper.isEmpty((String)this.namespace)) {
            args.add("-Djkube.namespace=%s".formatted(this.namespace));
        }
        String prefix = (isOpenshift = ClusterType.OPENSHIFT.isEqualTo(this.clusterType)) ? "oc" : "k8s";
        args.add(prefix + ":deploy");
        if (!this.quiet) {
            this.printer().println("Run: " + String.join((CharSequence)" ", args));
        }
        pb.command((String[])args.toArray(String[]::new));
        pb.inheritIO();
        Process p = pb.start();
        int exit = p.waitFor();
        if (exit != 0) {
            this.printer().println("Deployment to %s failed!".formatted(this.clusterType));
            return exit;
        }
        return 0;
    }
}

