/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.CatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitCatalog;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitProfile;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.SourceHelper;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export as Maven/Gradle project that contains a Kubernetes deployment manifest"}, sortOptions=false)
public class KubernetesExport
extends Export {
    @CommandLine.Option(names={"--trait-profile"}, description={"The trait profile to use for the deployment."})
    protected String traitProfile;
    @CommandLine.Option(names={"--service-account"}, description={"The service account used to run the application."})
    protected String serviceAccount;
    @CommandLine.Option(names={"--property"}, description={"Add a runtime property or properties file from a path, a config map or a secret (syntax: [my-key=my-value|file:/path/to/my-conf.properties|[configmap|secret]:name])."})
    protected String[] properties;
    @CommandLine.Option(names={"--config"}, description={"Add a runtime configuration from a ConfigMap or a Secret (syntax: [configmap|secret]:name[/key], where name represents the configmap/secret name and key optionally represents the configmap/secret key to be filtered)."})
    protected String[] configs;
    @CommandLine.Option(names={"--resource"}, description={"Add a runtime resource from a Configmap or a Secret (syntax: [configmap|secret]:name[/key][@path], where name represents the configmap/secret name, key optionally represents the configmap/secret key to be filtered and path represents the destination path)."})
    protected String[] resources;
    @CommandLine.Option(names={"--env"}, description={"Set an environment variable in the integration container, for instance \"-e MY_VAR=my-value\"."})
    protected String[] envVars;
    @CommandLine.Option(names={"--volume"}, description={"Mount a volume into the integration container, for instance \"-v pvcname:/container/path\"."})
    protected String[] volumes;
    @CommandLine.Option(names={"--connect"}, description={"A Service that the integration should bind to, specified as [[apigroup/]version:]kind:[namespace/]name."})
    protected String[] connects;
    @CommandLine.Option(names={"--annotation"}, description={"Add an annotation to the integration. Use name values pairs like \"--annotation my.company=hello\"."})
    protected String[] annotations;
    @CommandLine.Option(names={"--label"}, description={"Add a label to the integration. Use name values pairs like \"--label my.company=hello\"."})
    protected String[] labels;
    @CommandLine.Option(names={"--trait"}, description={"Add a trait configuration to the integration. Use name values pairs like \"--trait trait.name.config=hello\"."})
    protected String[] traits;
    @CommandLine.Option(names={"--image"}, description={"The image name to be built."})
    protected String image;
    @CommandLine.Option(names={"--image-registry"}, description={"The image registry to hold the app container image."})
    protected String imageRegistry;
    @CommandLine.Option(names={"--image-group"}, description={"The image registry group used to push images to."})
    protected String imageGroup;
    @CommandLine.Option(names={"--image-builder"}, defaultValue="jib", description={"The image builder used to build the container image (e.g. docker, jib, podman)."})
    protected String imageBuilder;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube."})
    protected String clusterType;
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources/";

    public KubernetesExport(CamelJBangMain main) {
        super(main);
    }

    public KubernetesExport(CamelJBangMain main, String[] files) {
        super(main);
        this.files = Arrays.asList(files);
    }

    public KubernetesExport(CamelJBangMain main, ExportConfigurer configurer) {
        super(main);
        this.runtime = configurer.runtime;
        this.quarkusVersion = configurer.quarkusVersion;
        this.files = configurer.files;
        this.name = configurer.name;
        this.gav = configurer.gav;
        this.repositories = configurer.repositories;
        this.dependencies = configurer.dependencies;
        this.excludes = configurer.excludes;
        this.mavenSettings = configurer.mavenSettings;
        this.mavenSettingsSecurity = configurer.mavenSettingsSecurity;
        this.mavenCentralEnabled = configurer.mavenCentralEnabled;
        this.mavenApacheSnapshotEnabled = configurer.mavenApacheSnapshotEnabled;
        this.javaVersion = configurer.javaVersion;
        this.camelVersion = configurer.camelVersion;
        this.kameletsVersion = configurer.kameletsVersion;
        this.profile = configurer.profile;
        this.localKameletDir = configurer.localKameletDir;
        this.springBootVersion = configurer.springBootVersion;
        this.camelSpringBootVersion = configurer.camelSpringBootVersion;
        this.quarkusGroupId = configurer.quarkusGroupId;
        this.quarkusArtifactId = configurer.quarkusArtifactId;
        this.buildTool = configurer.buildTool;
        this.openapi = configurer.openapi;
        this.exportDir = configurer.exportDir;
        this.packageName = configurer.packageName;
        this.buildProperties = configurer.buildProperties;
        this.symbolicLink = configurer.symbolicLink;
        this.javaLiveReload = configurer.javaLiveReload;
        this.ignoreLoadingError = configurer.ignoreLoadingError;
        this.mavenWrapper = configurer.mavenWrapper;
        this.gradleWrapper = configurer.gradleWrapper;
        this.fresh = configurer.fresh;
        this.download = configurer.download;
        this.quiet = configurer.quiet;
        this.logging = configurer.logging;
        this.loggingLevel = configurer.loggingLevel;
    }

    public Integer export() throws Exception {
        boolean skipPush;
        List sources;
        if (this.runtime == null) {
            this.runtime = RuntimeType.quarkus;
        }
        if (!this.quiet) {
            this.printer().println("Exporting application ...");
        }
        if (!this.buildTool.equals("maven")) {
            this.printer().printf("--build-tool=%s is not yet supported%n", new Object[]{this.buildTool});
        }
        String propPrefix = this.runtime == RuntimeType.springBoot ? "camel.springboot" : (this.runtime == RuntimeType.main ? "camel.main" : this.runtime.runtime());
        String resolvedImageGroup = this.resolveImageGroup();
        String resolvedImageRegistry = this.resolveImageRegistry();
        if (resolvedImageRegistry != null) {
            this.buildProperties.add("jkube.container-image.registry=%s".formatted(resolvedImageRegistry));
        }
        String projectName = this.getProjectName();
        CamelCatalog catalog = CatalogHelper.loadCatalog(this.runtime, this.runtime.version());
        try {
            sources = SourceHelper.resolveSources((List)this.files);
        }
        catch (Exception e) {
            if (!this.quiet) {
                this.printer().printf("Project export failed: %s - %s%n", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("unknown reason")});
            }
            return 1;
        }
        TraitContext context = new TraitContext(projectName, this.getVersion(), this.printer(), catalog, sources);
        this.annotations = Optional.ofNullable(this.annotations).orElse(new String[0]);
        context.addAnnotations(Arrays.stream(this.annotations).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        this.addLabel("app.kubernetes.io/runtime", "camel");
        context.addLabels(Arrays.stream(this.labels).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        if (this.traitProfile != null) {
            context.setProfile(TraitProfile.valueOf(this.traitProfile.toUpperCase()));
        }
        if (this.serviceAccount != null) {
            context.setServiceAccount(this.serviceAccount);
        }
        String[] applicationProperties = this.extractPropertiesTraits(new File("application.properties"));
        String[] applicationProfileProperties = null;
        if (this.profile != null) {
            applicationProfileProperties = this.extractPropertiesTraits(new File("application-" + this.profile + ".properties"));
        }
        Traits traitsSpec = this.getTraitSpec(applicationProperties, applicationProfileProperties);
        TraitHelper.configureMountTrait(traitsSpec, this.configs, this.resources, this.volumes);
        if (this.openapi != null && this.openapi.startsWith("configmap:")) {
            TraitHelper.configureOpenApiSpec(traitsSpec, this.openapi);
            this.openapi = null;
        }
        TraitHelper.configureProperties(traitsSpec, this.properties);
        TraitHelper.configureContainerImage(traitsSpec, this.image, resolvedImageRegistry, resolvedImageGroup, projectName, this.getVersion());
        TraitHelper.configureEnvVars(traitsSpec, this.envVars);
        TraitHelper.configureConnects(traitsSpec, this.connects);
        Container container = traitsSpec.getContainer();
        this.buildProperties.add("jkube.container-image.name=%s".formatted(container.getImage()));
        if (container.getName() != null && !container.getName().equals(projectName)) {
            this.buildProperties.add("%s.kubernetes.container-name=%s".formatted(propPrefix, container.getName()));
        }
        if (container.getImagePullPolicy() != null) {
            String imagePullPolicy = container.getImagePullPolicy().getValue();
            this.buildProperties.add("jkube.container-image.imagePullPolicy=%s".formatted(imagePullPolicy));
        }
        boolean bl = skipPush = !container.getImagePush();
        if (ClusterType.OPENSHIFT.isEqualTo(this.clusterType)) {
            if (!"docker".equals(this.imageBuilder)) {
                this.printer().printf("OpenShift forcing --image-builder=docker%n", new Object[0]);
                this.imageBuilder = "docker";
            }
            if (skipPush) {
                this.printer().printf("OpenShift forcing --trait container.image-push=true%n", new Object[0]);
                container.setImagePush(true);
            }
            this.buildProperties.add("jkube.maven.plugin=%s".formatted("openshift-maven-plugin"));
        } else {
            this.buildProperties.add("jkube.maven.plugin=%s".formatted("kubernetes-maven-plugin"));
        }
        if ("docker".equals(this.imageBuilder) || "jib".equals(this.imageBuilder)) {
            this.buildProperties.add("jkube.build.strategy=%s".formatted(this.imageBuilder));
        }
        this.buildProperties.add("jkube.skip.push=%b".formatted(skipPush));
        if (this.runtime == RuntimeType.main) {
            this.addDependencies(new String[]{"org.apache.camel:camel-health", "org.apache.camel:camel-platform-http-main"});
        }
        File settings = new File(CommandLineHelper.getWorkDir(), "camel-jbang-run.properties");
        String jkubeVersion = KubernetesExport.jkubeMavenPluginVersion((File)settings, (Properties)this.mapBuildProperties());
        this.buildProperties.add("jkube.version=%s".formatted(jkubeVersion));
        int exit = super.export();
        if (exit != 0) {
            if (!this.quiet) {
                this.printer().println("Project export failed");
            }
            return exit;
        }
        if (!this.quiet) {
            this.printer().println("Building Kubernetes manifest ...");
        }
        new TraitCatalog().apply(traitsSpec, context, this.traitProfile, this.runtime);
        List<Map> kubeFragments = context.buildItems().stream().map(KubernetesHelper::toJsonMap).toList();
        for (Map map : kubeFragments) {
            String ymlFragment = KubernetesHelper.dumpYaml(map);
            String kind = map.get("kind").toString().toLowerCase();
            this.safeCopy(new ByteArrayInputStream(ymlFragment.getBytes(StandardCharsets.UTF_8)), new File(this.exportDir + "/src/main/jkube/%s.yml".formatted(kind)));
        }
        context.doWithConfigurationResources((fileName, content) -> {
            block4: {
                try {
                    File target = new File(this.exportDir + SRC_MAIN_RESOURCES + fileName);
                    if (target.exists()) {
                        Files.writeString(target.toPath(), (CharSequence)"%n%s".formatted(content), StandardOpenOption.APPEND);
                    } else {
                        this.safeCopy(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), target);
                    }
                }
                catch (Exception e) {
                    if (this.quiet) break block4;
                    this.printer().printf("Failed to create configuration resource %s - %s%n", new Object[]{this.exportDir + SRC_MAIN_RESOURCES + fileName, e.getMessage()});
                }
            }
        });
        if (!this.quiet) {
            this.printer().println("Project export successful!");
        }
        return 0;
    }

    protected Integer export(ExportBaseCommand cmd) throws Exception {
        if (this.runtime == RuntimeType.quarkus) {
            cmd.pomTemplateName = "quarkus-kubernetes-pom.tmpl";
        }
        if (this.runtime == RuntimeType.springBoot) {
            cmd.pomTemplateName = "spring-boot-kubernetes-pom.tmpl";
        }
        if (this.runtime == RuntimeType.main) {
            cmd.pomTemplateName = "main-kubernetes-pom.tmpl";
        }
        return super.export(cmd);
    }

    protected Traits getTraitSpec(String[] applicationProperties, String[] applicationProfileProperties) {
        String[] annotationsTraits = TraitHelper.extractTraitsFromAnnotations(this.annotations);
        String[] allTraits = TraitHelper.mergeTraits(this.traits, annotationsTraits, applicationProfileProperties, applicationProperties);
        Traits traitsSpec = allTraits.length > 0 ? TraitHelper.parseTraits(allTraits) : new Traits();
        return traitsSpec;
    }

    private void addLabel(String key, String value) {
        String[] labelArray = Optional.ofNullable(this.labels).orElse(new String[0]);
        ArrayList<String> labelList = new ArrayList<String>(Arrays.asList(labelArray));
        String labelEntry = "%s=%s".formatted(key, value);
        if (!labelList.contains(labelEntry)) {
            labelList.add(labelEntry);
            this.labels = labelList.toArray(new String[0]);
        }
    }

    private String resolveImageGroup() {
        if (this.image != null) {
            return this.extractImageGroup(this.image);
        }
        if (this.imageGroup != null) {
            return this.imageGroup;
        }
        if (this.gav != null) {
            String groupId = KubernetesExport.parseMavenGav((String)this.gav).getGroupId();
            String[] dotToks = groupId.split("\\.");
            return dotToks[dotToks.length - 1];
        }
        return null;
    }

    private String resolveImageRegistry() {
        if (this.image != null) {
            return this.extractImageRegistry(this.image);
        }
        if (this.imageRegistry != null) {
            if (this.imageRegistry.equals("kind") || this.imageRegistry.equals("kind-registry")) {
                return "localhost:5001";
            }
            if (this.imageRegistry.equals("minikube") || this.imageRegistry.equals("minikube-registry")) {
                return "localhost:5000";
            }
            return this.imageRegistry;
        }
        if (ClusterType.KIND.isEqualTo(this.clusterType)) {
            return "localhost:5001";
        }
        if (ClusterType.MINIKUBE.isEqualTo(this.clusterType)) {
            return "localhost:5000";
        }
        return null;
    }

    private String extractImageGroup(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[1];
        }
        if (parts.length > 1) {
            return parts[0];
        }
        return this.imageGroup;
    }

    private String extractImageRegistry(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[0];
        }
        return this.imageRegistry;
    }

    protected String[] extractPropertiesTraits(File file) throws Exception {
        if (file.exists()) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, (File)file);
            return TraitHelper.extractTraitsFromProperties((Properties)prop);
        }
        return null;
    }

    protected String getProjectName() {
        if (this.name != null) {
            return KubernetesHelper.sanitize(this.name);
        }
        if (this.image != null) {
            return KubernetesHelper.sanitize(StringHelper.beforeLast((String)this.image, (String)":"));
        }
        return KubernetesHelper.sanitize(super.getProjectName());
    }

    protected String getVersion() {
        if (this.image != null) {
            return StringHelper.afterLast((String)this.image, (String)":");
        }
        return super.getVersion();
    }

    public record ExportConfigurer(RuntimeType runtime, String quarkusVersion, List<String> files, String name, String gav, String repositories, List<String> dependencies, List<String> excludes, String mavenSettings, String mavenSettingsSecurity, boolean mavenCentralEnabled, boolean mavenApacheSnapshotEnabled, String javaVersion, String camelVersion, String kameletsVersion, String profile, String localKameletDir, String springBootVersion, String camelSpringBootVersion, String quarkusGroupId, String quarkusArtifactId, String buildTool, String openapi, String exportDir, String packageName, List<String> buildProperties, boolean symbolicLink, boolean javaLiveReload, boolean ignoreLoadingError, boolean mavenWrapper, boolean gradleWrapper, boolean fresh, boolean download, boolean quiet, boolean logging, String loggingLevel) {
    }
}

