/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.eventing.v1.TriggerFilterBuilder;
import io.fabric8.knative.eventing.v1.TriggerFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.knative.messaging.v1.SubscriptionBuilder;
import io.fabric8.knative.messaging.v1.SubscriptionFluent;
import io.fabric8.knative.sources.v1.SinkBindingBuilder;
import io.fabric8.knative.sources.v1.SinkBindingFluent;
import io.fabric8.knative.sources.v1.SinkBindingSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.SourceMetadata;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative.KnativeBaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Camel;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Knative;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class KnativeTrait
extends KnativeBaseTrait {
    private static final Pattern knativeUriPattern = Pattern.compile("^knative:/*(channel|endpoint|event)(?:[?].*|$|/([A-Za-z0-9.-]+)(?:[/?].*|$))");
    private static final Pattern plainNamePattern = Pattern.compile("^[A-Za-z0-9.-]+$");
    private static final String K_SINK_URL = "{{k.sink:http://localhost:8080}}";
    private final List<Map<String, Object>> knativeResourcesConfig = new ArrayList<Map<String, Object>>();

    public KnativeTrait() {
        super("knative", 1600);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        boolean hasKnativeEndpoint;
        Knative knativeTrait = Optional.ofNullable(traitConfig.getKnative()).orElseGet(Knative::new);
        if (knativeTrait.getEnabled() != null && !knativeTrait.getEnabled().booleanValue()) {
            return false;
        }
        List<SourceMetadata> allSourcesMetadata = context.getSourceMetadata();
        if (knativeTrait.getChannelSources() == null) {
            knativeTrait.setChannelSources(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.CHANNEL, "from"));
        }
        if (knativeTrait.getChannelSinks() == null) {
            knativeTrait.setChannelSinks(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.CHANNEL, "to"));
        }
        if (knativeTrait.getEndpointSources() == null) {
            knativeTrait.setEndpointSources(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.ENDPOINT, "from"));
        }
        if (knativeTrait.getEndpointSinks() == null) {
            knativeTrait.setEndpointSinks(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.ENDPOINT, "to"));
        }
        if (knativeTrait.getEventSources() == null) {
            knativeTrait.setEventSources(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.EVENT, "from"));
        }
        if (knativeTrait.getEventSinks() == null) {
            knativeTrait.setEventSinks(KnativeTrait.extractKnativeEndpointUris(allSourcesMetadata, KnativeResourceType.EVENT, "to"));
        }
        boolean bl = hasKnativeEndpoint = !knativeTrait.getChannelSources().isEmpty() || !knativeTrait.getChannelSinks().isEmpty() || !knativeTrait.getEndpointSources().isEmpty() || !knativeTrait.getEndpointSinks().isEmpty() || !knativeTrait.getEventSources().isEmpty() || !knativeTrait.getEventSinks().isEmpty();
        if (knativeTrait.getSinkBinding() == null) {
            knativeTrait.setSinkBinding(KnativeTrait.shouldCreateSinkBinding(knativeTrait));
        }
        knativeTrait.setEnabled(hasKnativeEndpoint);
        traitConfig.setKnative(knativeTrait);
        return hasKnativeEndpoint;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Knative knativeTrait = Optional.ofNullable(traitConfig.getKnative()).orElseGet(Knative::new);
        this.configureChannels(knativeTrait, context);
        this.configureEndpoints(knativeTrait, context);
        this.configureEvents(knativeTrait, context);
        if (knativeTrait.getSinkBinding() != null && knativeTrait.getSinkBinding().booleanValue()) {
            this.createSinkBinding(knativeTrait, context);
        }
        if (!this.knativeResourcesConfig.isEmpty()) {
            try {
                context.addConfigurationResource("knative.json", KubernetesHelper.json().writerWithDefaultPrettyPrinter().writeValueAsString(Collections.singletonMap("resources", this.knativeResourcesConfig)));
                Camel camelTrait = Optional.ofNullable(traitConfig.getCamel()).orElseGet(Camel::new);
                if (camelTrait.getProperties() == null) {
                    camelTrait.setProperties(new ArrayList<String>());
                }
                camelTrait.getProperties().add("camel.component.knative.environmentPath=classpath:knative.json");
                traitConfig.setCamel(camelTrait);
            }
            catch (JsonProcessingException e) {
                context.printer().printf("Failed to write knative.json environment configuration - %s%n", new Object[]{e.getMessage()});
            }
        }
    }

    private void configureChannels(Knative knativeTrait, TraitContext context) {
        for (String uri : knativeTrait.getChannelSources()) {
            this.createSubscription(KnativeTrait.toKnativeUri(KnativeResourceType.CHANNEL, uri), knativeTrait, context);
        }
        for (String uri : knativeTrait.getChannelSinks()) {
            String channelName = KnativeTrait.extractKnativeResource(uri);
            this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(channelName, KnativeResourceType.CHANNEL, "sink", K_SINK_URL, null, channelName, null));
        }
    }

    private void configureEndpoints(Knative knativeTrait, TraitContext context) {
        String endpointName;
        for (String uri : knativeTrait.getEndpointSources()) {
            endpointName = KnativeTrait.extractKnativeResource(uri);
            this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(endpointName, KnativeResourceType.ENDPOINT, "source", null, "/", endpointName, null));
        }
        for (String uri : knativeTrait.getEndpointSinks()) {
            endpointName = KnativeTrait.extractKnativeResource(uri);
            this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(endpointName, KnativeResourceType.ENDPOINT, "sink", K_SINK_URL, null, endpointName, null));
        }
    }

    private void configureEvents(Knative knativeTrait, TraitContext context) {
        for (String uri : knativeTrait.getEventSources()) {
            this.createTrigger(KnativeTrait.toKnativeUri(KnativeResourceType.EVENT, uri), knativeTrait, context);
        }
        for (String uri : knativeTrait.getEventSinks()) {
            String eventType = KnativeTrait.extractKnativeResource(uri);
            String brokerName = KnativeTrait.extractBrokerName(uri);
            String serviceName = ObjectHelper.isNotEmpty((String)eventType) ? brokerName : "default";
            this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(serviceName, KnativeResourceType.EVENT, "sink", K_SINK_URL, null, brokerName, null));
        }
    }

    private void createSubscription(String uri, Knative knativeTrait, TraitContext context) {
        String channelName = KnativeTrait.extractKnativeResource(uri);
        String subscriptionName = KnativeTrait.createSubscriptionName(context.getName(), channelName);
        if (ObjectHelper.isEmpty((String)channelName) || context.getKnativeSubscription(subscriptionName).isPresent()) {
            return;
        }
        String servicePath = "/channels/%s".formatted(channelName);
        SubscriptionBuilder subscription = (SubscriptionBuilder)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionBuilder)((SubscriptionFluent.MetadataNested)new SubscriptionBuilder().withNewMetadata().withName(subscriptionName)).endMetadata()).withNewSpec().withChannel(((KReferenceBuilder)((KReferenceBuilder)((KReferenceBuilder)new KReferenceBuilder().withApiVersion(KnativeResourceType.CHANNEL.getApiVersion())).withKind(KnativeResourceType.CHANNEL.getKind())).withName(channelName)).build())).withSubscriber(((DestinationBuilder)((DestinationBuilder)new DestinationBuilder().withRef(KnativeTrait.getSubscriberRef(context))).withUri(servicePath)).build())).endSpec();
        context.add((VisitableBuilder<?, ?>)subscription);
        this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(channelName, KnativeResourceType.CHANNEL, "source", null, servicePath, channelName, null));
    }

    private void createTrigger(String uri, Knative knativeTrait, TraitContext context) {
        String eventType = KnativeTrait.extractKnativeResource(uri);
        String brokerName = KnativeTrait.extractBrokerName(uri);
        String triggerName = KnativeTrait.createTriggerName(context.getName(), brokerName, eventType);
        if (context.getKnativeTrigger(triggerName, brokerName).isPresent()) {
            return;
        }
        String servicePath = "/events/%s".formatted(eventType);
        TriggerBuilder trigger = (TriggerBuilder)((TriggerFluent.SpecNested)((TriggerFluent.SpecNested)((TriggerFluent.SpecNested)((TriggerBuilder)((TriggerFluent.MetadataNested)new TriggerBuilder().withNewMetadata().withName(triggerName)).endMetadata()).withNewSpec().withBroker(brokerName)).withSubscriber(((DestinationBuilder)((DestinationBuilder)new DestinationBuilder().withRef(KnativeTrait.getSubscriberRef(context))).withUri(servicePath)).build())).withFilter(((TriggerFilterBuilder)new TriggerFilterBuilder().addToAttributes(this.getFilterAttributes(knativeTrait, eventType))).build())).endSpec();
        context.add((VisitableBuilder<?, ?>)trigger);
        String serviceName = ObjectHelper.isNotEmpty((String)eventType) ? eventType : "default";
        this.addKnativeResourceConfiguration(new KnativeResourceConfiguration(serviceName, KnativeResourceType.EVENT, "source", null, servicePath, brokerName, null));
    }

    private Map<String, String> getFilterAttributes(Knative knativeTrait, String eventType) {
        HashMap<String, String> filterAttributes = new HashMap<String, String>();
        filterAttributes.put("type", eventType);
        return filterAttributes;
    }

    private void addKnativeResourceConfiguration(KnativeResourceConfiguration configuration) {
        this.knativeResourcesConfig.add(configuration.toJsonMap());
    }

    private static KReference getSubscriberRef(TraitContext context) {
        if (context.getKnativeService().isPresent()) {
            return ((KReferenceBuilder)((KReferenceBuilder)((KReferenceBuilder)new KReferenceBuilder().withApiVersion(KnativeResourceType.ENDPOINT.getApiVersion())).withKind(KnativeResourceType.ENDPOINT.getKind())).withName(context.getName())).build();
        }
        return ((KReferenceBuilder)((KReferenceBuilder)((KReferenceBuilder)new KReferenceBuilder().withApiVersion("v1")).withKind("Service")).withName(context.getName())).build();
    }

    private static String createTriggerName(String subscriberName, String brokerName, String eventType) {
        String nameSuffix = "";
        if (ObjectHelper.isNotEmpty((String)eventType)) {
            nameSuffix = "-%s".formatted(KubernetesHelper.sanitize(eventType));
        }
        return KubernetesHelper.sanitize(brokerName) + "-" + subscriberName + nameSuffix;
    }

    private void createSinkBinding(Knative knativeTrait, TraitContext context) {
        String resourceName;
        KnativeResourceType resourceType;
        if (!knativeTrait.getChannelSinks().isEmpty()) {
            String uri = knativeTrait.getChannelSinks().get(0);
            resourceType = KnativeResourceType.CHANNEL;
            resourceName = KnativeTrait.extractKnativeResource(uri);
        } else if (!knativeTrait.getEndpointSinks().isEmpty()) {
            String uri = knativeTrait.getEndpointSinks().get(0);
            resourceType = KnativeResourceType.ENDPOINT;
            resourceName = KnativeTrait.extractKnativeResource(uri);
        } else if (!knativeTrait.getEventSinks().isEmpty()) {
            String uri = knativeTrait.getEventSinks().get(0);
            resourceType = KnativeResourceType.EVENT;
            resourceName = KnativeTrait.extractBrokerName(uri);
        } else {
            context.printer().println("Failed to create sink binding!");
            return;
        }
        context.add((VisitableBuilder)((SinkBindingFluent.SpecNested)((SinkBindingSpecFluent.SinkNested)((SinkBindingFluent.SpecNested)((SinkBindingBuilder)((SinkBindingFluent.MetadataNested)((SinkBindingFluent.MetadataNested)new SinkBindingBuilder().withNewMetadata().withName(context.getName())).withFinalizers(new String[]{"sinkbindings.sources.knative.dev"})).endMetadata()).withNewSpec().withSubject(((ReferenceBuilder)((ReferenceBuilder)((ReferenceBuilder)new ReferenceBuilder().withApiVersion("apps/v1")).withKind("Deployment")).withName(context.getName())).build())).withNewSink().withRef(resourceType.getReference(resourceName))).endSink()).endSpec());
    }

    private static String createSubscriptionName(String subscriberName, String channelName) {
        return "%s-%s".formatted(channelName, subscriberName);
    }

    private static String extractBrokerName(String uri) {
        try {
            return URISupport.parseQuery((String)URISupport.extractQuery((String)uri)).getOrDefault("name", "default").toString();
        }
        catch (Exception e) {
            return "default";
        }
    }

    private static boolean shouldCreateSinkBinding(Knative knativeTrait) {
        return knativeTrait.getChannelSinks().size() + knativeTrait.getEndpointSinks().size() + knativeTrait.getEventSinks().size() == 1;
    }

    private static List<String> extractKnativeEndpointUris(List<SourceMetadata> metadata, KnativeResourceType resourceType, String endpointType) {
        return metadata.stream().flatMap(m -> endpointType.equals("from") ? m.endpoints.from.stream() : m.endpoints.to.stream()).filter(uri -> KnativeTrait.isKnativeUri(resourceType, uri)).collect(Collectors.toList());
    }

    private static String extractKnativeResource(String uri) {
        Matcher uriMatch = knativeUriPattern.matcher(uri);
        if (uriMatch.matches()) {
            return Optional.ofNullable(uriMatch.group(2)).orElse("");
        }
        return "";
    }

    private static boolean isKnativeUri(KnativeResourceType resourceType, String uri) {
        Matcher uriMatcher = knativeUriPattern.matcher(uri);
        return uriMatcher.matches() && uriMatcher.group(1).equals(resourceType.getType());
    }

    private static String toKnativeUri(KnativeResourceType resourceType, String uriOrName) {
        if (plainNamePattern.matcher(uriOrName).matches()) {
            return "knative://%s/%s".formatted(resourceType.getType(), uriOrName);
        }
        return uriOrName;
    }

    static enum KnativeResourceType {
        CHANNEL("Channel", "messaging.knative.dev/v1"),
        ENDPOINT("Service", "serving.knative.dev/v1"),
        EVENT("Broker", "eventing.knative.dev/v1");

        private final String kind;
        private final String apiVersion;

        private KnativeResourceType(String kind, String apiVersion) {
            this.kind = kind;
            this.apiVersion = apiVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String getType() {
            return this.name().toLowerCase(Locale.US);
        }

        public KReference getReference(String resourceName) {
            return ((KReferenceBuilder)((KReferenceBuilder)((KReferenceBuilder)new KReferenceBuilder().withApiVersion(this.apiVersion)).withKind(this.kind)).withName(resourceName)).build();
        }
    }

    private record KnativeResourceConfiguration(String name, KnativeResourceType resourceType, String endpointKind, String url, String path, String objectName, Map<String, String> ceOverrides) {
        public Map<String, Object> toJsonMap() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("name", this.name);
            json.put("type", this.resourceType.getType());
            json.put("endpointKind", this.endpointKind);
            if (ObjectHelper.isNotEmpty((String)this.url)) {
                json.put("url", this.url);
            }
            if (ObjectHelper.isNotEmpty((String)this.path)) {
                json.put("path", this.path);
            }
            json.put("objectApiVersion", this.resourceType.getApiVersion());
            json.put("objectKind", this.resourceType.getKind());
            json.put("objectName", this.objectName);
            if (ObjectHelper.isNotEmpty(this.ceOverrides)) {
                json.put("ceOverrides", this.ceOverrides);
            }
            if (this.resourceType == KnativeResourceType.ENDPOINT && this.endpointKind.equals("source")) {
                json.put("reply", true);
            } else {
                json.put("reply", false);
            }
            return json;
        }
    }
}

