/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.MetadataHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.SourceMetadata;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Addons;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.AddonsBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Camel;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Environment;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Mount;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Openapi;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.ServiceBinding;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.common.Source;
import org.apache.camel.util.StringHelper;

public final class TraitHelper {
    private TraitHelper() {
    }

    public static Traits parseTraits(String[] traits) {
        if (traits == null || traits.length == 0) {
            return new Traits();
        }
        HashMap<String, Map<String, List>> traitConfigMap = new HashMap<String, Map<String, List>>();
        for (String traitExpression : traits) {
            Map<String, List> config;
            String[] trait = traitExpression.split("\\.", 2);
            String[] traitConfig = trait[1].split("=", 2);
            String traitKey = StringHelper.dashToCamelCase((String)traitConfig[0]);
            Object traitValue = TraitHelper.resolveTraitValue(traitKey, traitConfig[1].trim());
            if (traitConfigMap.containsKey(trait[0])) {
                config = (Map)traitConfigMap.get(trait[0]);
                if (config.containsKey(traitKey)) {
                    String[] traitValueConfig;
                    Object traitValueList;
                    Object values;
                    Object existingValue = config.get(traitKey);
                    if (existingValue instanceof List) {
                        values = (List)existingValue;
                        if (traitValue instanceof List) {
                            traitValueList = (List)traitValue;
                            values.addAll(traitValueList);
                            continue;
                        }
                        values.add(traitValue.toString());
                        continue;
                    }
                    if (existingValue instanceof Map) {
                        values = (Map)existingValue;
                        if (traitValue instanceof Map) {
                            traitValueList = (Map)traitValue;
                            values.putAll(traitValueList);
                            continue;
                        }
                        traitValueConfig = traitValue.toString().split("=", 2);
                        values.put(traitValueConfig[0], traitValueConfig[1]);
                        continue;
                    }
                    if (traitValue instanceof List) {
                        List traitValueList2 = (List)traitValue;
                        traitValueList2.add(0, existingValue.toString());
                        config.put(traitKey, traitValueList2);
                        continue;
                    }
                    if (traitValue instanceof Map) {
                        Map traitValueMap = (Map)traitValue;
                        String[] existingValueConfig = existingValue.toString().split("=", 2);
                        traitValueMap.put(existingValueConfig[0], existingValueConfig[1]);
                        config.put(traitKey, (List)((Object)traitValueMap));
                        continue;
                    }
                    if (traitKey.endsWith("annotations")) {
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        traitValueConfig = traitValue.toString().split("=", 2);
                        String[] existingValueConfig = existingValue.toString().split("=", 2);
                        map.put(traitValueConfig[0], traitValueConfig[1]);
                        map.put(existingValueConfig[0], existingValueConfig[1]);
                        config.put(traitKey, (List)((Object)map));
                        continue;
                    }
                    config.put(traitKey, Arrays.asList(existingValue.toString(), traitValue));
                    continue;
                }
                config.put(traitKey, (List)traitValue);
                continue;
            }
            config = new HashMap<String, Object>();
            config.put(traitKey, (List)traitValue);
            traitConfigMap.put(trait[0], config);
        }
        Traits traitModel = (Traits)KubernetesHelper.json().convertValue(traitConfigMap, Traits.class);
        Set knownTraits = ((Map)KubernetesHelper.json().convertValue((Object)traitModel, Map.class)).keySet();
        if (knownTraits.size() < traitConfigMap.size()) {
            traitModel.setAddons(new HashMap<String, Addons>());
            for (Map.Entry traitConfig : traitConfigMap.entrySet()) {
                if (knownTraits.contains(traitConfig.getKey())) continue;
                traitModel.getAddons().put((String)traitConfig.getKey(), new AddonsBuilder().withAdditionalProperties((Map)traitConfig.getValue()).build());
            }
        }
        return traitModel;
    }

    private static Object resolveTraitValue(String traitKey, String value) {
        if (traitKey.equalsIgnoreCase("enabled") || traitKey.equalsIgnoreCase("verbose")) {
            return Boolean.valueOf(value);
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            String valueArrayExpression = value.substring(1, value.length() - 1);
            ArrayList<String> values = new ArrayList<String>();
            if (valueArrayExpression.contains(",")) {
                values.addAll(List.of(valueArrayExpression.split(",")));
            } else {
                values.add(valueArrayExpression);
            }
            return values;
        }
        if (value.contains(",")) {
            ArrayList<String> values = new ArrayList<String>();
            for (String entry : value.split(",")) {
                values.add(TraitHelper.resolveTraitValue("", entry).toString());
            }
            return values;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static void configureConnects(Traits traitsSpec, String[] connects) {
        if (connects == null || connects.length == 0) {
            return;
        }
        ServiceBinding serviceBindingTrait = Optional.ofNullable(traitsSpec.getServiceBinding()).orElseGet(ServiceBinding::new);
        if (serviceBindingTrait.getServices() == null) {
            serviceBindingTrait.setServices(new ArrayList<String>());
        }
        serviceBindingTrait.getServices().addAll(List.of(connects));
        traitsSpec.setServiceBinding(serviceBindingTrait);
    }

    public static void configureEnvVars(Traits traitsSpec, String[] envVars) {
        if (envVars == null || envVars.length == 0) {
            return;
        }
        Environment environmentTrait = Optional.ofNullable(traitsSpec.getEnvironment()).orElseGet(Environment::new);
        if (environmentTrait.getVars() == null) {
            environmentTrait.setVars(new ArrayList<String>());
        }
        environmentTrait.getVars().addAll(List.of(envVars));
        traitsSpec.setEnvironment(environmentTrait);
    }

    public static void configureProperties(Traits traitsSpec, String[] properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        Camel camelTrait = Optional.ofNullable(traitsSpec.getCamel()).orElseGet(Camel::new);
        if (camelTrait.getProperties() == null) {
            camelTrait.setProperties(new ArrayList<String>());
        }
        camelTrait.getProperties().addAll(List.of(properties));
        traitsSpec.setCamel(camelTrait);
    }

    public static void configureOpenApiSpec(Traits traitsSpec, String openApi) {
        if (openApi == null || !openApi.startsWith("configmap:")) {
            return;
        }
        Openapi openapiTrait = Optional.ofNullable(traitsSpec.getOpenapi()).orElseGet(Openapi::new);
        if (openapiTrait.getConfigmaps() == null) {
            openapiTrait.setConfigmaps(new ArrayList<String>());
        }
        openapiTrait.getConfigmaps().add(openApi);
        traitsSpec.setOpenapi(openapiTrait);
    }

    public static void configureMountTrait(Traits traitsSpec, String[] configs, String[] resources, String[] volumes) {
        if (configs == null && resources == null && volumes == null) {
            return;
        }
        Mount mountTrait = Optional.ofNullable(traitsSpec.getMount()).orElseGet(Mount::new);
        if (configs != null && configs.length > 0) {
            if (mountTrait.getConfigs() == null) {
                mountTrait.setConfigs(new ArrayList<String>());
            }
            mountTrait.getConfigs().addAll(List.of(configs));
        }
        if (resources != null && resources.length > 0) {
            if (mountTrait.getResources() == null) {
                mountTrait.setResources(new ArrayList<String>());
            }
            mountTrait.getResources().addAll(List.of(resources));
        }
        if (volumes != null && volumes.length > 0) {
            if (mountTrait.getVolumes() == null) {
                mountTrait.setVolumes(new ArrayList<String>());
            }
            mountTrait.getVolumes().addAll(List.of(volumes));
        }
        traitsSpec.setMount(mountTrait);
    }

    public static void configureContainerImage(Traits traitsSpec, String image, String imageRegistry, String imageGroup, String imageName, String version) {
        Container containerTrait = Optional.ofNullable(traitsSpec.getContainer()).orElseGet(Container::new);
        if (image != null) {
            containerTrait.setImage(image);
            traitsSpec.setContainer(containerTrait);
        } else if (containerTrait.getImage() == null) {
            Object registryPrefix = "";
            if ("minikube".equals(imageRegistry) || "minikube-registry".equals(imageRegistry)) {
                registryPrefix = "localhost:5000/";
            } else if ("kind".equals(imageRegistry) || "kind-registry".equals(imageRegistry)) {
                registryPrefix = "localhost:5001/";
            } else if (imageRegistry != null && !imageRegistry.isEmpty()) {
                registryPrefix = imageRegistry + "/";
            }
            String resolvedImageName = TraitHelper.getResolvedImageName(imageGroup, imageName, version);
            containerTrait.setImage("%s%s".formatted(registryPrefix, resolvedImageName));
            if (containerTrait.getPort() == null) {
                containerTrait.setPortName("http");
                containerTrait.setPort(8080L);
            }
            traitsSpec.setContainer(containerTrait);
        }
    }

    public static String getResolvedImageName(String imageGroup, String imageName, String version) {
        if (!(imageGroup = Optional.ofNullable(imageGroup).orElse("")).isEmpty()) {
            return "%s/%s:%s".formatted(imageGroup, imageName, version);
        }
        return "%s:%s".formatted(imageName, version);
    }

    public static boolean exposesHttpService(TraitContext context) {
        try {
            boolean exposesHttpServices = false;
            CamelCatalog catalog = context.getCatalog();
            if (context.getSources() != null) {
                for (Source source : context.getSources()) {
                    SourceMetadata metadata = context.inspectMetaData(source);
                    if (!MetadataHelper.exposesHttpServices(catalog, metadata)) continue;
                    exposesHttpServices = true;
                    break;
                }
            }
            return exposesHttpServices;
        }
        catch (Exception e) {
            context.printer().printf("Failed to apply service trait %s%n", new Object[]{e.getMessage()});
            return false;
        }
    }

    public static String[] extractTraitsFromProperties(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            Stream<String> propertyTraits = properties.entrySet().stream().filter(property -> property.getKey().toString().startsWith("camel.jbang.trait")).map(property -> StringHelper.after((String)property.getKey().toString(), (String)"camel.jbang.trait.") + "=" + properties.get(property.getKey()).toString());
            return (String[])propertyTraits.collect(Collectors.toSet()).toArray(String[]::new);
        }
        return new String[0];
    }

    public static String[] extractTraitsFromAnnotations(String[] annotations) {
        if (annotations != null && annotations.length > 0) {
            Stream<String> annotationTraits = Stream.of(annotations).filter(annotation -> annotation.startsWith("trait.camel.apache.org/")).map(annotation -> StringHelper.after((String)annotation, (String)"trait.camel.apache.org/"));
            return (String[])annotationTraits.collect(Collectors.toSet()).toArray(String[]::new);
        }
        return new String[0];
    }

    public static String[] mergeTraits(String[] ... traitsBySource) {
        if (traitsBySource == null || traitsBySource.length == 0) {
            return new String[0];
        }
        HashSet<String> existingKeys = new HashSet<String>();
        ArrayList<String> mergedTraits = new ArrayList<String>();
        for (String[] traits : traitsBySource) {
            if (traits == null || traits.length <= 0) continue;
            for (String trait : traits) {
                String[] traitConfig = trait.split("=", 2);
                if (existingKeys.contains(traitConfig[0])) continue;
                mergedTraits.add(trait);
            }
            existingKeys.clear();
            for (String trait : mergedTraits) {
                String[] traitConfig = trait.split("=", 2);
                existingKeys.add(traitConfig[0]);
            }
        }
        return mergedTraits.toArray(new String[0]);
    }
}

