/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Route;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public class RouteTrait
extends BaseTrait {
    public static final int RouteTrait = 2200;

    public RouteTrait() {
        super("route", 2200);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (context.getRoute().isPresent()) {
            return false;
        }
        if (traitConfig.getRoute() == null || !Optional.ofNullable(traitConfig.getRoute().getEnabled()).orElse(false).booleanValue()) {
            return false;
        }
        return context.getService().isPresent();
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Route routeTrait = Optional.ofNullable(traitConfig.getRoute()).orElseGet(Route::new);
        Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
        RouteBuilder routeBuilder = new RouteBuilder();
        ((RouteFluent.MetadataNested)routeBuilder.withNewMetadata().withName(context.getName())).endMetadata();
        if (routeTrait.getAnnotations() != null) {
            ((RouteFluent.MetadataNested)routeBuilder.editMetadata().withAnnotations(routeTrait.getAnnotations())).endMetadata();
        }
        IntOrString servicePortName = ((IntOrStringBuilder)new IntOrStringBuilder().withValue((Object)Optional.ofNullable(containerTrait.getServicePortName()).orElse("http"))).build();
        ((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)routeBuilder.withNewSpec().withNewPort().withTargetPort(servicePortName)).endPort()).withNewTo().withKind("Service")).withName(context.getName())).endTo()).endSpec();
        if (routeTrait.getHost() != null) {
            ((RouteFluent.SpecNested)routeBuilder.editSpec().withHost(routeTrait.getHost())).endSpec();
        }
        TLSConfigBuilder tlsConfigBuilder = new TLSConfigBuilder();
        if (routeTrait.getTlsTermination() != null) {
            tlsConfigBuilder.withTermination(routeTrait.getTlsTermination().getValue());
        }
        if (routeTrait.getTlsCertificate() != null) {
            tlsConfigBuilder.withCertificate(this.getContent(routeTrait.getTlsCertificate()));
        }
        if (routeTrait.getTlsKey() != null) {
            tlsConfigBuilder.withKey(this.getContent(routeTrait.getTlsKey()));
        }
        if (routeTrait.getTlsCACertificate() != null) {
            tlsConfigBuilder.withCaCertificate(this.getContent(routeTrait.getTlsCACertificate()));
        }
        if (routeTrait.getTlsDestinationCACertificate() != null) {
            tlsConfigBuilder.withDestinationCACertificate(this.getContent(routeTrait.getTlsDestinationCACertificate()));
        }
        if (routeTrait.getTlsInsecureEdgeTerminationPolicy() != null) {
            tlsConfigBuilder.withInsecureEdgeTerminationPolicy(routeTrait.getTlsInsecureEdgeTerminationPolicy().getValue());
        }
        ((RouteFluent.SpecNested)routeBuilder.editSpec().withTls(tlsConfigBuilder.build())).endSpec();
        context.add((VisitableBuilder<?, ?>)routeBuilder);
    }

    @Override
    public void applyRuntimeSpecificProperties(Traits traitConfig, TraitContext context, RuntimeType runtimeType) {
        ArrayList<String> routeProperties = new ArrayList<String>();
        if (runtimeType == RuntimeType.quarkus) {
            Route routeTrait = Optional.ofNullable(traitConfig.getRoute()).orElseGet(Route::new);
            Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
            routeProperties.add("quarkus.openshift.route.expose=true");
            if (routeTrait.getAnnotations() != null) {
                routeTrait.getAnnotations().forEach((name, value) -> routeProperties.add("quarkus.openshift.route.annotations.\"%s\"=%s".formatted(name, value)));
            }
            if (routeTrait.getHost() != null) {
                routeProperties.add("quarkus.openshift.route.host=%s".formatted(routeTrait.getHost()));
            }
            routeProperties.add("quarkus.openshift.route.target-port=%s".formatted(Optional.ofNullable(containerTrait.getServicePortName()).orElse("http")));
            if (routeTrait.getTlsTermination() != null) {
                routeProperties.add("quarkus.openshift.route.tls.termination=%s".formatted(routeTrait.getTlsTermination().getValue()));
            }
            if (routeTrait.getTlsCertificate() != null) {
                routeProperties.add("quarkus.openshift.route.tls.certificate=%s".formatted(this.getContent(routeTrait.getTlsCertificate()).replaceAll("\n", "\\\\n")));
            }
            if (routeTrait.getTlsKey() != null) {
                routeProperties.add("quarkus.openshift.route.tls.key=%s".formatted(this.getContent(routeTrait.getTlsKey()).replaceAll("\n", "\\\\n")));
            }
            if (routeTrait.getTlsCACertificate() != null) {
                routeProperties.add("quarkus.openshift.route.tls.ca-certificate=%s".formatted(this.getContent(routeTrait.getTlsCACertificate()).replaceAll("\n", "\\\\n")));
            }
            if (routeTrait.getTlsDestinationCACertificate() != null) {
                routeProperties.add("quarkus.openshift.route.tls.destination-ca-certificate=%s".formatted(this.getContent(routeTrait.getTlsDestinationCACertificate()).replaceAll("\n", "\\\\n")));
            }
            if (routeTrait.getTlsInsecureEdgeTerminationPolicy() != null) {
                routeProperties.add("quarkus.openshift.route.tls.insecure-edge-termination-policy=%s".formatted(new Object[]{routeTrait.getTlsInsecureEdgeTerminationPolicy()}));
            }
        }
        context.addOrAppendConfigurationResource("application.properties", routeProperties.stream().collect(Collectors.joining(System.lineSeparator())));
    }

    public boolean accept(ClusterType clusterType) {
        return ClusterType.OPENSHIFT == clusterType;
    }

    private String getContent(String value) {
        if (value.startsWith("file:")) {
            String string;
            String filePath = StringHelper.after((String)value, (String)":");
            File file = new File(filePath);
            if (!file.exists()) {
                throw new RuntimeException(filePath + " does not exist");
            }
            if (file.isDirectory()) {
                throw new RuntimeException(filePath + " is not a file");
            }
            FileInputStream is = new FileInputStream(file);
            try {
                string = IOHelper.loadText((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)is).close();
            return string;
        }
        return value;
    }
}

