/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Route;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public class RouteTrait
extends BaseTrait {
    public static final int RouteTrait = 2200;

    public RouteTrait() {
        super("route", 2200);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (context.getRoute().isPresent()) {
            return false;
        }
        if (traitConfig.getRoute() == null || !Optional.ofNullable(traitConfig.getRoute().getEnabled()).orElse(false).booleanValue()) {
            return false;
        }
        return context.getService().isPresent();
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Route routeTrait = Optional.ofNullable(traitConfig.getRoute()).orElseGet(Route::new);
        Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
        RouteBuilder routeBuilder = new RouteBuilder();
        ((RouteFluent.MetadataNested)routeBuilder.withNewMetadata().withName(context.getName())).endMetadata();
        if (routeTrait.getAnnotations() != null) {
            ((RouteFluent.MetadataNested)routeBuilder.editMetadata().withAnnotations(routeTrait.getAnnotations())).endMetadata();
        }
        IntOrString servicePortName = ((IntOrStringBuilder)new IntOrStringBuilder().withValue((Object)Optional.ofNullable(containerTrait.getServicePortName()).orElse("http"))).build();
        ((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)routeBuilder.withNewSpec().withNewPort().withTargetPort(servicePortName)).endPort()).withNewTo().withKind("Service")).withName(context.getName())).endTo()).endSpec();
        if (routeTrait.getHost() != null) {
            ((RouteFluent.SpecNested)routeBuilder.editSpec().withHost(routeTrait.getHost())).endSpec();
        }
        TLSConfigBuilder tlsConfigBuilder = new TLSConfigBuilder();
        if (routeTrait.getTlsTermination() != null) {
            tlsConfigBuilder.withTermination(routeTrait.getTlsTermination().getValue());
        }
        if (routeTrait.getTlsCertificate() != null) {
            tlsConfigBuilder.withCertificate(this.getContent(routeTrait.getTlsCertificate()));
        }
        if (routeTrait.getTlsKey() != null) {
            tlsConfigBuilder.withKey(this.getContent(routeTrait.getTlsKey()));
        }
        if (routeTrait.getTlsCACertificate() != null) {
            tlsConfigBuilder.withCaCertificate(this.getContent(routeTrait.getTlsCACertificate()));
        }
        if (routeTrait.getTlsDestinationCACertificate() != null) {
            tlsConfigBuilder.withDestinationCACertificate(this.getContent(routeTrait.getTlsDestinationCACertificate()));
        }
        if (routeTrait.getTlsInsecureEdgeTerminationPolicy() != null) {
            tlsConfigBuilder.withInsecureEdgeTerminationPolicy(routeTrait.getTlsInsecureEdgeTerminationPolicy().getValue());
        }
        ((RouteFluent.SpecNested)routeBuilder.editSpec().withTls(tlsConfigBuilder.build())).endSpec();
        context.add((VisitableBuilder<?, ?>)routeBuilder);
    }

    @Override
    public boolean accept(ClusterType clusterType) {
        return ClusterType.OPENSHIFT == clusterType;
    }

    private String getContent(String value) {
        if (value.startsWith("file:")) {
            String string;
            block11: {
                String filePath = StringHelper.after((String)value, (String)":");
                Path path = Paths.get(filePath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new RuntimeException(filePath + " does not exist");
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    throw new RuntimeException(filePath + " is not a file");
                }
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    string = IOHelper.loadText((InputStream)is);
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                is.close();
            }
            return string;
        }
        return value;
    }
}

