/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Mount;

public final class MountBuilder {
    private List<String> configs;
    private List<String> emptyDirs;
    private Boolean enabled;
    private Boolean hotReload;
    private List<String> resources;
    private Boolean scanKameletsImplicitLabelSecrets;
    private List<String> volumes;

    private MountBuilder() {
    }

    public static MountBuilder mount() {
        return new MountBuilder();
    }

    public MountBuilder withConfigs(List<String> configs) {
        this.configs = configs;
        return this;
    }

    public MountBuilder withEmptyDirs(List<String> emptyDirs) {
        this.emptyDirs = emptyDirs;
        return this;
    }

    public MountBuilder withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MountBuilder withHotReload(Boolean hotReload) {
        this.hotReload = hotReload;
        return this;
    }

    public MountBuilder withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public MountBuilder withScanKameletsImplicitLabelSecrets(Boolean scanKameletsImplicitLabelSecrets) {
        this.scanKameletsImplicitLabelSecrets = scanKameletsImplicitLabelSecrets;
        return this;
    }

    public MountBuilder withVolumes(List<String> volumes) {
        this.volumes = volumes;
        return this;
    }

    public Mount build() {
        Mount mount = new Mount();
        mount.setConfigs(this.configs);
        mount.setEmptyDirs(this.emptyDirs);
        mount.setEnabled(this.enabled);
        mount.setHotReload(this.hotReload);
        mount.setResources(this.resources);
        mount.setScanKameletsImplicitLabelSecrets(this.scanKameletsImplicitLabelSecrets);
        mount.setVolumes(this.volumes);
        return mount;
    }
}

