/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.knative.serving.v1.RevisionSpecFluent;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecFluent;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import io.fabric8.knative.serving.v1.ServiceFluent;
import io.fabric8.knative.serving.v1.ServiceSpecFluent;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Jolokia;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;

public class JolokiaTrait
extends BaseTrait {
    public static final int JolokiaTrait = 1800;
    public static final int DEFAULT_JOLOKIA_PORT = 8778;
    public static final String DEFAULT_JOLOKIA_PORT_NAME = "jolokia";
    public static final String DEFAULT_JOLOKIA_PORT_PROTOCOL = "TCP";

    public JolokiaTrait() {
        super(DEFAULT_JOLOKIA_PORT_NAME, 1800);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (traitConfig.getJolokia() == null) {
            return false;
        }
        return Optional.ofNullable(traitConfig.getJolokia().getEnabled()).orElse(false);
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Jolokia jolokiaTrait = Optional.ofNullable(traitConfig.getJolokia()).orElseGet(Jolokia::new);
        context.doWithDeployments((Visitor<DeploymentBuilder>)((Visitor)d -> ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)d.editSpec().editTemplate().editSpec().editFirstContainer().addNewPort().withName(Optional.ofNullable(jolokiaTrait.getContainerPortName()).orElse(DEFAULT_JOLOKIA_PORT_NAME))).withContainerPort(Optional.ofNullable(jolokiaTrait.getContainerPort()).map(Long::intValue).orElse(8778))).withProtocol(DEFAULT_JOLOKIA_PORT_PROTOCOL)).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()));
        context.doWithKnativeServices((Visitor<ServiceBuilder>)((Visitor)s -> ((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)((RevisionSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)s.editSpec().editTemplate().editSpec().editFirstContainer().addNewPort().withName(Optional.ofNullable(jolokiaTrait.getContainerPortName()).orElse(DEFAULT_JOLOKIA_PORT_NAME))).withContainerPort(Optional.ofNullable(jolokiaTrait.getContainerPort()).map(Long::intValue).orElse(8778))).withProtocol(DEFAULT_JOLOKIA_PORT_PROTOCOL)).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()));
        if (Boolean.TRUE.equals(jolokiaTrait.getExpose())) {
            context.doWithServices((Visitor<io.fabric8.kubernetes.api.model.ServiceBuilder>)((Visitor)s -> ((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)s.editSpec().addNewPort().withName(Optional.ofNullable(jolokiaTrait.getServicePortName()).orElse(DEFAULT_JOLOKIA_PORT_NAME))).withPort(Optional.ofNullable(jolokiaTrait.getServicePort()).map(Long::intValue).orElse(8778))).withTargetPort(new IntOrString((Object)Optional.ofNullable(jolokiaTrait.getContainerPortName()).orElse(DEFAULT_JOLOKIA_PORT_NAME)))).endPort()).endSpec()));
        }
    }
}

