/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.messaging.v1.SubscriptionBuilder;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.CatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.MetadataHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.SourceMetadata;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.Source;

public class TraitContext {
    private final List<VisitableBuilder<?, ?>> resourceRegistry = new ArrayList();
    private ClusterType clusterType = ClusterType.KUBERNETES;
    private final Map<String, String> configurationResources = new HashMap<String, String>();
    private final Map<String, SourceMetadata> sourceMetadata = new HashMap<String, SourceMetadata>();
    private final Map<String, String> annotations = new HashMap<String, String>();
    private final Map<String, String> labels = new HashMap<String, String>();
    private final String name;
    private final String version;
    private String serviceAccount;
    private CamelCatalog catalog;
    private final Printer printer;
    private final List<Source> sources;

    public TraitContext(String name, String version, Printer printer, Source ... sources) {
        this(name, version, printer, (CamelCatalog)null, sources);
    }

    public TraitContext(String name, String version, Printer printer, List<Source> sources) {
        this(name, version, printer, null, sources);
    }

    public TraitContext(String name, String version, Printer printer, CamelCatalog catalog, Source ... sources) {
        this(name, version, printer, catalog, Arrays.asList(sources));
    }

    public TraitContext(String name, String version, Printer printer, CamelCatalog catalog, List<Source> sources) {
        this.name = name;
        this.version = version;
        this.printer = printer;
        this.catalog = catalog;
        this.sources = sources;
    }

    public void add(VisitableBuilder<?, ?> resource) {
        this.resourceRegistry.add(resource);
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    public void doWithServices(Visitor<io.fabric8.kubernetes.api.model.ServiceBuilder> visitor) {
        this.resourceRegistry.forEach(r -> r.accept(io.fabric8.kubernetes.api.model.ServiceBuilder.class, visitor));
    }

    public void doWithKnativeServices(Visitor<ServiceBuilder> visitor) {
        this.resourceRegistry.forEach(r -> r.accept(ServiceBuilder.class, visitor));
    }

    public void doWithDeployments(Visitor<DeploymentBuilder> visitor) {
        this.resourceRegistry.forEach(r -> r.accept(DeploymentBuilder.class, visitor));
    }

    public void doWithCronJobs(Visitor<CronJobBuilder> visitor) {
        this.resourceRegistry.forEach(r -> r.accept(CronJobBuilder.class, visitor));
    }

    public Optional<DeploymentBuilder> getDeployment() {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(DeploymentBuilder.class)).map(it -> (DeploymentBuilder)it).findFirst();
    }

    public Optional<io.fabric8.kubernetes.api.model.ServiceBuilder> getService() {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(io.fabric8.kubernetes.api.model.ServiceBuilder.class)).map(it -> (io.fabric8.kubernetes.api.model.ServiceBuilder)it).findFirst();
    }

    public Optional<IngressBuilder> getIngress() {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(IngressBuilder.class)).map(it -> (IngressBuilder)it).findFirst();
    }

    public Optional<RouteBuilder> getRoute() {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(RouteBuilder.class)).map(it -> (RouteBuilder)it).findFirst();
    }

    public Optional<ServiceBuilder> getKnativeService() {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(ServiceBuilder.class)).map(it -> (ServiceBuilder)it).findFirst();
    }

    public Optional<TriggerBuilder> getKnativeTrigger(String triggerName, String brokerName) {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(TriggerBuilder.class)).map(it -> (TriggerBuilder)it).filter(trigger -> triggerName.equals(trigger.buildMetadata().getName())).filter(trigger -> brokerName.equals(trigger.buildSpec().getBroker())).findFirst();
    }

    public Optional<SubscriptionBuilder> getKnativeSubscription(String name) {
        return this.resourceRegistry.stream().filter(it -> it.getClass().isAssignableFrom(SubscriptionBuilder.class)).map(it -> (SubscriptionBuilder)it).filter(subscription -> name.equals(subscription.buildMetadata().getName())).findFirst();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<KubernetesResource> buildItems() {
        return this.resourceRegistry.stream().map(Builder::build).map(it -> (KubernetesResource)it).collect(Collectors.toList());
    }

    public void addLabel(String name, String value) {
        this.labels.put(name, value);
    }

    public void addLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void addAnnotations(Map<String, String> annotations) {
        this.annotations.putAll(annotations);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public CamelCatalog getCatalog(boolean download) {
        if (this.catalog == null) {
            try {
                this.catalog = CatalogHelper.loadCatalog(RuntimeType.quarkus, "3.24.1", download);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Failed to create default Quarkus Camel catalog", (Throwable)e);
            }
        }
        return this.catalog;
    }

    public Printer printer() {
        return this.printer;
    }

    public Source[] getSources() {
        return (Source[])this.sources.toArray(Source[]::new);
    }

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public SourceMetadata inspectMetaData(Source source) throws Exception {
        if (this.sourceMetadata.containsKey(source.name())) {
            return this.sourceMetadata.get(source.name());
        }
        SourceMetadata metadata = MetadataHelper.readFromSource(this.catalog, source);
        this.sourceMetadata.put(source.name(), metadata);
        return metadata;
    }

    public List<SourceMetadata> getSourceMetadata() {
        ArrayList<SourceMetadata> answer = new ArrayList<SourceMetadata>();
        if (this.sources != null) {
            for (Source source : this.sources) {
                answer.add(this.sourceMetadata.computeIfAbsent(source.name(), name -> {
                    try {
                        return MetadataHelper.readFromSource(this.catalog, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException((Throwable)e);
                    }
                }));
            }
        }
        return answer;
    }

    public void addConfigurationResource(String name, String content) {
        this.configurationResources.put(name, content);
    }

    public void addOrAppendConfigurationResource(String name, String content) {
        this.configurationResources.merge(name, content, (content1, content2) -> content1 + System.lineSeparator() + content2);
    }

    public void doWithConfigurationResources(BiConsumer<String, String> consumer) {
        this.configurationResources.forEach(consumer);
    }
}

