/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.KnativeService;

public final class KnativeServiceBuilder {
    private Map<String, String> annotations;
    private Boolean auto;
    private String autoscalingMetric;
    private Long autoscalingTarget;
    private KnativeService.Class _class;
    private Boolean enabled;
    private Long maxScale;
    private Long minScale;
    private String rolloutDuration;
    private Long timeoutSeconds;
    private KnativeService.Visibility visibility;

    private KnativeServiceBuilder() {
    }

    public static KnativeServiceBuilder knativeService() {
        return new KnativeServiceBuilder();
    }

    public KnativeServiceBuilder withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public KnativeServiceBuilder withAuto(Boolean auto) {
        this.auto = auto;
        return this;
    }

    public KnativeServiceBuilder withAutoscalingMetric(String autoscalingMetric) {
        this.autoscalingMetric = autoscalingMetric;
        return this;
    }

    public KnativeServiceBuilder withAutoscalingTarget(Long autoscalingTarget) {
        this.autoscalingTarget = autoscalingTarget;
        return this;
    }

    public KnativeServiceBuilder with_class(KnativeService.Class _class) {
        this._class = _class;
        return this;
    }

    public KnativeServiceBuilder withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public KnativeServiceBuilder withMaxScale(Long maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    public KnativeServiceBuilder withMinScale(Long minScale) {
        this.minScale = minScale;
        return this;
    }

    public KnativeServiceBuilder withRolloutDuration(String rolloutDuration) {
        this.rolloutDuration = rolloutDuration;
        return this;
    }

    public KnativeServiceBuilder withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public KnativeServiceBuilder withVisibility(KnativeService.Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public KnativeService build() {
        KnativeService knativeService = new KnativeService();
        knativeService.setAnnotations(this.annotations);
        knativeService.setAuto(this.auto);
        knativeService.setAutoscalingMetric(this.autoscalingMetric);
        knativeService.setAutoscalingTarget(this.autoscalingTarget);
        knativeService.set_class(this._class);
        knativeService.setEnabled(this.enabled);
        knativeService.setMaxScale(this.maxScale);
        knativeService.setMinScale(this.minScale);
        knativeService.setRolloutDuration(this.rolloutDuration);
        knativeService.setTimeoutSeconds(this.timeoutSeconds);
        knativeService.setVisibility(this.visibility);
        return knativeService;
    }
}

