/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.AnnotationTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.CamelTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.ContainerTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.DeploymentTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.EnvTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.IngressTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.LabelTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.MountTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.OpenApiTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.RouteTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.ServiceTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.Trait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative.KnativeServiceTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative.KnativeTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;

public class TraitCatalog {
    private final List<Trait> traits = new ArrayList<Trait>();

    public TraitCatalog() {
        this.register(new DeploymentTrait());
        this.register(new KnativeTrait());
        this.register(new KnativeServiceTrait());
        this.register(new ServiceTrait());
        this.register(new RouteTrait());
        this.register(new IngressTrait());
        this.register(new ContainerTrait());
        this.register(new EnvTrait());
        this.register(new MountTrait());
        this.register(new OpenApiTrait());
        this.register(new LabelTrait());
        this.register(new AnnotationTrait());
        this.register(new CamelTrait());
    }

    public List<Trait> allTraits() {
        return this.traits.stream().sorted().collect(Collectors.toList());
    }

    public List<Trait> traitsForProfile(ClusterType clusterType) {
        return this.traits.stream().filter(t -> t.accept(clusterType)).sorted().collect(Collectors.toList());
    }

    public void register(Trait trait) {
        this.traits.add(trait);
    }

    public void apply(Traits traitsSpec, TraitContext context, String clusterType, RuntimeType runtimeType) {
        if (clusterType != null) {
            new TraitCatalog().traitsForProfile(ClusterType.valueOf(clusterType.toUpperCase(Locale.US))).forEach(t -> {
                if (t.configure(traitsSpec, context)) {
                    t.apply(traitsSpec, context);
                    t.applyRuntimeSpecificProperties(traitsSpec, context, runtimeType);
                }
            });
        } else {
            new TraitCatalog().allTraits().forEach(t -> {
                if (t.configure(traitsSpec, context)) {
                    t.apply(traitsSpec, context);
                    t.applyRuntimeSpecificProperties(traitsSpec, context, runtimeType);
                }
            });
        }
    }
}

