/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.util.StringHelper;
import org.codehaus.plexus.util.ExceptionUtils;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete Camel application from Kubernetes. This operation will delete all resources associated to this app, such as: Deployment, Routes, Services, etc. filtering by label \"app.kubernetes.io/name=<name>\"."}, sortOptions=false)
public class KubernetesDelete
extends KubernetesBaseCommand {
    public KubernetesDelete(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        this.namespace = Optional.ofNullable(this.namespace).orElse(KubernetesHelper.getKubernetesClient().getNamespace());
        this.namespace = Optional.ofNullable(this.namespace).orElse("default");
        this.printer().printf("Deleting resources in namespace '%s' with name: %s%n", new Object[]{this.namespace, this.name});
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app.kubernetes.io/name", this.name);
        ArrayList deleteStatuses = new ArrayList();
        try {
            deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().apps().deployments().inNamespace(this.namespace)).withLabels(labels)).delete());
            deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().services().inNamespace(this.namespace)).withLabels(labels)).delete());
            deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().configMaps().inNamespace(this.namespace)).withLabels(labels)).delete());
            deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().secrets().inNamespace(this.namespace)).withLabels(labels)).delete());
            FilterWatchListDeletable knativeServices = (FilterWatchListDeletable)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().genericKubernetesResources(new ResourceDefinitionContext.Builder().withGroup("serving.knative.dev").withVersion("v1").withKind("Service").withNamespaced(true).build()).inNamespace(this.namespace)).withLabels(labels);
            try {
                deleteStatuses.addAll(knativeServices.delete());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClusterType clusterType = KubernetesHelper.discoverClusterType();
            if (ClusterType.OPENSHIFT == clusterType) {
                OpenShiftClient ocpClient = (OpenShiftClient)KubernetesHelper.getKubernetesClient().adapt(OpenShiftClient.class);
                deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)ocpClient.buildConfigs().inNamespace(this.namespace)).withLabels(labels)).delete());
                deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)ocpClient.imageStreams().inNamespace(this.namespace)).withLabels(labels)).delete());
                deleteStatuses.addAll(((FilterWatchListDeletable)((NonNamespaceOperation)ocpClient.routes().inNamespace(this.namespace)).withLabels(labels)).delete());
            }
            if (!deleteStatuses.isEmpty()) {
                deleteStatuses.forEach(s -> this.printer().printf("Deleted: %s/%s '%s'%n", new Object[]{s.getGroup(), StringHelper.capitalize((String)s.getKind()), s.getName()}));
            } else {
                this.printer().println("No deployment found with name: " + this.name);
            }
        }
        catch (Exception ex) {
            this.printer().println("Error trying to delete the app: " + String.valueOf(ExceptionUtils.getRootCause((Throwable)ex)));
            return 1;
        }
        return 0;
    }
}

