/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.util.ObjectHelper;
import picocli.CommandLine;

@CommandLine.Command(name="logs", description={"Print the logs of a Kubernetes pod"}, sortOptions=false)
public class KubernetesPodLogs
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file to get logs from. Integration name is derived from the file name."}, arity="0..1", paramLabel="<file>")
    protected String filePath;
    @CommandLine.Option(names={"--label"}, description={"Label name and value used as a pod selector."})
    protected String label;
    @CommandLine.Option(names={"--container"}, description={"Name identifying the pod container to grab the logs from."})
    protected String container;
    @CommandLine.Option(names={"--tail"}, defaultValue="-1", description={"The number of lines from the end of the logs to show. Defaults to -1 to show all the lines."})
    int tail = -1;
    int maxRetryAttempts = 30;
    boolean retryForReload;
    private int retryCount;
    long maxMessageCount = -1L;
    long messageCount = 0L;

    public KubernetesPodLogs(CamelJBangMain main) {
        super(main);
        this.projectNameSuppliers.add(() -> this.projectNameFromFilePath(() -> this.filePath));
    }

    public Integer doCall() throws Exception {
        String[] parts;
        if (this.label == null) {
            String projectName = this.getProjectName();
            this.label = "%s=%s".formatted("app.kubernetes.io/name", projectName);
        }
        if ((parts = this.label.split("=", 2)).length != 2) {
            this.printer().println("--label selector must be in syntax: key=value");
        }
        boolean retry = this.watchLogs();
        while ((retry || this.retryForReload) && ++this.retryCount < this.maxRetryAttempts) {
            this.sleepWell();
            this.printer().printf("Retry %d/%d Pod log for label %s%n", new Object[]{this.retryCount, this.maxRetryAttempts, this.label});
            retry = this.watchLogs();
        }
        this.printer().println("Stopped pod logging!");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean watchLogs() {
        PodResource podRes = ((FilterWatchListDeletable)this.pods().withLabel(this.label)).resources().findFirst().orElse(null);
        if (podRes == null) {
            this.printer().printf("Pod for label %s not available%n", new Object[]{this.label});
            return true;
        }
        boolean terminated = this.isPodTerminated(podRes);
        if (!terminated) {
            LogWatch logs = this.tail < 0 ? (!ObjectHelper.isEmpty((String)this.container) ? ((ContainerResource)podRes.inContainer((Object)this.container)).watchLog() : podRes.watchLog()) : (!ObjectHelper.isEmpty((String)this.container) ? ((ContainerResource)podRes.inContainer((Object)this.container)).tailingLines(this.tail).watchLog() : podRes.tailingLines(this.tail).watchLog());
            try (LogWatch logWatch = logs;
                 BufferedReader reader = new BufferedReader(new InputStreamReader(logs.getOutput()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.printer().println(line);
                    if (this.maxMessageCount > 0L && ++this.messageCount > this.maxMessageCount) {
                        boolean bl = false;
                        return bl;
                    }
                    this.retryCount = 0;
                }
            }
            catch (IOException e) {
                this.printer().println("Failed to read pod logs - " + e.getMessage());
            }
            terminated = this.isPodTerminated(podRes);
        }
        if (terminated) return false;
        return true;
    }

    private boolean isPodTerminated(PodResource podRes) {
        String phase = Optional.ofNullable(podRes).map(pr -> KubernetesHelper.getPodPhase((Pod)pr.get())).orElse("Unknown");
        return "Terminated".equals(phase);
    }

    private void sleepWell() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.printer().printf("Interrupted while waiting for pod - %s%n", new Object[]{e.getMessage()});
        }
    }
}

