/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

public abstract class KubernetesBaseCommand
extends CamelCommand {
    static final String RUN_PLATFORM_DIR = ".camel-jbang-run";
    @CommandLine.Option(names={"--kube-config"}, description={"Path to the kube config file to initialize Kubernetes client"})
    String kubeConfig;
    @CommandLine.Option(names={"--namespace", "-n"}, description={"Namespace to use for all operations"})
    String namespace;
    @CommandLine.Option(names={"--name"}, description={"The integration name. Use this when the name should not get derived otherwise."})
    String name;
    List<Supplier<String>> projectNameSuppliers = new ArrayList<Supplier<String>>();
    private KubernetesClient kubernetesClient;

    public KubernetesBaseCommand(CamelJBangMain main) {
        super(main);
        this.projectNameSuppliers.add(() -> this.name);
    }

    protected String getProjectName() {
        return this.projectNameSuppliers.stream().map(Supplier::get).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeCamelException("Failed to resolve project name"));
    }

    protected String projectNameFromImage(Supplier<String> imageSupplier) {
        return KubernetesHelper.sanitize(StringHelper.beforeLast((String)imageSupplier.get(), (String)":"));
    }

    protected String projectNameFromGav(Supplier<String> gavSupplier) {
        String[] ids;
        String gav = gavSupplier.get();
        if (gav != null && (ids = gav.split(":")).length > 1) {
            return KubernetesHelper.sanitize(ids[1]);
        }
        return null;
    }

    protected String projectNameFromFilePath(Supplier<String> pathSupplier) {
        String filePath = pathSupplier.get();
        if (filePath != null) {
            return KubernetesHelper.sanitize(FileUtil.onlyName((String)SourceScheme.onlyName((String)filePath)));
        }
        return null;
    }

    protected <T extends HasMetadata> NonNamespaceOperation<T, KubernetesResourceList<T>, Resource<T>> client(Class<T> resourceType) {
        if (!ObjectHelper.isEmpty((String)this.namespace)) {
            return (NonNamespaceOperation)this.client().resources(resourceType).inNamespace(this.namespace);
        }
        return this.client().resources(resourceType);
    }

    protected NonNamespaceOperation<Pod, PodList, PodResource> pods() {
        if (!ObjectHelper.isEmpty((String)this.namespace)) {
            return (NonNamespaceOperation)this.client().pods().inNamespace(this.namespace);
        }
        return this.client().pods();
    }

    protected KubernetesClient client() {
        if (this.kubernetesClient == null) {
            this.kubernetesClient = this.kubeConfig != null ? KubernetesHelper.getKubernetesClient(this.kubeConfig) : KubernetesHelper.getKubernetesClient();
        }
        return this.kubernetesClient;
    }

    public KubernetesBaseCommand withClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        return this;
    }
}

