/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import java.util.Optional;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.MountTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.MountBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Openapi;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.TraitsBuilder;
import org.apache.camel.util.ObjectHelper;

public class OpenApiTrait
extends BaseTrait {
    public OpenApiTrait() {
        super("openapi", 1611);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        Openapi openApiTrait = Optional.ofNullable(traitConfig.getOpenapi()).orElseGet(Openapi::new);
        if (openApiTrait.getConfigmaps() != null) {
            for (String resource : openApiTrait.getConfigmaps()) {
                if (resource.startsWith("configmap:")) continue;
                throw new RuntimeCamelException("Unsupported resource %s, must be a configmap".formatted(resource));
            }
        }
        return true;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Openapi openApiTrait = Optional.ofNullable(traitConfig.getOpenapi()).orElseGet(Openapi::new);
        if (ObjectHelper.isNotEmpty(openApiTrait.getConfigmaps())) {
            MountTrait delegate = new MountTrait();
            delegate.apply(TraitsBuilder.traits().withMount(MountBuilder.mount().withResources(openApiTrait.getConfigmaps())).build(), context);
        }
    }
}

